/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagent.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * &gt;Contains configurations for context to use during query generation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class QueryGenerationContext implements SdkPojo, Serializable,
        ToCopyableBuilder<QueryGenerationContext.Builder, QueryGenerationContext> {
    private static final SdkField<List<QueryGenerationTable>> TABLES_FIELD = SdkField
            .<List<QueryGenerationTable>> builder(MarshallingType.LIST)
            .memberName("tables")
            .getter(getter(QueryGenerationContext::tables))
            .setter(setter(Builder::tables))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tables").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<QueryGenerationTable> builder(MarshallingType.SDK_POJO)
                                            .constructor(QueryGenerationTable::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<CuratedQuery>> CURATED_QUERIES_FIELD = SdkField
            .<List<CuratedQuery>> builder(MarshallingType.LIST)
            .memberName("curatedQueries")
            .getter(getter(QueryGenerationContext::curatedQueries))
            .setter(setter(Builder::curatedQueries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("curatedQueries").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CuratedQuery> builder(MarshallingType.SDK_POJO)
                                            .constructor(CuratedQuery::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TABLES_FIELD,
            CURATED_QUERIES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<QueryGenerationTable> tables;

    private final List<CuratedQuery> curatedQueries;

    private QueryGenerationContext(BuilderImpl builder) {
        this.tables = builder.tables;
        this.curatedQueries = builder.curatedQueries;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tables property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasTables() {
        return tables != null && !(tables instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of objects, each of which defines information about a table in the database.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTables} method.
     * </p>
     * 
     * @return An array of objects, each of which defines information about a table in the database.
     */
    public final List<QueryGenerationTable> tables() {
        return tables;
    }

    /**
     * For responses, this returns true if the service returned a value for the CuratedQueries property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasCuratedQueries() {
        return curatedQueries != null && !(curatedQueries instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of objects, each of which defines information about example queries to help the query engine generate
     * appropriate SQL queries.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCuratedQueries} method.
     * </p>
     * 
     * @return An array of objects, each of which defines information about example queries to help the query engine
     *         generate appropriate SQL queries.
     */
    public final List<CuratedQuery> curatedQueries() {
        return curatedQueries;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasTables() ? tables() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasCuratedQueries() ? curatedQueries() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof QueryGenerationContext)) {
            return false;
        }
        QueryGenerationContext other = (QueryGenerationContext) obj;
        return hasTables() == other.hasTables() && Objects.equals(tables(), other.tables())
                && hasCuratedQueries() == other.hasCuratedQueries() && Objects.equals(curatedQueries(), other.curatedQueries());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("QueryGenerationContext").add("Tables", hasTables() ? tables() : null)
                .add("CuratedQueries", hasCuratedQueries() ? curatedQueries() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "tables":
            return Optional.ofNullable(clazz.cast(tables()));
        case "curatedQueries":
            return Optional.ofNullable(clazz.cast(curatedQueries()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("tables", TABLES_FIELD);
        map.put("curatedQueries", CURATED_QUERIES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<QueryGenerationContext, T> g) {
        return obj -> g.apply((QueryGenerationContext) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, QueryGenerationContext> {
        /**
         * <p>
         * An array of objects, each of which defines information about a table in the database.
         * </p>
         * 
         * @param tables
         *        An array of objects, each of which defines information about a table in the database.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tables(Collection<QueryGenerationTable> tables);

        /**
         * <p>
         * An array of objects, each of which defines information about a table in the database.
         * </p>
         * 
         * @param tables
         *        An array of objects, each of which defines information about a table in the database.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tables(QueryGenerationTable... tables);

        /**
         * <p>
         * An array of objects, each of which defines information about a table in the database.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.bedrockagent.model.QueryGenerationTable.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.bedrockagent.model.QueryGenerationTable#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.bedrockagent.model.QueryGenerationTable.Builder#build()} is called
         * immediately and its result is passed to {@link #tables(List<QueryGenerationTable>)}.
         * 
         * @param tables
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.bedrockagent.model.QueryGenerationTable.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tables(java.util.Collection<QueryGenerationTable>)
         */
        Builder tables(Consumer<QueryGenerationTable.Builder>... tables);

        /**
         * <p>
         * An array of objects, each of which defines information about example queries to help the query engine
         * generate appropriate SQL queries.
         * </p>
         * 
         * @param curatedQueries
         *        An array of objects, each of which defines information about example queries to help the query engine
         *        generate appropriate SQL queries.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder curatedQueries(Collection<CuratedQuery> curatedQueries);

        /**
         * <p>
         * An array of objects, each of which defines information about example queries to help the query engine
         * generate appropriate SQL queries.
         * </p>
         * 
         * @param curatedQueries
         *        An array of objects, each of which defines information about example queries to help the query engine
         *        generate appropriate SQL queries.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder curatedQueries(CuratedQuery... curatedQueries);

        /**
         * <p>
         * An array of objects, each of which defines information about example queries to help the query engine
         * generate appropriate SQL queries.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.bedrockagent.model.CuratedQuery.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.bedrockagent.model.CuratedQuery#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.bedrockagent.model.CuratedQuery.Builder#build()} is called immediately
         * and its result is passed to {@link #curatedQueries(List<CuratedQuery>)}.
         * 
         * @param curatedQueries
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.bedrockagent.model.CuratedQuery.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #curatedQueries(java.util.Collection<CuratedQuery>)
         */
        Builder curatedQueries(Consumer<CuratedQuery.Builder>... curatedQueries);
    }

    static final class BuilderImpl implements Builder {
        private List<QueryGenerationTable> tables = DefaultSdkAutoConstructList.getInstance();

        private List<CuratedQuery> curatedQueries = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(QueryGenerationContext model) {
            tables(model.tables);
            curatedQueries(model.curatedQueries);
        }

        public final List<QueryGenerationTable.Builder> getTables() {
            List<QueryGenerationTable.Builder> result = QueryGenerationTablesCopier.copyToBuilder(this.tables);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTables(Collection<QueryGenerationTable.BuilderImpl> tables) {
            this.tables = QueryGenerationTablesCopier.copyFromBuilder(tables);
        }

        @Override
        public final Builder tables(Collection<QueryGenerationTable> tables) {
            this.tables = QueryGenerationTablesCopier.copy(tables);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tables(QueryGenerationTable... tables) {
            tables(Arrays.asList(tables));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tables(Consumer<QueryGenerationTable.Builder>... tables) {
            tables(Stream.of(tables).map(c -> QueryGenerationTable.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<CuratedQuery.Builder> getCuratedQueries() {
            List<CuratedQuery.Builder> result = CuratedQueriesCopier.copyToBuilder(this.curatedQueries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCuratedQueries(Collection<CuratedQuery.BuilderImpl> curatedQueries) {
            this.curatedQueries = CuratedQueriesCopier.copyFromBuilder(curatedQueries);
        }

        @Override
        public final Builder curatedQueries(Collection<CuratedQuery> curatedQueries) {
            this.curatedQueries = CuratedQueriesCopier.copy(curatedQueries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder curatedQueries(CuratedQuery... curatedQueries) {
            curatedQueries(Arrays.asList(curatedQueries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder curatedQueries(Consumer<CuratedQuery.Builder>... curatedQueries) {
            curatedQueries(Stream.of(curatedQueries).map(c -> CuratedQuery.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public QueryGenerationContext build() {
            return new QueryGenerationContext(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
