/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagent.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the names of the fields to which to map information about the vector store.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class OpenSearchServerlessFieldMapping implements SdkPojo, Serializable,
        ToCopyableBuilder<OpenSearchServerlessFieldMapping.Builder, OpenSearchServerlessFieldMapping> {
    private static final SdkField<String> VECTOR_FIELD_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("vectorField").getter(getter(OpenSearchServerlessFieldMapping::vectorField))
            .setter(setter(Builder::vectorField))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vectorField").build()).build();

    private static final SdkField<String> TEXT_FIELD_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("textField").getter(getter(OpenSearchServerlessFieldMapping::textField))
            .setter(setter(Builder::textField))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("textField").build()).build();

    private static final SdkField<String> METADATA_FIELD_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("metadataField").getter(getter(OpenSearchServerlessFieldMapping::metadataField))
            .setter(setter(Builder::metadataField))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metadataField").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VECTOR_FIELD_FIELD,
            TEXT_FIELD_FIELD, METADATA_FIELD_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String vectorField;

    private final String textField;

    private final String metadataField;

    private OpenSearchServerlessFieldMapping(BuilderImpl builder) {
        this.vectorField = builder.vectorField;
        this.textField = builder.textField;
        this.metadataField = builder.metadataField;
    }

    /**
     * <p>
     * The name of the field in which Amazon Bedrock stores the vector embeddings for your data sources.
     * </p>
     * 
     * @return The name of the field in which Amazon Bedrock stores the vector embeddings for your data sources.
     */
    public final String vectorField() {
        return vectorField;
    }

    /**
     * <p>
     * The name of the field in which Amazon Bedrock stores the raw text from your data. The text is split according to
     * the chunking strategy you choose.
     * </p>
     * 
     * @return The name of the field in which Amazon Bedrock stores the raw text from your data. The text is split
     *         according to the chunking strategy you choose.
     */
    public final String textField() {
        return textField;
    }

    /**
     * <p>
     * The name of the field in which Amazon Bedrock stores metadata about the vector store.
     * </p>
     * 
     * @return The name of the field in which Amazon Bedrock stores metadata about the vector store.
     */
    public final String metadataField() {
        return metadataField;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(vectorField());
        hashCode = 31 * hashCode + Objects.hashCode(textField());
        hashCode = 31 * hashCode + Objects.hashCode(metadataField());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OpenSearchServerlessFieldMapping)) {
            return false;
        }
        OpenSearchServerlessFieldMapping other = (OpenSearchServerlessFieldMapping) obj;
        return Objects.equals(vectorField(), other.vectorField()) && Objects.equals(textField(), other.textField())
                && Objects.equals(metadataField(), other.metadataField());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("OpenSearchServerlessFieldMapping").add("VectorField", vectorField())
                .add("TextField", textField()).add("MetadataField", metadataField()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "vectorField":
            return Optional.ofNullable(clazz.cast(vectorField()));
        case "textField":
            return Optional.ofNullable(clazz.cast(textField()));
        case "metadataField":
            return Optional.ofNullable(clazz.cast(metadataField()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("vectorField", VECTOR_FIELD_FIELD);
        map.put("textField", TEXT_FIELD_FIELD);
        map.put("metadataField", METADATA_FIELD_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<OpenSearchServerlessFieldMapping, T> g) {
        return obj -> g.apply((OpenSearchServerlessFieldMapping) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, OpenSearchServerlessFieldMapping> {
        /**
         * <p>
         * The name of the field in which Amazon Bedrock stores the vector embeddings for your data sources.
         * </p>
         * 
         * @param vectorField
         *        The name of the field in which Amazon Bedrock stores the vector embeddings for your data sources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vectorField(String vectorField);

        /**
         * <p>
         * The name of the field in which Amazon Bedrock stores the raw text from your data. The text is split according
         * to the chunking strategy you choose.
         * </p>
         * 
         * @param textField
         *        The name of the field in which Amazon Bedrock stores the raw text from your data. The text is split
         *        according to the chunking strategy you choose.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder textField(String textField);

        /**
         * <p>
         * The name of the field in which Amazon Bedrock stores metadata about the vector store.
         * </p>
         * 
         * @param metadataField
         *        The name of the field in which Amazon Bedrock stores metadata about the vector store.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metadataField(String metadataField);
    }

    static final class BuilderImpl implements Builder {
        private String vectorField;

        private String textField;

        private String metadataField;

        private BuilderImpl() {
        }

        private BuilderImpl(OpenSearchServerlessFieldMapping model) {
            vectorField(model.vectorField);
            textField(model.textField);
            metadataField(model.metadataField);
        }

        public final String getVectorField() {
            return vectorField;
        }

        public final void setVectorField(String vectorField) {
            this.vectorField = vectorField;
        }

        @Override
        public final Builder vectorField(String vectorField) {
            this.vectorField = vectorField;
            return this;
        }

        public final String getTextField() {
            return textField;
        }

        public final void setTextField(String textField) {
            this.textField = textField;
        }

        @Override
        public final Builder textField(String textField) {
            this.textField = textField;
            return this;
        }

        public final String getMetadataField() {
            return metadataField;
        }

        public final void setMetadataField(String metadataField) {
            this.metadataField = metadataField;
        }

        @Override
        public final Builder metadataField(String metadataField) {
            this.metadataField = metadataField;
            return this;
        }

        @Override
        public OpenSearchServerlessFieldMapping build() {
            return new OpenSearchServerlessFieldMapping(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
