/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagent.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the details for a document that was ingested or deleted.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class KnowledgeBaseDocumentDetail implements SdkPojo, Serializable,
        ToCopyableBuilder<KnowledgeBaseDocumentDetail.Builder, KnowledgeBaseDocumentDetail> {
    private static final SdkField<String> KNOWLEDGE_BASE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("knowledgeBaseId").getter(getter(KnowledgeBaseDocumentDetail::knowledgeBaseId))
            .setter(setter(Builder::knowledgeBaseId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("knowledgeBaseId").build()).build();

    private static final SdkField<String> DATA_SOURCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("dataSourceId").getter(getter(KnowledgeBaseDocumentDetail::dataSourceId))
            .setter(setter(Builder::dataSourceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataSourceId").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(KnowledgeBaseDocumentDetail::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<DocumentIdentifier> IDENTIFIER_FIELD = SdkField
            .<DocumentIdentifier> builder(MarshallingType.SDK_POJO).memberName("identifier")
            .getter(getter(KnowledgeBaseDocumentDetail::identifier)).setter(setter(Builder::identifier))
            .constructor(DocumentIdentifier::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("identifier").build()).build();

    private static final SdkField<String> STATUS_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("statusReason").getter(getter(KnowledgeBaseDocumentDetail::statusReason))
            .setter(setter(Builder::statusReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusReason").build()).build();

    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("updatedAt")
            .getter(getter(KnowledgeBaseDocumentDetail::updatedAt))
            .setter(setter(Builder::updatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KNOWLEDGE_BASE_ID_FIELD,
            DATA_SOURCE_ID_FIELD, STATUS_FIELD, IDENTIFIER_FIELD, STATUS_REASON_FIELD, UPDATED_AT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String knowledgeBaseId;

    private final String dataSourceId;

    private final String status;

    private final DocumentIdentifier identifier;

    private final String statusReason;

    private final Instant updatedAt;

    private KnowledgeBaseDocumentDetail(BuilderImpl builder) {
        this.knowledgeBaseId = builder.knowledgeBaseId;
        this.dataSourceId = builder.dataSourceId;
        this.status = builder.status;
        this.identifier = builder.identifier;
        this.statusReason = builder.statusReason;
        this.updatedAt = builder.updatedAt;
    }

    /**
     * <p>
     * The identifier of the knowledge base that the document was ingested into or deleted from.
     * </p>
     * 
     * @return The identifier of the knowledge base that the document was ingested into or deleted from.
     */
    public final String knowledgeBaseId() {
        return knowledgeBaseId;
    }

    /**
     * <p>
     * The identifier of the data source connected to the knowledge base that the document was ingested into or deleted
     * from.
     * </p>
     * 
     * @return The identifier of the data source connected to the knowledge base that the document was ingested into or
     *         deleted from.
     */
    public final String dataSourceId() {
        return dataSourceId;
    }

    /**
     * <p>
     * The ingestion status of the document. The following statuses are possible:
     * </p>
     * <ul>
     * <li>
     * <p>
     * STARTING – You submitted the ingestion job containing the document.
     * </p>
     * </li>
     * <li>
     * <p>
     * PENDING – The document is waiting to be ingested.
     * </p>
     * </li>
     * <li>
     * <p>
     * IN_PROGRESS – The document is being ingested.
     * </p>
     * </li>
     * <li>
     * <p>
     * INDEXED – The document was successfully indexed.
     * </p>
     * </li>
     * <li>
     * <p>
     * PARTIALLY_INDEXED – The document was partially indexed.
     * </p>
     * </li>
     * <li>
     * <p>
     * METADATA_PARTIALLY_INDEXED – You submitted metadata for an existing document and it was partially indexed.
     * </p>
     * </li>
     * <li>
     * <p>
     * METADATA_UPDATE_FAILED – You submitted a metadata update for an existing document but it failed.
     * </p>
     * </li>
     * <li>
     * <p>
     * FAILED – The document failed to be ingested.
     * </p>
     * </li>
     * <li>
     * <p>
     * NOT_FOUND – The document wasn't found.
     * </p>
     * </li>
     * <li>
     * <p>
     * IGNORED – The document was ignored during ingestion.
     * </p>
     * </li>
     * <li>
     * <p>
     * DELETING – You submitted the delete job containing the document.
     * </p>
     * </li>
     * <li>
     * <p>
     * DELETE_IN_PROGRESS – The document is being deleted.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link DocumentStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The ingestion status of the document. The following statuses are possible:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         STARTING – You submitted the ingestion job containing the document.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         PENDING – The document is waiting to be ingested.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         IN_PROGRESS – The document is being ingested.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INDEXED – The document was successfully indexed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         PARTIALLY_INDEXED – The document was partially indexed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         METADATA_PARTIALLY_INDEXED – You submitted metadata for an existing document and it was partially
     *         indexed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         METADATA_UPDATE_FAILED – You submitted a metadata update for an existing document but it failed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         FAILED – The document failed to be ingested.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         NOT_FOUND – The document wasn't found.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         IGNORED – The document was ignored during ingestion.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         DELETING – You submitted the delete job containing the document.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         DELETE_IN_PROGRESS – The document is being deleted.
     *         </p>
     *         </li>
     * @see DocumentStatus
     */
    public final DocumentStatus status() {
        return DocumentStatus.fromValue(status);
    }

    /**
     * <p>
     * The ingestion status of the document. The following statuses are possible:
     * </p>
     * <ul>
     * <li>
     * <p>
     * STARTING – You submitted the ingestion job containing the document.
     * </p>
     * </li>
     * <li>
     * <p>
     * PENDING – The document is waiting to be ingested.
     * </p>
     * </li>
     * <li>
     * <p>
     * IN_PROGRESS – The document is being ingested.
     * </p>
     * </li>
     * <li>
     * <p>
     * INDEXED – The document was successfully indexed.
     * </p>
     * </li>
     * <li>
     * <p>
     * PARTIALLY_INDEXED – The document was partially indexed.
     * </p>
     * </li>
     * <li>
     * <p>
     * METADATA_PARTIALLY_INDEXED – You submitted metadata for an existing document and it was partially indexed.
     * </p>
     * </li>
     * <li>
     * <p>
     * METADATA_UPDATE_FAILED – You submitted a metadata update for an existing document but it failed.
     * </p>
     * </li>
     * <li>
     * <p>
     * FAILED – The document failed to be ingested.
     * </p>
     * </li>
     * <li>
     * <p>
     * NOT_FOUND – The document wasn't found.
     * </p>
     * </li>
     * <li>
     * <p>
     * IGNORED – The document was ignored during ingestion.
     * </p>
     * </li>
     * <li>
     * <p>
     * DELETING – You submitted the delete job containing the document.
     * </p>
     * </li>
     * <li>
     * <p>
     * DELETE_IN_PROGRESS – The document is being deleted.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link DocumentStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The ingestion status of the document. The following statuses are possible:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         STARTING – You submitted the ingestion job containing the document.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         PENDING – The document is waiting to be ingested.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         IN_PROGRESS – The document is being ingested.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INDEXED – The document was successfully indexed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         PARTIALLY_INDEXED – The document was partially indexed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         METADATA_PARTIALLY_INDEXED – You submitted metadata for an existing document and it was partially
     *         indexed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         METADATA_UPDATE_FAILED – You submitted a metadata update for an existing document but it failed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         FAILED – The document failed to be ingested.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         NOT_FOUND – The document wasn't found.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         IGNORED – The document was ignored during ingestion.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         DELETING – You submitted the delete job containing the document.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         DELETE_IN_PROGRESS – The document is being deleted.
     *         </p>
     *         </li>
     * @see DocumentStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * Contains information that identifies the document.
     * </p>
     * 
     * @return Contains information that identifies the document.
     */
    public final DocumentIdentifier identifier() {
        return identifier;
    }

    /**
     * <p>
     * The reason for the status. Appears alongside the status <code>IGNORED</code>.
     * </p>
     * 
     * @return The reason for the status. Appears alongside the status <code>IGNORED</code>.
     */
    public final String statusReason() {
        return statusReason;
    }

    /**
     * <p>
     * The date and time at which the document was last updated.
     * </p>
     * 
     * @return The date and time at which the document was last updated.
     */
    public final Instant updatedAt() {
        return updatedAt;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(knowledgeBaseId());
        hashCode = 31 * hashCode + Objects.hashCode(dataSourceId());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(identifier());
        hashCode = 31 * hashCode + Objects.hashCode(statusReason());
        hashCode = 31 * hashCode + Objects.hashCode(updatedAt());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof KnowledgeBaseDocumentDetail)) {
            return false;
        }
        KnowledgeBaseDocumentDetail other = (KnowledgeBaseDocumentDetail) obj;
        return Objects.equals(knowledgeBaseId(), other.knowledgeBaseId()) && Objects.equals(dataSourceId(), other.dataSourceId())
                && Objects.equals(statusAsString(), other.statusAsString()) && Objects.equals(identifier(), other.identifier())
                && Objects.equals(statusReason(), other.statusReason()) && Objects.equals(updatedAt(), other.updatedAt());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("KnowledgeBaseDocumentDetail").add("KnowledgeBaseId", knowledgeBaseId())
                .add("DataSourceId", dataSourceId()).add("Status", statusAsString()).add("Identifier", identifier())
                .add("StatusReason", statusReason()).add("UpdatedAt", updatedAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "knowledgeBaseId":
            return Optional.ofNullable(clazz.cast(knowledgeBaseId()));
        case "dataSourceId":
            return Optional.ofNullable(clazz.cast(dataSourceId()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "identifier":
            return Optional.ofNullable(clazz.cast(identifier()));
        case "statusReason":
            return Optional.ofNullable(clazz.cast(statusReason()));
        case "updatedAt":
            return Optional.ofNullable(clazz.cast(updatedAt()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("knowledgeBaseId", KNOWLEDGE_BASE_ID_FIELD);
        map.put("dataSourceId", DATA_SOURCE_ID_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("identifier", IDENTIFIER_FIELD);
        map.put("statusReason", STATUS_REASON_FIELD);
        map.put("updatedAt", UPDATED_AT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<KnowledgeBaseDocumentDetail, T> g) {
        return obj -> g.apply((KnowledgeBaseDocumentDetail) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, KnowledgeBaseDocumentDetail> {
        /**
         * <p>
         * The identifier of the knowledge base that the document was ingested into or deleted from.
         * </p>
         * 
         * @param knowledgeBaseId
         *        The identifier of the knowledge base that the document was ingested into or deleted from.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder knowledgeBaseId(String knowledgeBaseId);

        /**
         * <p>
         * The identifier of the data source connected to the knowledge base that the document was ingested into or
         * deleted from.
         * </p>
         * 
         * @param dataSourceId
         *        The identifier of the data source connected to the knowledge base that the document was ingested into
         *        or deleted from.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataSourceId(String dataSourceId);

        /**
         * <p>
         * The ingestion status of the document. The following statuses are possible:
         * </p>
         * <ul>
         * <li>
         * <p>
         * STARTING – You submitted the ingestion job containing the document.
         * </p>
         * </li>
         * <li>
         * <p>
         * PENDING – The document is waiting to be ingested.
         * </p>
         * </li>
         * <li>
         * <p>
         * IN_PROGRESS – The document is being ingested.
         * </p>
         * </li>
         * <li>
         * <p>
         * INDEXED – The document was successfully indexed.
         * </p>
         * </li>
         * <li>
         * <p>
         * PARTIALLY_INDEXED – The document was partially indexed.
         * </p>
         * </li>
         * <li>
         * <p>
         * METADATA_PARTIALLY_INDEXED – You submitted metadata for an existing document and it was partially indexed.
         * </p>
         * </li>
         * <li>
         * <p>
         * METADATA_UPDATE_FAILED – You submitted a metadata update for an existing document but it failed.
         * </p>
         * </li>
         * <li>
         * <p>
         * FAILED – The document failed to be ingested.
         * </p>
         * </li>
         * <li>
         * <p>
         * NOT_FOUND – The document wasn't found.
         * </p>
         * </li>
         * <li>
         * <p>
         * IGNORED – The document was ignored during ingestion.
         * </p>
         * </li>
         * <li>
         * <p>
         * DELETING – You submitted the delete job containing the document.
         * </p>
         * </li>
         * <li>
         * <p>
         * DELETE_IN_PROGRESS – The document is being deleted.
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        The ingestion status of the document. The following statuses are possible:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        STARTING – You submitted the ingestion job containing the document.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        PENDING – The document is waiting to be ingested.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        IN_PROGRESS – The document is being ingested.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        INDEXED – The document was successfully indexed.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        PARTIALLY_INDEXED – The document was partially indexed.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        METADATA_PARTIALLY_INDEXED – You submitted metadata for an existing document and it was partially
         *        indexed.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        METADATA_UPDATE_FAILED – You submitted a metadata update for an existing document but it failed.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        FAILED – The document failed to be ingested.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        NOT_FOUND – The document wasn't found.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        IGNORED – The document was ignored during ingestion.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        DELETING – You submitted the delete job containing the document.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        DELETE_IN_PROGRESS – The document is being deleted.
         *        </p>
         *        </li>
         * @see DocumentStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DocumentStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The ingestion status of the document. The following statuses are possible:
         * </p>
         * <ul>
         * <li>
         * <p>
         * STARTING – You submitted the ingestion job containing the document.
         * </p>
         * </li>
         * <li>
         * <p>
         * PENDING – The document is waiting to be ingested.
         * </p>
         * </li>
         * <li>
         * <p>
         * IN_PROGRESS – The document is being ingested.
         * </p>
         * </li>
         * <li>
         * <p>
         * INDEXED – The document was successfully indexed.
         * </p>
         * </li>
         * <li>
         * <p>
         * PARTIALLY_INDEXED – The document was partially indexed.
         * </p>
         * </li>
         * <li>
         * <p>
         * METADATA_PARTIALLY_INDEXED – You submitted metadata for an existing document and it was partially indexed.
         * </p>
         * </li>
         * <li>
         * <p>
         * METADATA_UPDATE_FAILED – You submitted a metadata update for an existing document but it failed.
         * </p>
         * </li>
         * <li>
         * <p>
         * FAILED – The document failed to be ingested.
         * </p>
         * </li>
         * <li>
         * <p>
         * NOT_FOUND – The document wasn't found.
         * </p>
         * </li>
         * <li>
         * <p>
         * IGNORED – The document was ignored during ingestion.
         * </p>
         * </li>
         * <li>
         * <p>
         * DELETING – You submitted the delete job containing the document.
         * </p>
         * </li>
         * <li>
         * <p>
         * DELETE_IN_PROGRESS – The document is being deleted.
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        The ingestion status of the document. The following statuses are possible:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        STARTING – You submitted the ingestion job containing the document.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        PENDING – The document is waiting to be ingested.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        IN_PROGRESS – The document is being ingested.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        INDEXED – The document was successfully indexed.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        PARTIALLY_INDEXED – The document was partially indexed.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        METADATA_PARTIALLY_INDEXED – You submitted metadata for an existing document and it was partially
         *        indexed.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        METADATA_UPDATE_FAILED – You submitted a metadata update for an existing document but it failed.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        FAILED – The document failed to be ingested.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        NOT_FOUND – The document wasn't found.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        IGNORED – The document was ignored during ingestion.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        DELETING – You submitted the delete job containing the document.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        DELETE_IN_PROGRESS – The document is being deleted.
         *        </p>
         *        </li>
         * @see DocumentStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DocumentStatus
         */
        Builder status(DocumentStatus status);

        /**
         * <p>
         * Contains information that identifies the document.
         * </p>
         * 
         * @param identifier
         *        Contains information that identifies the document.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identifier(DocumentIdentifier identifier);

        /**
         * <p>
         * Contains information that identifies the document.
         * </p>
         * This is a convenience method that creates an instance of the {@link DocumentIdentifier.Builder} avoiding the
         * need to create one manually via {@link DocumentIdentifier#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DocumentIdentifier.Builder#build()} is called immediately and its
         * result is passed to {@link #identifier(DocumentIdentifier)}.
         * 
         * @param identifier
         *        a consumer that will call methods on {@link DocumentIdentifier.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #identifier(DocumentIdentifier)
         */
        default Builder identifier(Consumer<DocumentIdentifier.Builder> identifier) {
            return identifier(DocumentIdentifier.builder().applyMutation(identifier).build());
        }

        /**
         * <p>
         * The reason for the status. Appears alongside the status <code>IGNORED</code>.
         * </p>
         * 
         * @param statusReason
         *        The reason for the status. Appears alongside the status <code>IGNORED</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusReason(String statusReason);

        /**
         * <p>
         * The date and time at which the document was last updated.
         * </p>
         * 
         * @param updatedAt
         *        The date and time at which the document was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedAt(Instant updatedAt);
    }

    static final class BuilderImpl implements Builder {
        private String knowledgeBaseId;

        private String dataSourceId;

        private String status;

        private DocumentIdentifier identifier;

        private String statusReason;

        private Instant updatedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(KnowledgeBaseDocumentDetail model) {
            knowledgeBaseId(model.knowledgeBaseId);
            dataSourceId(model.dataSourceId);
            status(model.status);
            identifier(model.identifier);
            statusReason(model.statusReason);
            updatedAt(model.updatedAt);
        }

        public final String getKnowledgeBaseId() {
            return knowledgeBaseId;
        }

        public final void setKnowledgeBaseId(String knowledgeBaseId) {
            this.knowledgeBaseId = knowledgeBaseId;
        }

        @Override
        public final Builder knowledgeBaseId(String knowledgeBaseId) {
            this.knowledgeBaseId = knowledgeBaseId;
            return this;
        }

        public final String getDataSourceId() {
            return dataSourceId;
        }

        public final void setDataSourceId(String dataSourceId) {
            this.dataSourceId = dataSourceId;
        }

        @Override
        public final Builder dataSourceId(String dataSourceId) {
            this.dataSourceId = dataSourceId;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(DocumentStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final DocumentIdentifier.Builder getIdentifier() {
            return identifier != null ? identifier.toBuilder() : null;
        }

        public final void setIdentifier(DocumentIdentifier.BuilderImpl identifier) {
            this.identifier = identifier != null ? identifier.build() : null;
        }

        @Override
        public final Builder identifier(DocumentIdentifier identifier) {
            this.identifier = identifier;
            return this;
        }

        public final String getStatusReason() {
            return statusReason;
        }

        public final void setStatusReason(String statusReason) {
            this.statusReason = statusReason;
        }

        @Override
        public final Builder statusReason(String statusReason) {
            this.statusReason = statusReason;
            return this;
        }

        public final Instant getUpdatedAt() {
            return updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        @Override
        public KnowledgeBaseDocumentDetail build() {
            return new KnowledgeBaseDocumentDetail(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
