/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagent.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the statistics for the data ingestion job.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class IngestionJobStatistics implements SdkPojo, Serializable,
        ToCopyableBuilder<IngestionJobStatistics.Builder, IngestionJobStatistics> {
    private static final SdkField<Long> NUMBER_OF_DOCUMENTS_SCANNED_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("numberOfDocumentsScanned").getter(getter(IngestionJobStatistics::numberOfDocumentsScanned))
            .setter(setter(Builder::numberOfDocumentsScanned))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("numberOfDocumentsScanned").build())
            .build();

    private static final SdkField<Long> NUMBER_OF_METADATA_DOCUMENTS_SCANNED_FIELD = SdkField
            .<Long> builder(MarshallingType.LONG)
            .memberName("numberOfMetadataDocumentsScanned")
            .getter(getter(IngestionJobStatistics::numberOfMetadataDocumentsScanned))
            .setter(setter(Builder::numberOfMetadataDocumentsScanned))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("numberOfMetadataDocumentsScanned")
                    .build()).build();

    private static final SdkField<Long> NUMBER_OF_NEW_DOCUMENTS_INDEXED_FIELD = SdkField
            .<Long> builder(MarshallingType.LONG)
            .memberName("numberOfNewDocumentsIndexed")
            .getter(getter(IngestionJobStatistics::numberOfNewDocumentsIndexed))
            .setter(setter(Builder::numberOfNewDocumentsIndexed))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("numberOfNewDocumentsIndexed")
                    .build()).build();

    private static final SdkField<Long> NUMBER_OF_MODIFIED_DOCUMENTS_INDEXED_FIELD = SdkField
            .<Long> builder(MarshallingType.LONG)
            .memberName("numberOfModifiedDocumentsIndexed")
            .getter(getter(IngestionJobStatistics::numberOfModifiedDocumentsIndexed))
            .setter(setter(Builder::numberOfModifiedDocumentsIndexed))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("numberOfModifiedDocumentsIndexed")
                    .build()).build();

    private static final SdkField<Long> NUMBER_OF_METADATA_DOCUMENTS_MODIFIED_FIELD = SdkField
            .<Long> builder(MarshallingType.LONG)
            .memberName("numberOfMetadataDocumentsModified")
            .getter(getter(IngestionJobStatistics::numberOfMetadataDocumentsModified))
            .setter(setter(Builder::numberOfMetadataDocumentsModified))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("numberOfMetadataDocumentsModified")
                    .build()).build();

    private static final SdkField<Long> NUMBER_OF_DOCUMENTS_DELETED_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("numberOfDocumentsDeleted").getter(getter(IngestionJobStatistics::numberOfDocumentsDeleted))
            .setter(setter(Builder::numberOfDocumentsDeleted))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("numberOfDocumentsDeleted").build())
            .build();

    private static final SdkField<Long> NUMBER_OF_DOCUMENTS_FAILED_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("numberOfDocumentsFailed").getter(getter(IngestionJobStatistics::numberOfDocumentsFailed))
            .setter(setter(Builder::numberOfDocumentsFailed))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("numberOfDocumentsFailed").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            NUMBER_OF_DOCUMENTS_SCANNED_FIELD, NUMBER_OF_METADATA_DOCUMENTS_SCANNED_FIELD, NUMBER_OF_NEW_DOCUMENTS_INDEXED_FIELD,
            NUMBER_OF_MODIFIED_DOCUMENTS_INDEXED_FIELD, NUMBER_OF_METADATA_DOCUMENTS_MODIFIED_FIELD,
            NUMBER_OF_DOCUMENTS_DELETED_FIELD, NUMBER_OF_DOCUMENTS_FAILED_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Long numberOfDocumentsScanned;

    private final Long numberOfMetadataDocumentsScanned;

    private final Long numberOfNewDocumentsIndexed;

    private final Long numberOfModifiedDocumentsIndexed;

    private final Long numberOfMetadataDocumentsModified;

    private final Long numberOfDocumentsDeleted;

    private final Long numberOfDocumentsFailed;

    private IngestionJobStatistics(BuilderImpl builder) {
        this.numberOfDocumentsScanned = builder.numberOfDocumentsScanned;
        this.numberOfMetadataDocumentsScanned = builder.numberOfMetadataDocumentsScanned;
        this.numberOfNewDocumentsIndexed = builder.numberOfNewDocumentsIndexed;
        this.numberOfModifiedDocumentsIndexed = builder.numberOfModifiedDocumentsIndexed;
        this.numberOfMetadataDocumentsModified = builder.numberOfMetadataDocumentsModified;
        this.numberOfDocumentsDeleted = builder.numberOfDocumentsDeleted;
        this.numberOfDocumentsFailed = builder.numberOfDocumentsFailed;
    }

    /**
     * <p>
     * The total number of source documents that were scanned. Includes new, updated, and unchanged documents.
     * </p>
     * 
     * @return The total number of source documents that were scanned. Includes new, updated, and unchanged documents.
     */
    public final Long numberOfDocumentsScanned() {
        return numberOfDocumentsScanned;
    }

    /**
     * <p>
     * The total number of metadata files that were scanned. Includes new, updated, and unchanged files.
     * </p>
     * 
     * @return The total number of metadata files that were scanned. Includes new, updated, and unchanged files.
     */
    public final Long numberOfMetadataDocumentsScanned() {
        return numberOfMetadataDocumentsScanned;
    }

    /**
     * <p>
     * The number of new source documents in the data source that were successfully indexed.
     * </p>
     * 
     * @return The number of new source documents in the data source that were successfully indexed.
     */
    public final Long numberOfNewDocumentsIndexed() {
        return numberOfNewDocumentsIndexed;
    }

    /**
     * <p>
     * The number of modified source documents in the data source that were successfully indexed.
     * </p>
     * 
     * @return The number of modified source documents in the data source that were successfully indexed.
     */
    public final Long numberOfModifiedDocumentsIndexed() {
        return numberOfModifiedDocumentsIndexed;
    }

    /**
     * <p>
     * The number of metadata files that were updated or deleted.
     * </p>
     * 
     * @return The number of metadata files that were updated or deleted.
     */
    public final Long numberOfMetadataDocumentsModified() {
        return numberOfMetadataDocumentsModified;
    }

    /**
     * <p>
     * The number of source documents that were deleted.
     * </p>
     * 
     * @return The number of source documents that were deleted.
     */
    public final Long numberOfDocumentsDeleted() {
        return numberOfDocumentsDeleted;
    }

    /**
     * <p>
     * The number of source documents that failed to be ingested.
     * </p>
     * 
     * @return The number of source documents that failed to be ingested.
     */
    public final Long numberOfDocumentsFailed() {
        return numberOfDocumentsFailed;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(numberOfDocumentsScanned());
        hashCode = 31 * hashCode + Objects.hashCode(numberOfMetadataDocumentsScanned());
        hashCode = 31 * hashCode + Objects.hashCode(numberOfNewDocumentsIndexed());
        hashCode = 31 * hashCode + Objects.hashCode(numberOfModifiedDocumentsIndexed());
        hashCode = 31 * hashCode + Objects.hashCode(numberOfMetadataDocumentsModified());
        hashCode = 31 * hashCode + Objects.hashCode(numberOfDocumentsDeleted());
        hashCode = 31 * hashCode + Objects.hashCode(numberOfDocumentsFailed());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IngestionJobStatistics)) {
            return false;
        }
        IngestionJobStatistics other = (IngestionJobStatistics) obj;
        return Objects.equals(numberOfDocumentsScanned(), other.numberOfDocumentsScanned())
                && Objects.equals(numberOfMetadataDocumentsScanned(), other.numberOfMetadataDocumentsScanned())
                && Objects.equals(numberOfNewDocumentsIndexed(), other.numberOfNewDocumentsIndexed())
                && Objects.equals(numberOfModifiedDocumentsIndexed(), other.numberOfModifiedDocumentsIndexed())
                && Objects.equals(numberOfMetadataDocumentsModified(), other.numberOfMetadataDocumentsModified())
                && Objects.equals(numberOfDocumentsDeleted(), other.numberOfDocumentsDeleted())
                && Objects.equals(numberOfDocumentsFailed(), other.numberOfDocumentsFailed());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("IngestionJobStatistics").add("NumberOfDocumentsScanned", numberOfDocumentsScanned())
                .add("NumberOfMetadataDocumentsScanned", numberOfMetadataDocumentsScanned())
                .add("NumberOfNewDocumentsIndexed", numberOfNewDocumentsIndexed())
                .add("NumberOfModifiedDocumentsIndexed", numberOfModifiedDocumentsIndexed())
                .add("NumberOfMetadataDocumentsModified", numberOfMetadataDocumentsModified())
                .add("NumberOfDocumentsDeleted", numberOfDocumentsDeleted())
                .add("NumberOfDocumentsFailed", numberOfDocumentsFailed()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "numberOfDocumentsScanned":
            return Optional.ofNullable(clazz.cast(numberOfDocumentsScanned()));
        case "numberOfMetadataDocumentsScanned":
            return Optional.ofNullable(clazz.cast(numberOfMetadataDocumentsScanned()));
        case "numberOfNewDocumentsIndexed":
            return Optional.ofNullable(clazz.cast(numberOfNewDocumentsIndexed()));
        case "numberOfModifiedDocumentsIndexed":
            return Optional.ofNullable(clazz.cast(numberOfModifiedDocumentsIndexed()));
        case "numberOfMetadataDocumentsModified":
            return Optional.ofNullable(clazz.cast(numberOfMetadataDocumentsModified()));
        case "numberOfDocumentsDeleted":
            return Optional.ofNullable(clazz.cast(numberOfDocumentsDeleted()));
        case "numberOfDocumentsFailed":
            return Optional.ofNullable(clazz.cast(numberOfDocumentsFailed()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("numberOfDocumentsScanned", NUMBER_OF_DOCUMENTS_SCANNED_FIELD);
        map.put("numberOfMetadataDocumentsScanned", NUMBER_OF_METADATA_DOCUMENTS_SCANNED_FIELD);
        map.put("numberOfNewDocumentsIndexed", NUMBER_OF_NEW_DOCUMENTS_INDEXED_FIELD);
        map.put("numberOfModifiedDocumentsIndexed", NUMBER_OF_MODIFIED_DOCUMENTS_INDEXED_FIELD);
        map.put("numberOfMetadataDocumentsModified", NUMBER_OF_METADATA_DOCUMENTS_MODIFIED_FIELD);
        map.put("numberOfDocumentsDeleted", NUMBER_OF_DOCUMENTS_DELETED_FIELD);
        map.put("numberOfDocumentsFailed", NUMBER_OF_DOCUMENTS_FAILED_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<IngestionJobStatistics, T> g) {
        return obj -> g.apply((IngestionJobStatistics) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, IngestionJobStatistics> {
        /**
         * <p>
         * The total number of source documents that were scanned. Includes new, updated, and unchanged documents.
         * </p>
         * 
         * @param numberOfDocumentsScanned
         *        The total number of source documents that were scanned. Includes new, updated, and unchanged
         *        documents.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numberOfDocumentsScanned(Long numberOfDocumentsScanned);

        /**
         * <p>
         * The total number of metadata files that were scanned. Includes new, updated, and unchanged files.
         * </p>
         * 
         * @param numberOfMetadataDocumentsScanned
         *        The total number of metadata files that were scanned. Includes new, updated, and unchanged files.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numberOfMetadataDocumentsScanned(Long numberOfMetadataDocumentsScanned);

        /**
         * <p>
         * The number of new source documents in the data source that were successfully indexed.
         * </p>
         * 
         * @param numberOfNewDocumentsIndexed
         *        The number of new source documents in the data source that were successfully indexed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numberOfNewDocumentsIndexed(Long numberOfNewDocumentsIndexed);

        /**
         * <p>
         * The number of modified source documents in the data source that were successfully indexed.
         * </p>
         * 
         * @param numberOfModifiedDocumentsIndexed
         *        The number of modified source documents in the data source that were successfully indexed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numberOfModifiedDocumentsIndexed(Long numberOfModifiedDocumentsIndexed);

        /**
         * <p>
         * The number of metadata files that were updated or deleted.
         * </p>
         * 
         * @param numberOfMetadataDocumentsModified
         *        The number of metadata files that were updated or deleted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numberOfMetadataDocumentsModified(Long numberOfMetadataDocumentsModified);

        /**
         * <p>
         * The number of source documents that were deleted.
         * </p>
         * 
         * @param numberOfDocumentsDeleted
         *        The number of source documents that were deleted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numberOfDocumentsDeleted(Long numberOfDocumentsDeleted);

        /**
         * <p>
         * The number of source documents that failed to be ingested.
         * </p>
         * 
         * @param numberOfDocumentsFailed
         *        The number of source documents that failed to be ingested.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numberOfDocumentsFailed(Long numberOfDocumentsFailed);
    }

    static final class BuilderImpl implements Builder {
        private Long numberOfDocumentsScanned;

        private Long numberOfMetadataDocumentsScanned;

        private Long numberOfNewDocumentsIndexed;

        private Long numberOfModifiedDocumentsIndexed;

        private Long numberOfMetadataDocumentsModified;

        private Long numberOfDocumentsDeleted;

        private Long numberOfDocumentsFailed;

        private BuilderImpl() {
        }

        private BuilderImpl(IngestionJobStatistics model) {
            numberOfDocumentsScanned(model.numberOfDocumentsScanned);
            numberOfMetadataDocumentsScanned(model.numberOfMetadataDocumentsScanned);
            numberOfNewDocumentsIndexed(model.numberOfNewDocumentsIndexed);
            numberOfModifiedDocumentsIndexed(model.numberOfModifiedDocumentsIndexed);
            numberOfMetadataDocumentsModified(model.numberOfMetadataDocumentsModified);
            numberOfDocumentsDeleted(model.numberOfDocumentsDeleted);
            numberOfDocumentsFailed(model.numberOfDocumentsFailed);
        }

        public final Long getNumberOfDocumentsScanned() {
            return numberOfDocumentsScanned;
        }

        public final void setNumberOfDocumentsScanned(Long numberOfDocumentsScanned) {
            this.numberOfDocumentsScanned = numberOfDocumentsScanned;
        }

        @Override
        public final Builder numberOfDocumentsScanned(Long numberOfDocumentsScanned) {
            this.numberOfDocumentsScanned = numberOfDocumentsScanned;
            return this;
        }

        public final Long getNumberOfMetadataDocumentsScanned() {
            return numberOfMetadataDocumentsScanned;
        }

        public final void setNumberOfMetadataDocumentsScanned(Long numberOfMetadataDocumentsScanned) {
            this.numberOfMetadataDocumentsScanned = numberOfMetadataDocumentsScanned;
        }

        @Override
        public final Builder numberOfMetadataDocumentsScanned(Long numberOfMetadataDocumentsScanned) {
            this.numberOfMetadataDocumentsScanned = numberOfMetadataDocumentsScanned;
            return this;
        }

        public final Long getNumberOfNewDocumentsIndexed() {
            return numberOfNewDocumentsIndexed;
        }

        public final void setNumberOfNewDocumentsIndexed(Long numberOfNewDocumentsIndexed) {
            this.numberOfNewDocumentsIndexed = numberOfNewDocumentsIndexed;
        }

        @Override
        public final Builder numberOfNewDocumentsIndexed(Long numberOfNewDocumentsIndexed) {
            this.numberOfNewDocumentsIndexed = numberOfNewDocumentsIndexed;
            return this;
        }

        public final Long getNumberOfModifiedDocumentsIndexed() {
            return numberOfModifiedDocumentsIndexed;
        }

        public final void setNumberOfModifiedDocumentsIndexed(Long numberOfModifiedDocumentsIndexed) {
            this.numberOfModifiedDocumentsIndexed = numberOfModifiedDocumentsIndexed;
        }

        @Override
        public final Builder numberOfModifiedDocumentsIndexed(Long numberOfModifiedDocumentsIndexed) {
            this.numberOfModifiedDocumentsIndexed = numberOfModifiedDocumentsIndexed;
            return this;
        }

        public final Long getNumberOfMetadataDocumentsModified() {
            return numberOfMetadataDocumentsModified;
        }

        public final void setNumberOfMetadataDocumentsModified(Long numberOfMetadataDocumentsModified) {
            this.numberOfMetadataDocumentsModified = numberOfMetadataDocumentsModified;
        }

        @Override
        public final Builder numberOfMetadataDocumentsModified(Long numberOfMetadataDocumentsModified) {
            this.numberOfMetadataDocumentsModified = numberOfMetadataDocumentsModified;
            return this;
        }

        public final Long getNumberOfDocumentsDeleted() {
            return numberOfDocumentsDeleted;
        }

        public final void setNumberOfDocumentsDeleted(Long numberOfDocumentsDeleted) {
            this.numberOfDocumentsDeleted = numberOfDocumentsDeleted;
        }

        @Override
        public final Builder numberOfDocumentsDeleted(Long numberOfDocumentsDeleted) {
            this.numberOfDocumentsDeleted = numberOfDocumentsDeleted;
            return this;
        }

        public final Long getNumberOfDocumentsFailed() {
            return numberOfDocumentsFailed;
        }

        public final void setNumberOfDocumentsFailed(Long numberOfDocumentsFailed) {
            this.numberOfDocumentsFailed = numberOfDocumentsFailed;
        }

        @Override
        public final Builder numberOfDocumentsFailed(Long numberOfDocumentsFailed) {
            this.numberOfDocumentsFailed = numberOfDocumentsFailed;
            return this;
        }

        @Override
        public IngestionJobStatistics build() {
            return new IngestionJobStatistics(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
