/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagent.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.internal.EnumUtils;

@Generated("software.amazon.awssdk:codegen")
public enum FlowValidationType {
    CYCLIC_CONNECTION("CyclicConnection"),

    DUPLICATE_CONNECTIONS("DuplicateConnections"),

    DUPLICATE_CONDITION_EXPRESSION("DuplicateConditionExpression"),

    UNREACHABLE_NODE("UnreachableNode"),

    UNKNOWN_CONNECTION_SOURCE("UnknownConnectionSource"),

    UNKNOWN_CONNECTION_SOURCE_OUTPUT("UnknownConnectionSourceOutput"),

    UNKNOWN_CONNECTION_TARGET("UnknownConnectionTarget"),

    UNKNOWN_CONNECTION_TARGET_INPUT("UnknownConnectionTargetInput"),

    UNKNOWN_CONNECTION_CONDITION("UnknownConnectionCondition"),

    MALFORMED_CONDITION_EXPRESSION("MalformedConditionExpression"),

    MALFORMED_NODE_INPUT_EXPRESSION("MalformedNodeInputExpression"),

    MISMATCHED_NODE_INPUT_TYPE("MismatchedNodeInputType"),

    MISMATCHED_NODE_OUTPUT_TYPE("MismatchedNodeOutputType"),

    INCOMPATIBLE_CONNECTION_DATA_TYPE("IncompatibleConnectionDataType"),

    MISSING_CONNECTION_CONFIGURATION("MissingConnectionConfiguration"),

    MISSING_DEFAULT_CONDITION("MissingDefaultCondition"),

    MISSING_ENDING_NODES("MissingEndingNodes"),

    MISSING_NODE_CONFIGURATION("MissingNodeConfiguration"),

    MISSING_NODE_INPUT("MissingNodeInput"),

    MISSING_NODE_OUTPUT("MissingNodeOutput"),

    MISSING_STARTING_NODES("MissingStartingNodes"),

    MULTIPLE_NODE_INPUT_CONNECTIONS("MultipleNodeInputConnections"),

    UNFULFILLED_NODE_INPUT("UnfulfilledNodeInput"),

    UNSATISFIED_CONNECTION_CONDITIONS("UnsatisfiedConnectionConditions"),

    UNSPECIFIED("Unspecified"),

    UNKNOWN_NODE_INPUT("UnknownNodeInput"),

    UNKNOWN_NODE_OUTPUT("UnknownNodeOutput"),

    MISSING_LOOP_INPUT_NODE("MissingLoopInputNode"),

    MISSING_LOOP_CONTROLLER_NODE("MissingLoopControllerNode"),

    MULTIPLE_LOOP_INPUT_NODES("MultipleLoopInputNodes"),

    MULTIPLE_LOOP_CONTROLLER_NODES("MultipleLoopControllerNodes"),

    LOOP_INCOMPATIBLE_NODE_TYPE("LoopIncompatibleNodeType"),

    INVALID_LOOP_BOUNDARY("InvalidLoopBoundary"),

    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, FlowValidationType> VALUE_MAP = EnumUtils.uniqueIndex(FlowValidationType.class,
            FlowValidationType::toString);

    private final String value;

    private FlowValidationType(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Use this in place of valueOf to convert the raw string returned by the service into the enum value.
     *
     * @param value
     *        real value
     * @return FlowValidationType corresponding to the value
     */
    public static FlowValidationType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    /**
     * Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK. This will return
     * all known enum values except {@link #UNKNOWN_TO_SDK_VERSION}.
     *
     * @return a {@link Set} of known {@link FlowValidationType}s
     */
    public static Set<FlowValidationType> knownValues() {
        Set<FlowValidationType> knownValues = EnumSet.allOf(FlowValidationType.class);
        knownValues.remove(UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }
}
