/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagent.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about validation of the flow.
 * </p>
 * <p>
 * This data type is used in the following API operations:
 * </p>
 * <ul>
 * <li>
 * <p>
 * <a href=
 * "https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_GetFlow.html#API_agent_GetFlow_ResponseSyntax"
 * >GetFlow response</a>
 * </p>
 * </li>
 * <li>
 * <p>
 * <a href=
 * "https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_GetFlowVersion.html#API_agent_GetFlowVersion_ResponseSyntax"
 * >GetFlowVersion response</a>
 * </p>
 * </li>
 * </ul>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FlowValidation implements SdkPojo, Serializable, ToCopyableBuilder<FlowValidation.Builder, FlowValidation> {
    private static final SdkField<String> MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("message")
            .getter(getter(FlowValidation::message)).setter(setter(Builder::message))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("message").build()).build();

    private static final SdkField<String> SEVERITY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("severity").getter(getter(FlowValidation::severityAsString)).setter(setter(Builder::severity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("severity").build()).build();

    private static final SdkField<FlowValidationDetails> DETAILS_FIELD = SdkField
            .<FlowValidationDetails> builder(MarshallingType.SDK_POJO).memberName("details")
            .getter(getter(FlowValidation::details)).setter(setter(Builder::details)).constructor(FlowValidationDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("details").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(FlowValidation::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MESSAGE_FIELD, SEVERITY_FIELD,
            DETAILS_FIELD, TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String message;

    private final String severity;

    private final FlowValidationDetails details;

    private final String type;

    private FlowValidation(BuilderImpl builder) {
        this.message = builder.message;
        this.severity = builder.severity;
        this.details = builder.details;
        this.type = builder.type;
    }

    /**
     * <p>
     * A message describing the validation error.
     * </p>
     * 
     * @return A message describing the validation error.
     */
    public final String message() {
        return message;
    }

    /**
     * <p>
     * The severity of the issue described in the message.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #severity} will
     * return {@link FlowValidationSeverity#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #severityAsString}.
     * </p>
     * 
     * @return The severity of the issue described in the message.
     * @see FlowValidationSeverity
     */
    public final FlowValidationSeverity severity() {
        return FlowValidationSeverity.fromValue(severity);
    }

    /**
     * <p>
     * The severity of the issue described in the message.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #severity} will
     * return {@link FlowValidationSeverity#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #severityAsString}.
     * </p>
     * 
     * @return The severity of the issue described in the message.
     * @see FlowValidationSeverity
     */
    public final String severityAsString() {
        return severity;
    }

    /**
     * <p>
     * Specific details about the validation issue encountered in the flow.
     * </p>
     * 
     * @return Specific details about the validation issue encountered in the flow.
     */
    public final FlowValidationDetails details() {
        return details;
    }

    /**
     * <p>
     * The type of validation issue encountered in the flow.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link FlowValidationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of validation issue encountered in the flow.
     * @see FlowValidationType
     */
    public final FlowValidationType type() {
        return FlowValidationType.fromValue(type);
    }

    /**
     * <p>
     * The type of validation issue encountered in the flow.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link FlowValidationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of validation issue encountered in the flow.
     * @see FlowValidationType
     */
    public final String typeAsString() {
        return type;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(message());
        hashCode = 31 * hashCode + Objects.hashCode(severityAsString());
        hashCode = 31 * hashCode + Objects.hashCode(details());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FlowValidation)) {
            return false;
        }
        FlowValidation other = (FlowValidation) obj;
        return Objects.equals(message(), other.message()) && Objects.equals(severityAsString(), other.severityAsString())
                && Objects.equals(details(), other.details()) && Objects.equals(typeAsString(), other.typeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FlowValidation").add("Message", message()).add("Severity", severityAsString())
                .add("Details", details()).add("Type", typeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "message":
            return Optional.ofNullable(clazz.cast(message()));
        case "severity":
            return Optional.ofNullable(clazz.cast(severityAsString()));
        case "details":
            return Optional.ofNullable(clazz.cast(details()));
        case "type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("message", MESSAGE_FIELD);
        map.put("severity", SEVERITY_FIELD);
        map.put("details", DETAILS_FIELD);
        map.put("type", TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<FlowValidation, T> g) {
        return obj -> g.apply((FlowValidation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FlowValidation> {
        /**
         * <p>
         * A message describing the validation error.
         * </p>
         * 
         * @param message
         *        A message describing the validation error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder message(String message);

        /**
         * <p>
         * The severity of the issue described in the message.
         * </p>
         * 
         * @param severity
         *        The severity of the issue described in the message.
         * @see FlowValidationSeverity
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FlowValidationSeverity
         */
        Builder severity(String severity);

        /**
         * <p>
         * The severity of the issue described in the message.
         * </p>
         * 
         * @param severity
         *        The severity of the issue described in the message.
         * @see FlowValidationSeverity
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FlowValidationSeverity
         */
        Builder severity(FlowValidationSeverity severity);

        /**
         * <p>
         * Specific details about the validation issue encountered in the flow.
         * </p>
         * 
         * @param details
         *        Specific details about the validation issue encountered in the flow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder details(FlowValidationDetails details);

        /**
         * <p>
         * Specific details about the validation issue encountered in the flow.
         * </p>
         * This is a convenience method that creates an instance of the {@link FlowValidationDetails.Builder} avoiding
         * the need to create one manually via {@link FlowValidationDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FlowValidationDetails.Builder#build()} is called immediately and
         * its result is passed to {@link #details(FlowValidationDetails)}.
         * 
         * @param details
         *        a consumer that will call methods on {@link FlowValidationDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #details(FlowValidationDetails)
         */
        default Builder details(Consumer<FlowValidationDetails.Builder> details) {
            return details(FlowValidationDetails.builder().applyMutation(details).build());
        }

        /**
         * <p>
         * The type of validation issue encountered in the flow.
         * </p>
         * 
         * @param type
         *        The type of validation issue encountered in the flow.
         * @see FlowValidationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FlowValidationType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of validation issue encountered in the flow.
         * </p>
         * 
         * @param type
         *        The type of validation issue encountered in the flow.
         * @see FlowValidationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FlowValidationType
         */
        Builder type(FlowValidationType type);
    }

    static final class BuilderImpl implements Builder {
        private String message;

        private String severity;

        private FlowValidationDetails details;

        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(FlowValidation model) {
            message(model.message);
            severity(model.severity);
            details(model.details);
            type(model.type);
        }

        public final String getMessage() {
            return message;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final String getSeverity() {
            return severity;
        }

        public final void setSeverity(String severity) {
            this.severity = severity;
        }

        @Override
        public final Builder severity(String severity) {
            this.severity = severity;
            return this;
        }

        @Override
        public final Builder severity(FlowValidationSeverity severity) {
            this.severity(severity == null ? null : severity.toString());
            return this;
        }

        public final FlowValidationDetails.Builder getDetails() {
            return details != null ? details.toBuilder() : null;
        }

        public final void setDetails(FlowValidationDetails.BuilderImpl details) {
            this.details = details != null ? details.build() : null;
        }

        @Override
        public final Builder details(FlowValidationDetails details) {
            this.details = details;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(FlowValidationType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        @Override
        public FlowValidation build() {
            return new FlowValidation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
