/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagent.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The connection configuration for the data source.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DataSourceConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<DataSourceConfiguration.Builder, DataSourceConfiguration> {
    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(DataSourceConfiguration::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final SdkField<S3DataSourceConfiguration> S3_CONFIGURATION_FIELD = SdkField
            .<S3DataSourceConfiguration> builder(MarshallingType.SDK_POJO).memberName("s3Configuration")
            .getter(getter(DataSourceConfiguration::s3Configuration)).setter(setter(Builder::s3Configuration))
            .constructor(S3DataSourceConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3Configuration").build()).build();

    private static final SdkField<WebDataSourceConfiguration> WEB_CONFIGURATION_FIELD = SdkField
            .<WebDataSourceConfiguration> builder(MarshallingType.SDK_POJO).memberName("webConfiguration")
            .getter(getter(DataSourceConfiguration::webConfiguration)).setter(setter(Builder::webConfiguration))
            .constructor(WebDataSourceConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("webConfiguration").build()).build();

    private static final SdkField<ConfluenceDataSourceConfiguration> CONFLUENCE_CONFIGURATION_FIELD = SdkField
            .<ConfluenceDataSourceConfiguration> builder(MarshallingType.SDK_POJO).memberName("confluenceConfiguration")
            .getter(getter(DataSourceConfiguration::confluenceConfiguration)).setter(setter(Builder::confluenceConfiguration))
            .constructor(ConfluenceDataSourceConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("confluenceConfiguration").build())
            .build();

    private static final SdkField<SalesforceDataSourceConfiguration> SALESFORCE_CONFIGURATION_FIELD = SdkField
            .<SalesforceDataSourceConfiguration> builder(MarshallingType.SDK_POJO).memberName("salesforceConfiguration")
            .getter(getter(DataSourceConfiguration::salesforceConfiguration)).setter(setter(Builder::salesforceConfiguration))
            .constructor(SalesforceDataSourceConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("salesforceConfiguration").build())
            .build();

    private static final SdkField<SharePointDataSourceConfiguration> SHARE_POINT_CONFIGURATION_FIELD = SdkField
            .<SharePointDataSourceConfiguration> builder(MarshallingType.SDK_POJO).memberName("sharePointConfiguration")
            .getter(getter(DataSourceConfiguration::sharePointConfiguration)).setter(setter(Builder::sharePointConfiguration))
            .constructor(SharePointDataSourceConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sharePointConfiguration").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD,
            S3_CONFIGURATION_FIELD, WEB_CONFIGURATION_FIELD, CONFLUENCE_CONFIGURATION_FIELD, SALESFORCE_CONFIGURATION_FIELD,
            SHARE_POINT_CONFIGURATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String type;

    private final S3DataSourceConfiguration s3Configuration;

    private final WebDataSourceConfiguration webConfiguration;

    private final ConfluenceDataSourceConfiguration confluenceConfiguration;

    private final SalesforceDataSourceConfiguration salesforceConfiguration;

    private final SharePointDataSourceConfiguration sharePointConfiguration;

    private DataSourceConfiguration(BuilderImpl builder) {
        this.type = builder.type;
        this.s3Configuration = builder.s3Configuration;
        this.webConfiguration = builder.webConfiguration;
        this.confluenceConfiguration = builder.confluenceConfiguration;
        this.salesforceConfiguration = builder.salesforceConfiguration;
        this.sharePointConfiguration = builder.sharePointConfiguration;
    }

    /**
     * <p>
     * The type of data source.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link DataSourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of data source.
     * @see DataSourceType
     */
    public final DataSourceType type() {
        return DataSourceType.fromValue(type);
    }

    /**
     * <p>
     * The type of data source.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link DataSourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of data source.
     * @see DataSourceType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * The configuration information to connect to Amazon S3 as your data source.
     * </p>
     * 
     * @return The configuration information to connect to Amazon S3 as your data source.
     */
    public final S3DataSourceConfiguration s3Configuration() {
        return s3Configuration;
    }

    /**
     * <p>
     * The configuration of web URLs to crawl for your data source. You should be authorized to crawl the URLs.
     * </p>
     * <note>
     * <p>
     * Crawling web URLs as your data source is in preview release and is subject to change.
     * </p>
     * </note>
     * 
     * @return The configuration of web URLs to crawl for your data source. You should be authorized to crawl the
     *         URLs.</p> <note>
     *         <p>
     *         Crawling web URLs as your data source is in preview release and is subject to change.
     *         </p>
     */
    public final WebDataSourceConfiguration webConfiguration() {
        return webConfiguration;
    }

    /**
     * <p>
     * The configuration information to connect to Confluence as your data source.
     * </p>
     * <note>
     * <p>
     * Confluence data source connector is in preview release and is subject to change.
     * </p>
     * </note>
     * 
     * @return The configuration information to connect to Confluence as your data source.</p> <note>
     *         <p>
     *         Confluence data source connector is in preview release and is subject to change.
     *         </p>
     */
    public final ConfluenceDataSourceConfiguration confluenceConfiguration() {
        return confluenceConfiguration;
    }

    /**
     * <p>
     * The configuration information to connect to Salesforce as your data source.
     * </p>
     * <note>
     * <p>
     * Salesforce data source connector is in preview release and is subject to change.
     * </p>
     * </note>
     * 
     * @return The configuration information to connect to Salesforce as your data source.</p> <note>
     *         <p>
     *         Salesforce data source connector is in preview release and is subject to change.
     *         </p>
     */
    public final SalesforceDataSourceConfiguration salesforceConfiguration() {
        return salesforceConfiguration;
    }

    /**
     * <p>
     * The configuration information to connect to SharePoint as your data source.
     * </p>
     * <note>
     * <p>
     * SharePoint data source connector is in preview release and is subject to change.
     * </p>
     * </note>
     * 
     * @return The configuration information to connect to SharePoint as your data source.</p> <note>
     *         <p>
     *         SharePoint data source connector is in preview release and is subject to change.
     *         </p>
     */
    public final SharePointDataSourceConfiguration sharePointConfiguration() {
        return sharePointConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(s3Configuration());
        hashCode = 31 * hashCode + Objects.hashCode(webConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(confluenceConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(salesforceConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(sharePointConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataSourceConfiguration)) {
            return false;
        }
        DataSourceConfiguration other = (DataSourceConfiguration) obj;
        return Objects.equals(typeAsString(), other.typeAsString()) && Objects.equals(s3Configuration(), other.s3Configuration())
                && Objects.equals(webConfiguration(), other.webConfiguration())
                && Objects.equals(confluenceConfiguration(), other.confluenceConfiguration())
                && Objects.equals(salesforceConfiguration(), other.salesforceConfiguration())
                && Objects.equals(sharePointConfiguration(), other.sharePointConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DataSourceConfiguration").add("Type", typeAsString()).add("S3Configuration", s3Configuration())
                .add("WebConfiguration", webConfiguration()).add("ConfluenceConfiguration", confluenceConfiguration())
                .add("SalesforceConfiguration", salesforceConfiguration())
                .add("SharePointConfiguration", sharePointConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "s3Configuration":
            return Optional.ofNullable(clazz.cast(s3Configuration()));
        case "webConfiguration":
            return Optional.ofNullable(clazz.cast(webConfiguration()));
        case "confluenceConfiguration":
            return Optional.ofNullable(clazz.cast(confluenceConfiguration()));
        case "salesforceConfiguration":
            return Optional.ofNullable(clazz.cast(salesforceConfiguration()));
        case "sharePointConfiguration":
            return Optional.ofNullable(clazz.cast(sharePointConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("type", TYPE_FIELD);
        map.put("s3Configuration", S3_CONFIGURATION_FIELD);
        map.put("webConfiguration", WEB_CONFIGURATION_FIELD);
        map.put("confluenceConfiguration", CONFLUENCE_CONFIGURATION_FIELD);
        map.put("salesforceConfiguration", SALESFORCE_CONFIGURATION_FIELD);
        map.put("sharePointConfiguration", SHARE_POINT_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DataSourceConfiguration, T> g) {
        return obj -> g.apply((DataSourceConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DataSourceConfiguration> {
        /**
         * <p>
         * The type of data source.
         * </p>
         * 
         * @param type
         *        The type of data source.
         * @see DataSourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DataSourceType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of data source.
         * </p>
         * 
         * @param type
         *        The type of data source.
         * @see DataSourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DataSourceType
         */
        Builder type(DataSourceType type);

        /**
         * <p>
         * The configuration information to connect to Amazon S3 as your data source.
         * </p>
         * 
         * @param s3Configuration
         *        The configuration information to connect to Amazon S3 as your data source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3Configuration(S3DataSourceConfiguration s3Configuration);

        /**
         * <p>
         * The configuration information to connect to Amazon S3 as your data source.
         * </p>
         * This is a convenience method that creates an instance of the {@link S3DataSourceConfiguration.Builder}
         * avoiding the need to create one manually via {@link S3DataSourceConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link S3DataSourceConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #s3Configuration(S3DataSourceConfiguration)}.
         * 
         * @param s3Configuration
         *        a consumer that will call methods on {@link S3DataSourceConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #s3Configuration(S3DataSourceConfiguration)
         */
        default Builder s3Configuration(Consumer<S3DataSourceConfiguration.Builder> s3Configuration) {
            return s3Configuration(S3DataSourceConfiguration.builder().applyMutation(s3Configuration).build());
        }

        /**
         * <p>
         * The configuration of web URLs to crawl for your data source. You should be authorized to crawl the URLs.
         * </p>
         * <note>
         * <p>
         * Crawling web URLs as your data source is in preview release and is subject to change.
         * </p>
         * </note>
         * 
         * @param webConfiguration
         *        The configuration of web URLs to crawl for your data source. You should be authorized to crawl the
         *        URLs.</p> <note>
         *        <p>
         *        Crawling web URLs as your data source is in preview release and is subject to change.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder webConfiguration(WebDataSourceConfiguration webConfiguration);

        /**
         * <p>
         * The configuration of web URLs to crawl for your data source. You should be authorized to crawl the URLs.
         * </p>
         * <note>
         * <p>
         * Crawling web URLs as your data source is in preview release and is subject to change.
         * </p>
         * </note> This is a convenience method that creates an instance of the
         * {@link WebDataSourceConfiguration.Builder} avoiding the need to create one manually via
         * {@link WebDataSourceConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link WebDataSourceConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #webConfiguration(WebDataSourceConfiguration)}.
         * 
         * @param webConfiguration
         *        a consumer that will call methods on {@link WebDataSourceConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #webConfiguration(WebDataSourceConfiguration)
         */
        default Builder webConfiguration(Consumer<WebDataSourceConfiguration.Builder> webConfiguration) {
            return webConfiguration(WebDataSourceConfiguration.builder().applyMutation(webConfiguration).build());
        }

        /**
         * <p>
         * The configuration information to connect to Confluence as your data source.
         * </p>
         * <note>
         * <p>
         * Confluence data source connector is in preview release and is subject to change.
         * </p>
         * </note>
         * 
         * @param confluenceConfiguration
         *        The configuration information to connect to Confluence as your data source.</p> <note>
         *        <p>
         *        Confluence data source connector is in preview release and is subject to change.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder confluenceConfiguration(ConfluenceDataSourceConfiguration confluenceConfiguration);

        /**
         * <p>
         * The configuration information to connect to Confluence as your data source.
         * </p>
         * <note>
         * <p>
         * Confluence data source connector is in preview release and is subject to change.
         * </p>
         * </note> This is a convenience method that creates an instance of the
         * {@link ConfluenceDataSourceConfiguration.Builder} avoiding the need to create one manually via
         * {@link ConfluenceDataSourceConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ConfluenceDataSourceConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #confluenceConfiguration(ConfluenceDataSourceConfiguration)}.
         * 
         * @param confluenceConfiguration
         *        a consumer that will call methods on {@link ConfluenceDataSourceConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #confluenceConfiguration(ConfluenceDataSourceConfiguration)
         */
        default Builder confluenceConfiguration(Consumer<ConfluenceDataSourceConfiguration.Builder> confluenceConfiguration) {
            return confluenceConfiguration(ConfluenceDataSourceConfiguration.builder().applyMutation(confluenceConfiguration)
                    .build());
        }

        /**
         * <p>
         * The configuration information to connect to Salesforce as your data source.
         * </p>
         * <note>
         * <p>
         * Salesforce data source connector is in preview release and is subject to change.
         * </p>
         * </note>
         * 
         * @param salesforceConfiguration
         *        The configuration information to connect to Salesforce as your data source.</p> <note>
         *        <p>
         *        Salesforce data source connector is in preview release and is subject to change.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder salesforceConfiguration(SalesforceDataSourceConfiguration salesforceConfiguration);

        /**
         * <p>
         * The configuration information to connect to Salesforce as your data source.
         * </p>
         * <note>
         * <p>
         * Salesforce data source connector is in preview release and is subject to change.
         * </p>
         * </note> This is a convenience method that creates an instance of the
         * {@link SalesforceDataSourceConfiguration.Builder} avoiding the need to create one manually via
         * {@link SalesforceDataSourceConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SalesforceDataSourceConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #salesforceConfiguration(SalesforceDataSourceConfiguration)}.
         * 
         * @param salesforceConfiguration
         *        a consumer that will call methods on {@link SalesforceDataSourceConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #salesforceConfiguration(SalesforceDataSourceConfiguration)
         */
        default Builder salesforceConfiguration(Consumer<SalesforceDataSourceConfiguration.Builder> salesforceConfiguration) {
            return salesforceConfiguration(SalesforceDataSourceConfiguration.builder().applyMutation(salesforceConfiguration)
                    .build());
        }

        /**
         * <p>
         * The configuration information to connect to SharePoint as your data source.
         * </p>
         * <note>
         * <p>
         * SharePoint data source connector is in preview release and is subject to change.
         * </p>
         * </note>
         * 
         * @param sharePointConfiguration
         *        The configuration information to connect to SharePoint as your data source.</p> <note>
         *        <p>
         *        SharePoint data source connector is in preview release and is subject to change.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sharePointConfiguration(SharePointDataSourceConfiguration sharePointConfiguration);

        /**
         * <p>
         * The configuration information to connect to SharePoint as your data source.
         * </p>
         * <note>
         * <p>
         * SharePoint data source connector is in preview release and is subject to change.
         * </p>
         * </note> This is a convenience method that creates an instance of the
         * {@link SharePointDataSourceConfiguration.Builder} avoiding the need to create one manually via
         * {@link SharePointDataSourceConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SharePointDataSourceConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #sharePointConfiguration(SharePointDataSourceConfiguration)}.
         * 
         * @param sharePointConfiguration
         *        a consumer that will call methods on {@link SharePointDataSourceConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sharePointConfiguration(SharePointDataSourceConfiguration)
         */
        default Builder sharePointConfiguration(Consumer<SharePointDataSourceConfiguration.Builder> sharePointConfiguration) {
            return sharePointConfiguration(SharePointDataSourceConfiguration.builder().applyMutation(sharePointConfiguration)
                    .build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String type;

        private S3DataSourceConfiguration s3Configuration;

        private WebDataSourceConfiguration webConfiguration;

        private ConfluenceDataSourceConfiguration confluenceConfiguration;

        private SalesforceDataSourceConfiguration salesforceConfiguration;

        private SharePointDataSourceConfiguration sharePointConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(DataSourceConfiguration model) {
            type(model.type);
            s3Configuration(model.s3Configuration);
            webConfiguration(model.webConfiguration);
            confluenceConfiguration(model.confluenceConfiguration);
            salesforceConfiguration(model.salesforceConfiguration);
            sharePointConfiguration(model.sharePointConfiguration);
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(DataSourceType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final S3DataSourceConfiguration.Builder getS3Configuration() {
            return s3Configuration != null ? s3Configuration.toBuilder() : null;
        }

        public final void setS3Configuration(S3DataSourceConfiguration.BuilderImpl s3Configuration) {
            this.s3Configuration = s3Configuration != null ? s3Configuration.build() : null;
        }

        @Override
        public final Builder s3Configuration(S3DataSourceConfiguration s3Configuration) {
            this.s3Configuration = s3Configuration;
            return this;
        }

        public final WebDataSourceConfiguration.Builder getWebConfiguration() {
            return webConfiguration != null ? webConfiguration.toBuilder() : null;
        }

        public final void setWebConfiguration(WebDataSourceConfiguration.BuilderImpl webConfiguration) {
            this.webConfiguration = webConfiguration != null ? webConfiguration.build() : null;
        }

        @Override
        public final Builder webConfiguration(WebDataSourceConfiguration webConfiguration) {
            this.webConfiguration = webConfiguration;
            return this;
        }

        public final ConfluenceDataSourceConfiguration.Builder getConfluenceConfiguration() {
            return confluenceConfiguration != null ? confluenceConfiguration.toBuilder() : null;
        }

        public final void setConfluenceConfiguration(ConfluenceDataSourceConfiguration.BuilderImpl confluenceConfiguration) {
            this.confluenceConfiguration = confluenceConfiguration != null ? confluenceConfiguration.build() : null;
        }

        @Override
        public final Builder confluenceConfiguration(ConfluenceDataSourceConfiguration confluenceConfiguration) {
            this.confluenceConfiguration = confluenceConfiguration;
            return this;
        }

        public final SalesforceDataSourceConfiguration.Builder getSalesforceConfiguration() {
            return salesforceConfiguration != null ? salesforceConfiguration.toBuilder() : null;
        }

        public final void setSalesforceConfiguration(SalesforceDataSourceConfiguration.BuilderImpl salesforceConfiguration) {
            this.salesforceConfiguration = salesforceConfiguration != null ? salesforceConfiguration.build() : null;
        }

        @Override
        public final Builder salesforceConfiguration(SalesforceDataSourceConfiguration salesforceConfiguration) {
            this.salesforceConfiguration = salesforceConfiguration;
            return this;
        }

        public final SharePointDataSourceConfiguration.Builder getSharePointConfiguration() {
            return sharePointConfiguration != null ? sharePointConfiguration.toBuilder() : null;
        }

        public final void setSharePointConfiguration(SharePointDataSourceConfiguration.BuilderImpl sharePointConfiguration) {
            this.sharePointConfiguration = sharePointConfiguration != null ? sharePointConfiguration.build() : null;
        }

        @Override
        public final Builder sharePointConfiguration(SharePointDataSourceConfiguration sharePointConfiguration) {
            this.sharePointConfiguration = sharePointConfiguration;
            return this;
        }

        @Override
        public DataSourceConfiguration build() {
            return new DataSourceConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
