/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagent.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Configuration settings for processing audio content in multimodal knowledge bases.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AudioConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<AudioConfiguration.Builder, AudioConfiguration> {
    private static final SdkField<AudioSegmentationConfiguration> SEGMENTATION_CONFIGURATION_FIELD = SdkField
            .<AudioSegmentationConfiguration> builder(MarshallingType.SDK_POJO).memberName("segmentationConfiguration")
            .getter(getter(AudioConfiguration::segmentationConfiguration)).setter(setter(Builder::segmentationConfiguration))
            .constructor(AudioSegmentationConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("segmentationConfiguration").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(SEGMENTATION_CONFIGURATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final AudioSegmentationConfiguration segmentationConfiguration;

    private AudioConfiguration(BuilderImpl builder) {
        this.segmentationConfiguration = builder.segmentationConfiguration;
    }

    /**
     * <p>
     * Configuration for segmenting audio content during processing.
     * </p>
     * 
     * @return Configuration for segmenting audio content during processing.
     */
    public final AudioSegmentationConfiguration segmentationConfiguration() {
        return segmentationConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(segmentationConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AudioConfiguration)) {
            return false;
        }
        AudioConfiguration other = (AudioConfiguration) obj;
        return Objects.equals(segmentationConfiguration(), other.segmentationConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AudioConfiguration").add("SegmentationConfiguration", segmentationConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "segmentationConfiguration":
            return Optional.ofNullable(clazz.cast(segmentationConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("segmentationConfiguration", SEGMENTATION_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AudioConfiguration, T> g) {
        return obj -> g.apply((AudioConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AudioConfiguration> {
        /**
         * <p>
         * Configuration for segmenting audio content during processing.
         * </p>
         * 
         * @param segmentationConfiguration
         *        Configuration for segmenting audio content during processing.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder segmentationConfiguration(AudioSegmentationConfiguration segmentationConfiguration);

        /**
         * <p>
         * Configuration for segmenting audio content during processing.
         * </p>
         * This is a convenience method that creates an instance of the {@link AudioSegmentationConfiguration.Builder}
         * avoiding the need to create one manually via {@link AudioSegmentationConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AudioSegmentationConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #segmentationConfiguration(AudioSegmentationConfiguration)}.
         * 
         * @param segmentationConfiguration
         *        a consumer that will call methods on {@link AudioSegmentationConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #segmentationConfiguration(AudioSegmentationConfiguration)
         */
        default Builder segmentationConfiguration(Consumer<AudioSegmentationConfiguration.Builder> segmentationConfiguration) {
            return segmentationConfiguration(AudioSegmentationConfiguration.builder().applyMutation(segmentationConfiguration)
                    .build());
        }
    }

    static final class BuilderImpl implements Builder {
        private AudioSegmentationConfiguration segmentationConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(AudioConfiguration model) {
            segmentationConfiguration(model.segmentationConfiguration);
        }

        public final AudioSegmentationConfiguration.Builder getSegmentationConfiguration() {
            return segmentationConfiguration != null ? segmentationConfiguration.toBuilder() : null;
        }

        public final void setSegmentationConfiguration(AudioSegmentationConfiguration.BuilderImpl segmentationConfiguration) {
            this.segmentationConfiguration = segmentationConfiguration != null ? segmentationConfiguration.build() : null;
        }

        @Override
        public final Builder segmentationConfiguration(AudioSegmentationConfiguration segmentationConfiguration) {
            this.segmentationConfiguration = segmentationConfiguration;
            return this;
        }

        @Override
        public AudioConfiguration build() {
            return new AudioConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
