/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagent.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains details about a knowledge base associated with an agent.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AgentKnowledgeBaseSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<AgentKnowledgeBaseSummary.Builder, AgentKnowledgeBaseSummary> {
    private static final SdkField<String> KNOWLEDGE_BASE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("knowledgeBaseId").getter(getter(AgentKnowledgeBaseSummary::knowledgeBaseId))
            .setter(setter(Builder::knowledgeBaseId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("knowledgeBaseId").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(AgentKnowledgeBaseSummary::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> KNOWLEDGE_BASE_STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("knowledgeBaseState").getter(getter(AgentKnowledgeBaseSummary::knowledgeBaseStateAsString))
            .setter(setter(Builder::knowledgeBaseState))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("knowledgeBaseState").build())
            .build();

    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("updatedAt")
            .getter(getter(AgentKnowledgeBaseSummary::updatedAt))
            .setter(setter(Builder::updatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KNOWLEDGE_BASE_ID_FIELD,
            DESCRIPTION_FIELD, KNOWLEDGE_BASE_STATE_FIELD, UPDATED_AT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String knowledgeBaseId;

    private final String description;

    private final String knowledgeBaseState;

    private final Instant updatedAt;

    private AgentKnowledgeBaseSummary(BuilderImpl builder) {
        this.knowledgeBaseId = builder.knowledgeBaseId;
        this.description = builder.description;
        this.knowledgeBaseState = builder.knowledgeBaseState;
        this.updatedAt = builder.updatedAt;
    }

    /**
     * <p>
     * The unique identifier of the knowledge base associated with an agent.
     * </p>
     * 
     * @return The unique identifier of the knowledge base associated with an agent.
     */
    public final String knowledgeBaseId() {
        return knowledgeBaseId;
    }

    /**
     * <p>
     * The description of the knowledge base associated with an agent.
     * </p>
     * 
     * @return The description of the knowledge base associated with an agent.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * Specifies whether the agent uses the knowledge base or not when sending an <a
     * href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_InvokeAgent.html">InvokeAgent</a>
     * request.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #knowledgeBaseState} will return {@link KnowledgeBaseState#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #knowledgeBaseStateAsString}.
     * </p>
     * 
     * @return Specifies whether the agent uses the knowledge base or not when sending an <a
     *         href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_InvokeAgent.html"
     *         >InvokeAgent</a> request.
     * @see KnowledgeBaseState
     */
    public final KnowledgeBaseState knowledgeBaseState() {
        return KnowledgeBaseState.fromValue(knowledgeBaseState);
    }

    /**
     * <p>
     * Specifies whether the agent uses the knowledge base or not when sending an <a
     * href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_InvokeAgent.html">InvokeAgent</a>
     * request.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #knowledgeBaseState} will return {@link KnowledgeBaseState#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #knowledgeBaseStateAsString}.
     * </p>
     * 
     * @return Specifies whether the agent uses the knowledge base or not when sending an <a
     *         href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_InvokeAgent.html"
     *         >InvokeAgent</a> request.
     * @see KnowledgeBaseState
     */
    public final String knowledgeBaseStateAsString() {
        return knowledgeBaseState;
    }

    /**
     * <p>
     * The time at which the knowledge base associated with an agent was last updated.
     * </p>
     * 
     * @return The time at which the knowledge base associated with an agent was last updated.
     */
    public final Instant updatedAt() {
        return updatedAt;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(knowledgeBaseId());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(knowledgeBaseStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(updatedAt());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AgentKnowledgeBaseSummary)) {
            return false;
        }
        AgentKnowledgeBaseSummary other = (AgentKnowledgeBaseSummary) obj;
        return Objects.equals(knowledgeBaseId(), other.knowledgeBaseId()) && Objects.equals(description(), other.description())
                && Objects.equals(knowledgeBaseStateAsString(), other.knowledgeBaseStateAsString())
                && Objects.equals(updatedAt(), other.updatedAt());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AgentKnowledgeBaseSummary").add("KnowledgeBaseId", knowledgeBaseId())
                .add("Description", description()).add("KnowledgeBaseState", knowledgeBaseStateAsString())
                .add("UpdatedAt", updatedAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "knowledgeBaseId":
            return Optional.ofNullable(clazz.cast(knowledgeBaseId()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "knowledgeBaseState":
            return Optional.ofNullable(clazz.cast(knowledgeBaseStateAsString()));
        case "updatedAt":
            return Optional.ofNullable(clazz.cast(updatedAt()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("knowledgeBaseId", KNOWLEDGE_BASE_ID_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("knowledgeBaseState", KNOWLEDGE_BASE_STATE_FIELD);
        map.put("updatedAt", UPDATED_AT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AgentKnowledgeBaseSummary, T> g) {
        return obj -> g.apply((AgentKnowledgeBaseSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AgentKnowledgeBaseSummary> {
        /**
         * <p>
         * The unique identifier of the knowledge base associated with an agent.
         * </p>
         * 
         * @param knowledgeBaseId
         *        The unique identifier of the knowledge base associated with an agent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder knowledgeBaseId(String knowledgeBaseId);

        /**
         * <p>
         * The description of the knowledge base associated with an agent.
         * </p>
         * 
         * @param description
         *        The description of the knowledge base associated with an agent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * Specifies whether the agent uses the knowledge base or not when sending an <a
         * href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_InvokeAgent.html"
         * >InvokeAgent</a> request.
         * </p>
         * 
         * @param knowledgeBaseState
         *        Specifies whether the agent uses the knowledge base or not when sending an <a
         *        href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_InvokeAgent.html"
         *        >InvokeAgent</a> request.
         * @see KnowledgeBaseState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see KnowledgeBaseState
         */
        Builder knowledgeBaseState(String knowledgeBaseState);

        /**
         * <p>
         * Specifies whether the agent uses the knowledge base or not when sending an <a
         * href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_InvokeAgent.html"
         * >InvokeAgent</a> request.
         * </p>
         * 
         * @param knowledgeBaseState
         *        Specifies whether the agent uses the knowledge base or not when sending an <a
         *        href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_InvokeAgent.html"
         *        >InvokeAgent</a> request.
         * @see KnowledgeBaseState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see KnowledgeBaseState
         */
        Builder knowledgeBaseState(KnowledgeBaseState knowledgeBaseState);

        /**
         * <p>
         * The time at which the knowledge base associated with an agent was last updated.
         * </p>
         * 
         * @param updatedAt
         *        The time at which the knowledge base associated with an agent was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedAt(Instant updatedAt);
    }

    static final class BuilderImpl implements Builder {
        private String knowledgeBaseId;

        private String description;

        private String knowledgeBaseState;

        private Instant updatedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(AgentKnowledgeBaseSummary model) {
            knowledgeBaseId(model.knowledgeBaseId);
            description(model.description);
            knowledgeBaseState(model.knowledgeBaseState);
            updatedAt(model.updatedAt);
        }

        public final String getKnowledgeBaseId() {
            return knowledgeBaseId;
        }

        public final void setKnowledgeBaseId(String knowledgeBaseId) {
            this.knowledgeBaseId = knowledgeBaseId;
        }

        @Override
        public final Builder knowledgeBaseId(String knowledgeBaseId) {
            this.knowledgeBaseId = knowledgeBaseId;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getKnowledgeBaseState() {
            return knowledgeBaseState;
        }

        public final void setKnowledgeBaseState(String knowledgeBaseState) {
            this.knowledgeBaseState = knowledgeBaseState;
        }

        @Override
        public final Builder knowledgeBaseState(String knowledgeBaseState) {
            this.knowledgeBaseState = knowledgeBaseState;
            return this;
        }

        @Override
        public final Builder knowledgeBaseState(KnowledgeBaseState knowledgeBaseState) {
            this.knowledgeBaseState(knowledgeBaseState == null ? null : knowledgeBaseState.toString());
            return this;
        }

        public final Instant getUpdatedAt() {
            return updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        @Override
        public AgentKnowledgeBaseSummary build() {
            return new AgentKnowledgeBaseSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
