/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagent.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.bedrockagent.model.FlowConditionalConnectionConfiguration;
import software.amazon.awssdk.services.bedrockagent.model.FlowDataConnectionConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class FlowConnectionConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, FlowConnectionConfiguration> {
    private static final SdkField<FlowDataConnectionConfiguration> DATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("data").getter(FlowConnectionConfiguration.getter(FlowConnectionConfiguration::data)).setter(FlowConnectionConfiguration.setter(Builder::data)).constructor(FlowDataConnectionConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("data").build()}).build();
    private static final SdkField<FlowConditionalConnectionConfiguration> CONDITIONAL_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("conditional").getter(FlowConnectionConfiguration.getter(FlowConnectionConfiguration::conditional)).setter(FlowConnectionConfiguration.setter(Builder::conditional)).constructor(FlowConditionalConnectionConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("conditional").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATA_FIELD, CONDITIONAL_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = FlowConnectionConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final FlowDataConnectionConfiguration data;
    private final FlowConditionalConnectionConfiguration conditional;
    private final Type type;

    private FlowConnectionConfiguration(BuilderImpl builder) {
        this.data = builder.data;
        this.conditional = builder.conditional;
        this.type = builder.type;
    }

    public final FlowDataConnectionConfiguration data() {
        return this.data;
    }

    public final FlowConditionalConnectionConfiguration conditional() {
        return this.conditional;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.data());
        hashCode = 31 * hashCode + Objects.hashCode(this.conditional());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FlowConnectionConfiguration)) {
            return false;
        }
        FlowConnectionConfiguration other = (FlowConnectionConfiguration)obj;
        return Objects.equals(this.data(), other.data()) && Objects.equals(this.conditional(), other.conditional());
    }

    public final String toString() {
        return ToString.builder((String)"FlowConnectionConfiguration").add("Data", (Object)this.data()).add("Conditional", (Object)this.conditional()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "data": {
                return Optional.ofNullable(clazz.cast(this.data()));
            }
            case "conditional": {
                return Optional.ofNullable(clazz.cast(this.conditional()));
            }
        }
        return Optional.empty();
    }

    public static FlowConnectionConfiguration fromData(FlowDataConnectionConfiguration data) {
        return (FlowConnectionConfiguration)FlowConnectionConfiguration.builder().data(data).build();
    }

    public static FlowConnectionConfiguration fromData(Consumer<FlowDataConnectionConfiguration.Builder> data) {
        FlowDataConnectionConfiguration.Builder builder = FlowDataConnectionConfiguration.builder();
        data.accept(builder);
        return FlowConnectionConfiguration.fromData((FlowDataConnectionConfiguration)builder.build());
    }

    public static FlowConnectionConfiguration fromConditional(FlowConditionalConnectionConfiguration conditional) {
        return (FlowConnectionConfiguration)FlowConnectionConfiguration.builder().conditional(conditional).build();
    }

    public static FlowConnectionConfiguration fromConditional(Consumer<FlowConditionalConnectionConfiguration.Builder> conditional) {
        FlowConditionalConnectionConfiguration.Builder builder = FlowConditionalConnectionConfiguration.builder();
        conditional.accept(builder);
        return FlowConnectionConfiguration.fromConditional((FlowConditionalConnectionConfiguration)builder.build());
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("data", DATA_FIELD);
        map.put("conditional", CONDITIONAL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<FlowConnectionConfiguration, T> g) {
        return obj -> g.apply((FlowConnectionConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        DATA,
        CONDITIONAL,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private FlowDataConnectionConfiguration data;
        private FlowConditionalConnectionConfiguration conditional;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(FlowConnectionConfiguration model) {
            this.data(model.data);
            this.conditional(model.conditional);
        }

        public final FlowDataConnectionConfiguration.Builder getData() {
            return this.data != null ? this.data.toBuilder() : null;
        }

        public final void setData(FlowDataConnectionConfiguration.BuilderImpl data) {
            FlowDataConnectionConfiguration oldValue = this.data;
            this.data = data != null ? data.build() : null;
            this.handleUnionValueChange(Type.DATA, oldValue, this.data);
        }

        @Override
        public final Builder data(FlowDataConnectionConfiguration data) {
            FlowDataConnectionConfiguration oldValue = this.data;
            this.data = data;
            this.handleUnionValueChange(Type.DATA, oldValue, this.data);
            return this;
        }

        public final FlowConditionalConnectionConfiguration.Builder getConditional() {
            return this.conditional != null ? this.conditional.toBuilder() : null;
        }

        public final void setConditional(FlowConditionalConnectionConfiguration.BuilderImpl conditional) {
            FlowConditionalConnectionConfiguration oldValue = this.conditional;
            this.conditional = conditional != null ? conditional.build() : null;
            this.handleUnionValueChange(Type.CONDITIONAL, oldValue, this.conditional);
        }

        @Override
        public final Builder conditional(FlowConditionalConnectionConfiguration conditional) {
            FlowConditionalConnectionConfiguration oldValue = this.conditional;
            this.conditional = conditional;
            this.handleUnionValueChange(Type.CONDITIONAL, oldValue, this.conditional);
            return this;
        }

        public FlowConnectionConfiguration build() {
            return new FlowConnectionConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, FlowConnectionConfiguration> {
        public Builder data(FlowDataConnectionConfiguration var1);

        default public Builder data(Consumer<FlowDataConnectionConfiguration.Builder> data) {
            return this.data((FlowDataConnectionConfiguration)((FlowDataConnectionConfiguration.Builder)FlowDataConnectionConfiguration.builder().applyMutation(data)).build());
        }

        public Builder conditional(FlowConditionalConnectionConfiguration var1);

        default public Builder conditional(Consumer<FlowConditionalConnectionConfiguration.Builder> conditional) {
            return this.conditional((FlowConditionalConnectionConfiguration)((FlowConditionalConnectionConfiguration.Builder)FlowConditionalConnectionConfiguration.builder().applyMutation(conditional)).build());
        }
    }
}

