/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagent.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.bedrockagent.model.AgentStatus;
import software.amazon.awssdk.services.bedrockagent.model.BedrockAgentResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeleteAgentResponse
extends BedrockAgentResponse
implements ToCopyableBuilder<Builder, DeleteAgentResponse> {
    private static final SdkField<String> AGENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("agentId").getter(DeleteAgentResponse.getter(DeleteAgentResponse::agentId)).setter(DeleteAgentResponse.setter(Builder::agentId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("agentId").build()}).build();
    private static final SdkField<String> AGENT_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("agentStatus").getter(DeleteAgentResponse.getter(DeleteAgentResponse::agentStatusAsString)).setter(DeleteAgentResponse.setter(Builder::agentStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("agentStatus").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AGENT_ID_FIELD, AGENT_STATUS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DeleteAgentResponse.memberNameToFieldInitializer();
    private final String agentId;
    private final String agentStatus;

    private DeleteAgentResponse(BuilderImpl builder) {
        super(builder);
        this.agentId = builder.agentId;
        this.agentStatus = builder.agentStatus;
    }

    public final String agentId() {
        return this.agentId;
    }

    public final AgentStatus agentStatus() {
        return AgentStatus.fromValue(this.agentStatus);
    }

    public final String agentStatusAsString() {
        return this.agentStatus;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.agentId());
        hashCode = 31 * hashCode + Objects.hashCode(this.agentStatusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteAgentResponse)) {
            return false;
        }
        DeleteAgentResponse other = (DeleteAgentResponse)((Object)obj);
        return Objects.equals(this.agentId(), other.agentId()) && Objects.equals(this.agentStatusAsString(), other.agentStatusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"DeleteAgentResponse").add("AgentId", (Object)this.agentId()).add("AgentStatus", (Object)this.agentStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "agentId": {
                return Optional.ofNullable(clazz.cast(this.agentId()));
            }
            case "agentStatus": {
                return Optional.ofNullable(clazz.cast(this.agentStatusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("agentId", AGENT_ID_FIELD);
        map.put("agentStatus", AGENT_STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeleteAgentResponse, T> g) {
        return obj -> g.apply((DeleteAgentResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BedrockAgentResponse.BuilderImpl
    implements Builder {
        private String agentId;
        private String agentStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteAgentResponse model) {
            super(model);
            this.agentId(model.agentId);
            this.agentStatus(model.agentStatus);
        }

        public final String getAgentId() {
            return this.agentId;
        }

        public final void setAgentId(String agentId) {
            this.agentId = agentId;
        }

        @Override
        public final Builder agentId(String agentId) {
            this.agentId = agentId;
            return this;
        }

        public final String getAgentStatus() {
            return this.agentStatus;
        }

        public final void setAgentStatus(String agentStatus) {
            this.agentStatus = agentStatus;
        }

        @Override
        public final Builder agentStatus(String agentStatus) {
            this.agentStatus = agentStatus;
            return this;
        }

        @Override
        public final Builder agentStatus(AgentStatus agentStatus) {
            this.agentStatus(agentStatus == null ? null : agentStatus.toString());
            return this;
        }

        @Override
        public DeleteAgentResponse build() {
            return new DeleteAgentResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends BedrockAgentResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DeleteAgentResponse> {
        public Builder agentId(String var1);

        public Builder agentStatus(String var1);

        public Builder agentStatus(AgentStatus var1);
    }
}

