/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagent.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.bedrockagent.model.ContentDataSourceType;
import software.amazon.awssdk.services.bedrockagent.model.CustomDocumentIdentifier;
import software.amazon.awssdk.services.bedrockagent.model.S3Location;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DocumentIdentifier
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DocumentIdentifier> {
    private static final SdkField<CustomDocumentIdentifier> CUSTOM_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("custom").getter(DocumentIdentifier.getter(DocumentIdentifier::custom)).setter(DocumentIdentifier.setter(Builder::custom)).constructor(CustomDocumentIdentifier::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("custom").build()}).build();
    private static final SdkField<String> DATA_SOURCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("dataSourceType").getter(DocumentIdentifier.getter(DocumentIdentifier::dataSourceTypeAsString)).setter(DocumentIdentifier.setter(Builder::dataSourceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataSourceType").build()}).build();
    private static final SdkField<S3Location> S3_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("s3").getter(DocumentIdentifier.getter(DocumentIdentifier::s3)).setter(DocumentIdentifier.setter(Builder::s3)).constructor(S3Location::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CUSTOM_FIELD, DATA_SOURCE_TYPE_FIELD, S3_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DocumentIdentifier.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final CustomDocumentIdentifier custom;
    private final String dataSourceType;
    private final S3Location s3;

    private DocumentIdentifier(BuilderImpl builder) {
        this.custom = builder.custom;
        this.dataSourceType = builder.dataSourceType;
        this.s3 = builder.s3;
    }

    public final CustomDocumentIdentifier custom() {
        return this.custom;
    }

    public final ContentDataSourceType dataSourceType() {
        return ContentDataSourceType.fromValue(this.dataSourceType);
    }

    public final String dataSourceTypeAsString() {
        return this.dataSourceType;
    }

    public final S3Location s3() {
        return this.s3;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.custom());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataSourceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DocumentIdentifier)) {
            return false;
        }
        DocumentIdentifier other = (DocumentIdentifier)obj;
        return Objects.equals(this.custom(), other.custom()) && Objects.equals(this.dataSourceTypeAsString(), other.dataSourceTypeAsString()) && Objects.equals(this.s3(), other.s3());
    }

    public final String toString() {
        return ToString.builder((String)"DocumentIdentifier").add("Custom", (Object)this.custom()).add("DataSourceType", (Object)this.dataSourceTypeAsString()).add("S3", (Object)this.s3()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "custom": {
                return Optional.ofNullable(clazz.cast(this.custom()));
            }
            case "dataSourceType": {
                return Optional.ofNullable(clazz.cast(this.dataSourceTypeAsString()));
            }
            case "s3": {
                return Optional.ofNullable(clazz.cast(this.s3()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("custom", CUSTOM_FIELD);
        map.put("dataSourceType", DATA_SOURCE_TYPE_FIELD);
        map.put("s3", S3_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DocumentIdentifier, T> g) {
        return obj -> g.apply((DocumentIdentifier)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private CustomDocumentIdentifier custom;
        private String dataSourceType;
        private S3Location s3;

        private BuilderImpl() {
        }

        private BuilderImpl(DocumentIdentifier model) {
            this.custom(model.custom);
            this.dataSourceType(model.dataSourceType);
            this.s3(model.s3);
        }

        public final CustomDocumentIdentifier.Builder getCustom() {
            return this.custom != null ? this.custom.toBuilder() : null;
        }

        public final void setCustom(CustomDocumentIdentifier.BuilderImpl custom) {
            this.custom = custom != null ? custom.build() : null;
        }

        @Override
        public final Builder custom(CustomDocumentIdentifier custom) {
            this.custom = custom;
            return this;
        }

        public final String getDataSourceType() {
            return this.dataSourceType;
        }

        public final void setDataSourceType(String dataSourceType) {
            this.dataSourceType = dataSourceType;
        }

        @Override
        public final Builder dataSourceType(String dataSourceType) {
            this.dataSourceType = dataSourceType;
            return this;
        }

        @Override
        public final Builder dataSourceType(ContentDataSourceType dataSourceType) {
            this.dataSourceType(dataSourceType == null ? null : dataSourceType.toString());
            return this;
        }

        public final S3Location.Builder getS3() {
            return this.s3 != null ? this.s3.toBuilder() : null;
        }

        public final void setS3(S3Location.BuilderImpl s3) {
            this.s3 = s3 != null ? s3.build() : null;
        }

        @Override
        public final Builder s3(S3Location s3) {
            this.s3 = s3;
            return this;
        }

        public DocumentIdentifier build() {
            return new DocumentIdentifier(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DocumentIdentifier> {
        public Builder custom(CustomDocumentIdentifier var1);

        default public Builder custom(Consumer<CustomDocumentIdentifier.Builder> custom) {
            return this.custom((CustomDocumentIdentifier)((CustomDocumentIdentifier.Builder)CustomDocumentIdentifier.builder().applyMutation(custom)).build());
        }

        public Builder dataSourceType(String var1);

        public Builder dataSourceType(ContentDataSourceType var1);

        public Builder s3(S3Location var1);

        default public Builder s3(Consumer<S3Location.Builder> s3) {
            return this.s3((S3Location)((S3Location.Builder)S3Location.builder().applyMutation(s3)).build());
        }
    }
}

