/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagent.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.bedrockagent.BedrockAgentClient;
import software.amazon.awssdk.services.bedrockagent.internal.UserAgentUtils;
import software.amazon.awssdk.services.bedrockagent.model.AgentCollaboratorSummary;
import software.amazon.awssdk.services.bedrockagent.model.ListAgentCollaboratorsRequest;
import software.amazon.awssdk.services.bedrockagent.model.ListAgentCollaboratorsResponse;

public class ListAgentCollaboratorsIterable
implements SdkIterable<ListAgentCollaboratorsResponse> {
    private final BedrockAgentClient client;
    private final ListAgentCollaboratorsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListAgentCollaboratorsIterable(BedrockAgentClient client, ListAgentCollaboratorsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListAgentCollaboratorsResponseFetcher();
    }

    public Iterator<ListAgentCollaboratorsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<AgentCollaboratorSummary> agentCollaboratorSummaries() {
        Function<ListAgentCollaboratorsResponse, Iterator> getIterator = response -> {
            if (response != null && response.agentCollaboratorSummaries() != null) {
                return response.agentCollaboratorSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListAgentCollaboratorsResponseFetcher
    implements SyncPageFetcher<ListAgentCollaboratorsResponse> {
        private ListAgentCollaboratorsResponseFetcher() {
        }

        public boolean hasNextPage(ListAgentCollaboratorsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListAgentCollaboratorsResponse nextPage(ListAgentCollaboratorsResponse previousPage) {
            if (previousPage == null) {
                return ListAgentCollaboratorsIterable.this.client.listAgentCollaborators(ListAgentCollaboratorsIterable.this.firstRequest);
            }
            return ListAgentCollaboratorsIterable.this.client.listAgentCollaborators((ListAgentCollaboratorsRequest)((Object)ListAgentCollaboratorsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

