/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagent.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SemanticChunkingConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SemanticChunkingConfiguration> {
    private static final SdkField<Integer> BREAKPOINT_PERCENTILE_THRESHOLD_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("breakpointPercentileThreshold").getter(SemanticChunkingConfiguration.getter(SemanticChunkingConfiguration::breakpointPercentileThreshold)).setter(SemanticChunkingConfiguration.setter(Builder::breakpointPercentileThreshold)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("breakpointPercentileThreshold").build()}).build();
    private static final SdkField<Integer> BUFFER_SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("bufferSize").getter(SemanticChunkingConfiguration.getter(SemanticChunkingConfiguration::bufferSize)).setter(SemanticChunkingConfiguration.setter(Builder::bufferSize)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bufferSize").build()}).build();
    private static final SdkField<Integer> MAX_TOKENS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("maxTokens").getter(SemanticChunkingConfiguration.getter(SemanticChunkingConfiguration::maxTokens)).setter(SemanticChunkingConfiguration.setter(Builder::maxTokens)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxTokens").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BREAKPOINT_PERCENTILE_THRESHOLD_FIELD, BUFFER_SIZE_FIELD, MAX_TOKENS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = SemanticChunkingConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Integer breakpointPercentileThreshold;
    private final Integer bufferSize;
    private final Integer maxTokens;

    private SemanticChunkingConfiguration(BuilderImpl builder) {
        this.breakpointPercentileThreshold = builder.breakpointPercentileThreshold;
        this.bufferSize = builder.bufferSize;
        this.maxTokens = builder.maxTokens;
    }

    public final Integer breakpointPercentileThreshold() {
        return this.breakpointPercentileThreshold;
    }

    public final Integer bufferSize() {
        return this.bufferSize;
    }

    public final Integer maxTokens() {
        return this.maxTokens;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.breakpointPercentileThreshold());
        hashCode = 31 * hashCode + Objects.hashCode(this.bufferSize());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxTokens());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SemanticChunkingConfiguration)) {
            return false;
        }
        SemanticChunkingConfiguration other = (SemanticChunkingConfiguration)obj;
        return Objects.equals(this.breakpointPercentileThreshold(), other.breakpointPercentileThreshold()) && Objects.equals(this.bufferSize(), other.bufferSize()) && Objects.equals(this.maxTokens(), other.maxTokens());
    }

    public final String toString() {
        return ToString.builder((String)"SemanticChunkingConfiguration").add("BreakpointPercentileThreshold", (Object)this.breakpointPercentileThreshold()).add("BufferSize", (Object)this.bufferSize()).add("MaxTokens", (Object)this.maxTokens()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "breakpointPercentileThreshold": {
                return Optional.ofNullable(clazz.cast(this.breakpointPercentileThreshold()));
            }
            case "bufferSize": {
                return Optional.ofNullable(clazz.cast(this.bufferSize()));
            }
            case "maxTokens": {
                return Optional.ofNullable(clazz.cast(this.maxTokens()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<Integer>> map = new HashMap<String, SdkField<Integer>>();
        map.put("breakpointPercentileThreshold", BREAKPOINT_PERCENTILE_THRESHOLD_FIELD);
        map.put("bufferSize", BUFFER_SIZE_FIELD);
        map.put("maxTokens", MAX_TOKENS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SemanticChunkingConfiguration, T> g) {
        return obj -> g.apply((SemanticChunkingConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer breakpointPercentileThreshold;
        private Integer bufferSize;
        private Integer maxTokens;

        private BuilderImpl() {
        }

        private BuilderImpl(SemanticChunkingConfiguration model) {
            this.breakpointPercentileThreshold(model.breakpointPercentileThreshold);
            this.bufferSize(model.bufferSize);
            this.maxTokens(model.maxTokens);
        }

        public final Integer getBreakpointPercentileThreshold() {
            return this.breakpointPercentileThreshold;
        }

        public final void setBreakpointPercentileThreshold(Integer breakpointPercentileThreshold) {
            this.breakpointPercentileThreshold = breakpointPercentileThreshold;
        }

        @Override
        public final Builder breakpointPercentileThreshold(Integer breakpointPercentileThreshold) {
            this.breakpointPercentileThreshold = breakpointPercentileThreshold;
            return this;
        }

        public final Integer getBufferSize() {
            return this.bufferSize;
        }

        public final void setBufferSize(Integer bufferSize) {
            this.bufferSize = bufferSize;
        }

        @Override
        public final Builder bufferSize(Integer bufferSize) {
            this.bufferSize = bufferSize;
            return this;
        }

        public final Integer getMaxTokens() {
            return this.maxTokens;
        }

        public final void setMaxTokens(Integer maxTokens) {
            this.maxTokens = maxTokens;
        }

        @Override
        public final Builder maxTokens(Integer maxTokens) {
            this.maxTokens = maxTokens;
            return this;
        }

        public SemanticChunkingConfiguration build() {
            return new SemanticChunkingConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SemanticChunkingConfiguration> {
        public Builder breakpointPercentileThreshold(Integer var1);

        public Builder bufferSize(Integer var1);

        public Builder maxTokens(Integer var1);
    }
}

