/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagent.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.bedrockagent.model.EmbeddingDataType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BedrockEmbeddingModelConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, BedrockEmbeddingModelConfiguration> {
    private static final SdkField<Integer> DIMENSIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("dimensions").getter(BedrockEmbeddingModelConfiguration.getter(BedrockEmbeddingModelConfiguration::dimensions)).setter(BedrockEmbeddingModelConfiguration.setter(Builder::dimensions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dimensions").build()}).build();
    private static final SdkField<String> EMBEDDING_DATA_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("embeddingDataType").getter(BedrockEmbeddingModelConfiguration.getter(BedrockEmbeddingModelConfiguration::embeddingDataTypeAsString)).setter(BedrockEmbeddingModelConfiguration.setter(Builder::embeddingDataType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("embeddingDataType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DIMENSIONS_FIELD, EMBEDDING_DATA_TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = BedrockEmbeddingModelConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Integer dimensions;
    private final String embeddingDataType;

    private BedrockEmbeddingModelConfiguration(BuilderImpl builder) {
        this.dimensions = builder.dimensions;
        this.embeddingDataType = builder.embeddingDataType;
    }

    public final Integer dimensions() {
        return this.dimensions;
    }

    public final EmbeddingDataType embeddingDataType() {
        return EmbeddingDataType.fromValue(this.embeddingDataType);
    }

    public final String embeddingDataTypeAsString() {
        return this.embeddingDataType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.dimensions());
        hashCode = 31 * hashCode + Objects.hashCode(this.embeddingDataTypeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BedrockEmbeddingModelConfiguration)) {
            return false;
        }
        BedrockEmbeddingModelConfiguration other = (BedrockEmbeddingModelConfiguration)obj;
        return Objects.equals(this.dimensions(), other.dimensions()) && Objects.equals(this.embeddingDataTypeAsString(), other.embeddingDataTypeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"BedrockEmbeddingModelConfiguration").add("Dimensions", (Object)this.dimensions()).add("EmbeddingDataType", (Object)this.embeddingDataTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "dimensions": {
                return Optional.ofNullable(clazz.cast(this.dimensions()));
            }
            case "embeddingDataType": {
                return Optional.ofNullable(clazz.cast(this.embeddingDataTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("dimensions", DIMENSIONS_FIELD);
        map.put("embeddingDataType", EMBEDDING_DATA_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BedrockEmbeddingModelConfiguration, T> g) {
        return obj -> g.apply((BedrockEmbeddingModelConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer dimensions;
        private String embeddingDataType;

        private BuilderImpl() {
        }

        private BuilderImpl(BedrockEmbeddingModelConfiguration model) {
            this.dimensions(model.dimensions);
            this.embeddingDataType(model.embeddingDataType);
        }

        public final Integer getDimensions() {
            return this.dimensions;
        }

        public final void setDimensions(Integer dimensions) {
            this.dimensions = dimensions;
        }

        @Override
        public final Builder dimensions(Integer dimensions) {
            this.dimensions = dimensions;
            return this;
        }

        public final String getEmbeddingDataType() {
            return this.embeddingDataType;
        }

        public final void setEmbeddingDataType(String embeddingDataType) {
            this.embeddingDataType = embeddingDataType;
        }

        @Override
        public final Builder embeddingDataType(String embeddingDataType) {
            this.embeddingDataType = embeddingDataType;
            return this;
        }

        @Override
        public final Builder embeddingDataType(EmbeddingDataType embeddingDataType) {
            this.embeddingDataType(embeddingDataType == null ? null : embeddingDataType.toString());
            return this;
        }

        public BedrockEmbeddingModelConfiguration build() {
            return new BedrockEmbeddingModelConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, BedrockEmbeddingModelConfiguration> {
        public Builder dimensions(Integer var1);

        public Builder embeddingDataType(String var1);

        public Builder embeddingDataType(EmbeddingDataType var1);
    }
}

