/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagent.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.bedrockagent.model.AgentCollaboration;
import software.amazon.awssdk.services.bedrockagent.model.AgentStatus;
import software.amazon.awssdk.services.bedrockagent.model.FailureReasonsCopier;
import software.amazon.awssdk.services.bedrockagent.model.GuardrailConfiguration;
import software.amazon.awssdk.services.bedrockagent.model.MemoryConfiguration;
import software.amazon.awssdk.services.bedrockagent.model.PromptOverrideConfiguration;
import software.amazon.awssdk.services.bedrockagent.model.RecommendedActionsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AgentVersion
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AgentVersion> {
    private static final SdkField<String> AGENT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("agentArn").getter(AgentVersion.getter(AgentVersion::agentArn)).setter(AgentVersion.setter(Builder::agentArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("agentArn").build()}).build();
    private static final SdkField<String> AGENT_COLLABORATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("agentCollaboration").getter(AgentVersion.getter(AgentVersion::agentCollaborationAsString)).setter(AgentVersion.setter(Builder::agentCollaboration)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("agentCollaboration").build()}).build();
    private static final SdkField<String> AGENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("agentId").getter(AgentVersion.getter(AgentVersion::agentId)).setter(AgentVersion.setter(Builder::agentId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("agentId").build()}).build();
    private static final SdkField<String> AGENT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("agentName").getter(AgentVersion.getter(AgentVersion::agentName)).setter(AgentVersion.setter(Builder::agentName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("agentName").build()}).build();
    private static final SdkField<String> AGENT_RESOURCE_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("agentResourceRoleArn").getter(AgentVersion.getter(AgentVersion::agentResourceRoleArn)).setter(AgentVersion.setter(Builder::agentResourceRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("agentResourceRoleArn").build()}).build();
    private static final SdkField<String> AGENT_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("agentStatus").getter(AgentVersion.getter(AgentVersion::agentStatusAsString)).setter(AgentVersion.setter(Builder::agentStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("agentStatus").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdAt").getter(AgentVersion.getter(AgentVersion::createdAt)).setter(AgentVersion.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> CUSTOMER_ENCRYPTION_KEY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("customerEncryptionKeyArn").getter(AgentVersion.getter(AgentVersion::customerEncryptionKeyArn)).setter(AgentVersion.setter(Builder::customerEncryptionKeyArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customerEncryptionKeyArn").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(AgentVersion.getter(AgentVersion::description)).setter(AgentVersion.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<List<String>> FAILURE_REASONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("failureReasons").getter(AgentVersion.getter(AgentVersion::failureReasons)).setter(AgentVersion.setter(Builder::failureReasons)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failureReasons").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> FOUNDATION_MODEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("foundationModel").getter(AgentVersion.getter(AgentVersion::foundationModel)).setter(AgentVersion.setter(Builder::foundationModel)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("foundationModel").build()}).build();
    private static final SdkField<GuardrailConfiguration> GUARDRAIL_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("guardrailConfiguration").getter(AgentVersion.getter(AgentVersion::guardrailConfiguration)).setter(AgentVersion.setter(Builder::guardrailConfiguration)).constructor(GuardrailConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("guardrailConfiguration").build()}).build();
    private static final SdkField<Integer> IDLE_SESSION_TTL_IN_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("idleSessionTTLInSeconds").getter(AgentVersion.getter(AgentVersion::idleSessionTTLInSeconds)).setter(AgentVersion.setter(Builder::idleSessionTTLInSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("idleSessionTTLInSeconds").build()}).build();
    private static final SdkField<String> INSTRUCTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("instruction").getter(AgentVersion.getter(AgentVersion::instruction)).setter(AgentVersion.setter(Builder::instruction)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instruction").build()}).build();
    private static final SdkField<MemoryConfiguration> MEMORY_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("memoryConfiguration").getter(AgentVersion.getter(AgentVersion::memoryConfiguration)).setter(AgentVersion.setter(Builder::memoryConfiguration)).constructor(MemoryConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("memoryConfiguration").build()}).build();
    private static final SdkField<PromptOverrideConfiguration> PROMPT_OVERRIDE_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("promptOverrideConfiguration").getter(AgentVersion.getter(AgentVersion::promptOverrideConfiguration)).setter(AgentVersion.setter(Builder::promptOverrideConfiguration)).constructor(PromptOverrideConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("promptOverrideConfiguration").build()}).build();
    private static final SdkField<List<String>> RECOMMENDED_ACTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("recommendedActions").getter(AgentVersion.getter(AgentVersion::recommendedActions)).setter(AgentVersion.setter(Builder::recommendedActions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recommendedActions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("updatedAt").getter(AgentVersion.getter(AgentVersion::updatedAt)).setter(AgentVersion.setter(Builder::updatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("version").getter(AgentVersion.getter(AgentVersion::version)).setter(AgentVersion.setter(Builder::version)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("version").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AGENT_ARN_FIELD, AGENT_COLLABORATION_FIELD, AGENT_ID_FIELD, AGENT_NAME_FIELD, AGENT_RESOURCE_ROLE_ARN_FIELD, AGENT_STATUS_FIELD, CREATED_AT_FIELD, CUSTOMER_ENCRYPTION_KEY_ARN_FIELD, DESCRIPTION_FIELD, FAILURE_REASONS_FIELD, FOUNDATION_MODEL_FIELD, GUARDRAIL_CONFIGURATION_FIELD, IDLE_SESSION_TTL_IN_SECONDS_FIELD, INSTRUCTION_FIELD, MEMORY_CONFIGURATION_FIELD, PROMPT_OVERRIDE_CONFIGURATION_FIELD, RECOMMENDED_ACTIONS_FIELD, UPDATED_AT_FIELD, VERSION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AgentVersion.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String agentArn;
    private final String agentCollaboration;
    private final String agentId;
    private final String agentName;
    private final String agentResourceRoleArn;
    private final String agentStatus;
    private final Instant createdAt;
    private final String customerEncryptionKeyArn;
    private final String description;
    private final List<String> failureReasons;
    private final String foundationModel;
    private final GuardrailConfiguration guardrailConfiguration;
    private final Integer idleSessionTTLInSeconds;
    private final String instruction;
    private final MemoryConfiguration memoryConfiguration;
    private final PromptOverrideConfiguration promptOverrideConfiguration;
    private final List<String> recommendedActions;
    private final Instant updatedAt;
    private final String version;

    private AgentVersion(BuilderImpl builder) {
        this.agentArn = builder.agentArn;
        this.agentCollaboration = builder.agentCollaboration;
        this.agentId = builder.agentId;
        this.agentName = builder.agentName;
        this.agentResourceRoleArn = builder.agentResourceRoleArn;
        this.agentStatus = builder.agentStatus;
        this.createdAt = builder.createdAt;
        this.customerEncryptionKeyArn = builder.customerEncryptionKeyArn;
        this.description = builder.description;
        this.failureReasons = builder.failureReasons;
        this.foundationModel = builder.foundationModel;
        this.guardrailConfiguration = builder.guardrailConfiguration;
        this.idleSessionTTLInSeconds = builder.idleSessionTTLInSeconds;
        this.instruction = builder.instruction;
        this.memoryConfiguration = builder.memoryConfiguration;
        this.promptOverrideConfiguration = builder.promptOverrideConfiguration;
        this.recommendedActions = builder.recommendedActions;
        this.updatedAt = builder.updatedAt;
        this.version = builder.version;
    }

    public final String agentArn() {
        return this.agentArn;
    }

    public final AgentCollaboration agentCollaboration() {
        return AgentCollaboration.fromValue(this.agentCollaboration);
    }

    public final String agentCollaborationAsString() {
        return this.agentCollaboration;
    }

    public final String agentId() {
        return this.agentId;
    }

    public final String agentName() {
        return this.agentName;
    }

    public final String agentResourceRoleArn() {
        return this.agentResourceRoleArn;
    }

    public final AgentStatus agentStatus() {
        return AgentStatus.fromValue(this.agentStatus);
    }

    public final String agentStatusAsString() {
        return this.agentStatus;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final String customerEncryptionKeyArn() {
        return this.customerEncryptionKeyArn;
    }

    public final String description() {
        return this.description;
    }

    public final boolean hasFailureReasons() {
        return this.failureReasons != null && !(this.failureReasons instanceof SdkAutoConstructList);
    }

    public final List<String> failureReasons() {
        return this.failureReasons;
    }

    public final String foundationModel() {
        return this.foundationModel;
    }

    public final GuardrailConfiguration guardrailConfiguration() {
        return this.guardrailConfiguration;
    }

    public final Integer idleSessionTTLInSeconds() {
        return this.idleSessionTTLInSeconds;
    }

    public final String instruction() {
        return this.instruction;
    }

    public final MemoryConfiguration memoryConfiguration() {
        return this.memoryConfiguration;
    }

    public final PromptOverrideConfiguration promptOverrideConfiguration() {
        return this.promptOverrideConfiguration;
    }

    public final boolean hasRecommendedActions() {
        return this.recommendedActions != null && !(this.recommendedActions instanceof SdkAutoConstructList);
    }

    public final List<String> recommendedActions() {
        return this.recommendedActions;
    }

    public final Instant updatedAt() {
        return this.updatedAt;
    }

    public final String version() {
        return this.version;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.agentArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.agentCollaborationAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.agentId());
        hashCode = 31 * hashCode + Objects.hashCode(this.agentName());
        hashCode = 31 * hashCode + Objects.hashCode(this.agentResourceRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.agentStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.customerEncryptionKeyArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFailureReasons() ? this.failureReasons() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.foundationModel());
        hashCode = 31 * hashCode + Objects.hashCode(this.guardrailConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.idleSessionTTLInSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.instruction());
        hashCode = 31 * hashCode + Objects.hashCode(this.memoryConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.promptOverrideConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRecommendedActions() ? this.recommendedActions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.updatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.version());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AgentVersion)) {
            return false;
        }
        AgentVersion other = (AgentVersion)obj;
        return Objects.equals(this.agentArn(), other.agentArn()) && Objects.equals(this.agentCollaborationAsString(), other.agentCollaborationAsString()) && Objects.equals(this.agentId(), other.agentId()) && Objects.equals(this.agentName(), other.agentName()) && Objects.equals(this.agentResourceRoleArn(), other.agentResourceRoleArn()) && Objects.equals(this.agentStatusAsString(), other.agentStatusAsString()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.customerEncryptionKeyArn(), other.customerEncryptionKeyArn()) && Objects.equals(this.description(), other.description()) && this.hasFailureReasons() == other.hasFailureReasons() && Objects.equals(this.failureReasons(), other.failureReasons()) && Objects.equals(this.foundationModel(), other.foundationModel()) && Objects.equals(this.guardrailConfiguration(), other.guardrailConfiguration()) && Objects.equals(this.idleSessionTTLInSeconds(), other.idleSessionTTLInSeconds()) && Objects.equals(this.instruction(), other.instruction()) && Objects.equals(this.memoryConfiguration(), other.memoryConfiguration()) && Objects.equals(this.promptOverrideConfiguration(), other.promptOverrideConfiguration()) && this.hasRecommendedActions() == other.hasRecommendedActions() && Objects.equals(this.recommendedActions(), other.recommendedActions()) && Objects.equals(this.updatedAt(), other.updatedAt()) && Objects.equals(this.version(), other.version());
    }

    public final String toString() {
        return ToString.builder((String)"AgentVersion").add("AgentArn", (Object)this.agentArn()).add("AgentCollaboration", (Object)this.agentCollaborationAsString()).add("AgentId", (Object)this.agentId()).add("AgentName", (Object)this.agentName()).add("AgentResourceRoleArn", (Object)this.agentResourceRoleArn()).add("AgentStatus", (Object)this.agentStatusAsString()).add("CreatedAt", (Object)this.createdAt()).add("CustomerEncryptionKeyArn", (Object)this.customerEncryptionKeyArn()).add("Description", (Object)this.description()).add("FailureReasons", this.hasFailureReasons() ? this.failureReasons() : null).add("FoundationModel", (Object)this.foundationModel()).add("GuardrailConfiguration", (Object)this.guardrailConfiguration()).add("IdleSessionTTLInSeconds", (Object)this.idleSessionTTLInSeconds()).add("Instruction", (Object)(this.instruction() == null ? null : "*** Sensitive Data Redacted ***")).add("MemoryConfiguration", (Object)this.memoryConfiguration()).add("PromptOverrideConfiguration", (Object)(this.promptOverrideConfiguration() == null ? null : "*** Sensitive Data Redacted ***")).add("RecommendedActions", this.hasRecommendedActions() ? this.recommendedActions() : null).add("UpdatedAt", (Object)this.updatedAt()).add("Version", (Object)this.version()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "agentArn": {
                return Optional.ofNullable(clazz.cast(this.agentArn()));
            }
            case "agentCollaboration": {
                return Optional.ofNullable(clazz.cast(this.agentCollaborationAsString()));
            }
            case "agentId": {
                return Optional.ofNullable(clazz.cast(this.agentId()));
            }
            case "agentName": {
                return Optional.ofNullable(clazz.cast(this.agentName()));
            }
            case "agentResourceRoleArn": {
                return Optional.ofNullable(clazz.cast(this.agentResourceRoleArn()));
            }
            case "agentStatus": {
                return Optional.ofNullable(clazz.cast(this.agentStatusAsString()));
            }
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "customerEncryptionKeyArn": {
                return Optional.ofNullable(clazz.cast(this.customerEncryptionKeyArn()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "failureReasons": {
                return Optional.ofNullable(clazz.cast(this.failureReasons()));
            }
            case "foundationModel": {
                return Optional.ofNullable(clazz.cast(this.foundationModel()));
            }
            case "guardrailConfiguration": {
                return Optional.ofNullable(clazz.cast(this.guardrailConfiguration()));
            }
            case "idleSessionTTLInSeconds": {
                return Optional.ofNullable(clazz.cast(this.idleSessionTTLInSeconds()));
            }
            case "instruction": {
                return Optional.ofNullable(clazz.cast(this.instruction()));
            }
            case "memoryConfiguration": {
                return Optional.ofNullable(clazz.cast(this.memoryConfiguration()));
            }
            case "promptOverrideConfiguration": {
                return Optional.ofNullable(clazz.cast(this.promptOverrideConfiguration()));
            }
            case "recommendedActions": {
                return Optional.ofNullable(clazz.cast(this.recommendedActions()));
            }
            case "updatedAt": {
                return Optional.ofNullable(clazz.cast(this.updatedAt()));
            }
            case "version": {
                return Optional.ofNullable(clazz.cast(this.version()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("agentArn", AGENT_ARN_FIELD);
        map.put("agentCollaboration", AGENT_COLLABORATION_FIELD);
        map.put("agentId", AGENT_ID_FIELD);
        map.put("agentName", AGENT_NAME_FIELD);
        map.put("agentResourceRoleArn", AGENT_RESOURCE_ROLE_ARN_FIELD);
        map.put("agentStatus", AGENT_STATUS_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("customerEncryptionKeyArn", CUSTOMER_ENCRYPTION_KEY_ARN_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("failureReasons", FAILURE_REASONS_FIELD);
        map.put("foundationModel", FOUNDATION_MODEL_FIELD);
        map.put("guardrailConfiguration", GUARDRAIL_CONFIGURATION_FIELD);
        map.put("idleSessionTTLInSeconds", IDLE_SESSION_TTL_IN_SECONDS_FIELD);
        map.put("instruction", INSTRUCTION_FIELD);
        map.put("memoryConfiguration", MEMORY_CONFIGURATION_FIELD);
        map.put("promptOverrideConfiguration", PROMPT_OVERRIDE_CONFIGURATION_FIELD);
        map.put("recommendedActions", RECOMMENDED_ACTIONS_FIELD);
        map.put("updatedAt", UPDATED_AT_FIELD);
        map.put("version", VERSION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AgentVersion, T> g) {
        return obj -> g.apply((AgentVersion)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String agentArn;
        private String agentCollaboration;
        private String agentId;
        private String agentName;
        private String agentResourceRoleArn;
        private String agentStatus;
        private Instant createdAt;
        private String customerEncryptionKeyArn;
        private String description;
        private List<String> failureReasons = DefaultSdkAutoConstructList.getInstance();
        private String foundationModel;
        private GuardrailConfiguration guardrailConfiguration;
        private Integer idleSessionTTLInSeconds;
        private String instruction;
        private MemoryConfiguration memoryConfiguration;
        private PromptOverrideConfiguration promptOverrideConfiguration;
        private List<String> recommendedActions = DefaultSdkAutoConstructList.getInstance();
        private Instant updatedAt;
        private String version;

        private BuilderImpl() {
        }

        private BuilderImpl(AgentVersion model) {
            this.agentArn(model.agentArn);
            this.agentCollaboration(model.agentCollaboration);
            this.agentId(model.agentId);
            this.agentName(model.agentName);
            this.agentResourceRoleArn(model.agentResourceRoleArn);
            this.agentStatus(model.agentStatus);
            this.createdAt(model.createdAt);
            this.customerEncryptionKeyArn(model.customerEncryptionKeyArn);
            this.description(model.description);
            this.failureReasons(model.failureReasons);
            this.foundationModel(model.foundationModel);
            this.guardrailConfiguration(model.guardrailConfiguration);
            this.idleSessionTTLInSeconds(model.idleSessionTTLInSeconds);
            this.instruction(model.instruction);
            this.memoryConfiguration(model.memoryConfiguration);
            this.promptOverrideConfiguration(model.promptOverrideConfiguration);
            this.recommendedActions(model.recommendedActions);
            this.updatedAt(model.updatedAt);
            this.version(model.version);
        }

        public final String getAgentArn() {
            return this.agentArn;
        }

        public final void setAgentArn(String agentArn) {
            this.agentArn = agentArn;
        }

        @Override
        public final Builder agentArn(String agentArn) {
            this.agentArn = agentArn;
            return this;
        }

        public final String getAgentCollaboration() {
            return this.agentCollaboration;
        }

        public final void setAgentCollaboration(String agentCollaboration) {
            this.agentCollaboration = agentCollaboration;
        }

        @Override
        public final Builder agentCollaboration(String agentCollaboration) {
            this.agentCollaboration = agentCollaboration;
            return this;
        }

        @Override
        public final Builder agentCollaboration(AgentCollaboration agentCollaboration) {
            this.agentCollaboration(agentCollaboration == null ? null : agentCollaboration.toString());
            return this;
        }

        public final String getAgentId() {
            return this.agentId;
        }

        public final void setAgentId(String agentId) {
            this.agentId = agentId;
        }

        @Override
        public final Builder agentId(String agentId) {
            this.agentId = agentId;
            return this;
        }

        public final String getAgentName() {
            return this.agentName;
        }

        public final void setAgentName(String agentName) {
            this.agentName = agentName;
        }

        @Override
        public final Builder agentName(String agentName) {
            this.agentName = agentName;
            return this;
        }

        public final String getAgentResourceRoleArn() {
            return this.agentResourceRoleArn;
        }

        public final void setAgentResourceRoleArn(String agentResourceRoleArn) {
            this.agentResourceRoleArn = agentResourceRoleArn;
        }

        @Override
        public final Builder agentResourceRoleArn(String agentResourceRoleArn) {
            this.agentResourceRoleArn = agentResourceRoleArn;
            return this;
        }

        public final String getAgentStatus() {
            return this.agentStatus;
        }

        public final void setAgentStatus(String agentStatus) {
            this.agentStatus = agentStatus;
        }

        @Override
        public final Builder agentStatus(String agentStatus) {
            this.agentStatus = agentStatus;
            return this;
        }

        @Override
        public final Builder agentStatus(AgentStatus agentStatus) {
            this.agentStatus(agentStatus == null ? null : agentStatus.toString());
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getCustomerEncryptionKeyArn() {
            return this.customerEncryptionKeyArn;
        }

        public final void setCustomerEncryptionKeyArn(String customerEncryptionKeyArn) {
            this.customerEncryptionKeyArn = customerEncryptionKeyArn;
        }

        @Override
        public final Builder customerEncryptionKeyArn(String customerEncryptionKeyArn) {
            this.customerEncryptionKeyArn = customerEncryptionKeyArn;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Collection<String> getFailureReasons() {
            if (this.failureReasons instanceof SdkAutoConstructList) {
                return null;
            }
            return this.failureReasons;
        }

        public final void setFailureReasons(Collection<String> failureReasons) {
            this.failureReasons = FailureReasonsCopier.copy(failureReasons);
        }

        @Override
        public final Builder failureReasons(Collection<String> failureReasons) {
            this.failureReasons = FailureReasonsCopier.copy(failureReasons);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failureReasons(String ... failureReasons) {
            this.failureReasons(Arrays.asList(failureReasons));
            return this;
        }

        public final String getFoundationModel() {
            return this.foundationModel;
        }

        public final void setFoundationModel(String foundationModel) {
            this.foundationModel = foundationModel;
        }

        @Override
        public final Builder foundationModel(String foundationModel) {
            this.foundationModel = foundationModel;
            return this;
        }

        public final GuardrailConfiguration.Builder getGuardrailConfiguration() {
            return this.guardrailConfiguration != null ? this.guardrailConfiguration.toBuilder() : null;
        }

        public final void setGuardrailConfiguration(GuardrailConfiguration.BuilderImpl guardrailConfiguration) {
            this.guardrailConfiguration = guardrailConfiguration != null ? guardrailConfiguration.build() : null;
        }

        @Override
        public final Builder guardrailConfiguration(GuardrailConfiguration guardrailConfiguration) {
            this.guardrailConfiguration = guardrailConfiguration;
            return this;
        }

        public final Integer getIdleSessionTTLInSeconds() {
            return this.idleSessionTTLInSeconds;
        }

        public final void setIdleSessionTTLInSeconds(Integer idleSessionTTLInSeconds) {
            this.idleSessionTTLInSeconds = idleSessionTTLInSeconds;
        }

        @Override
        public final Builder idleSessionTTLInSeconds(Integer idleSessionTTLInSeconds) {
            this.idleSessionTTLInSeconds = idleSessionTTLInSeconds;
            return this;
        }

        public final String getInstruction() {
            return this.instruction;
        }

        public final void setInstruction(String instruction) {
            this.instruction = instruction;
        }

        @Override
        public final Builder instruction(String instruction) {
            this.instruction = instruction;
            return this;
        }

        public final MemoryConfiguration.Builder getMemoryConfiguration() {
            return this.memoryConfiguration != null ? this.memoryConfiguration.toBuilder() : null;
        }

        public final void setMemoryConfiguration(MemoryConfiguration.BuilderImpl memoryConfiguration) {
            this.memoryConfiguration = memoryConfiguration != null ? memoryConfiguration.build() : null;
        }

        @Override
        public final Builder memoryConfiguration(MemoryConfiguration memoryConfiguration) {
            this.memoryConfiguration = memoryConfiguration;
            return this;
        }

        public final PromptOverrideConfiguration.Builder getPromptOverrideConfiguration() {
            return this.promptOverrideConfiguration != null ? this.promptOverrideConfiguration.toBuilder() : null;
        }

        public final void setPromptOverrideConfiguration(PromptOverrideConfiguration.BuilderImpl promptOverrideConfiguration) {
            this.promptOverrideConfiguration = promptOverrideConfiguration != null ? promptOverrideConfiguration.build() : null;
        }

        @Override
        public final Builder promptOverrideConfiguration(PromptOverrideConfiguration promptOverrideConfiguration) {
            this.promptOverrideConfiguration = promptOverrideConfiguration;
            return this;
        }

        public final Collection<String> getRecommendedActions() {
            if (this.recommendedActions instanceof SdkAutoConstructList) {
                return null;
            }
            return this.recommendedActions;
        }

        public final void setRecommendedActions(Collection<String> recommendedActions) {
            this.recommendedActions = RecommendedActionsCopier.copy(recommendedActions);
        }

        @Override
        public final Builder recommendedActions(Collection<String> recommendedActions) {
            this.recommendedActions = RecommendedActionsCopier.copy(recommendedActions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder recommendedActions(String ... recommendedActions) {
            this.recommendedActions(Arrays.asList(recommendedActions));
            return this;
        }

        public final Instant getUpdatedAt() {
            return this.updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public final String getVersion() {
            return this.version;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        @Override
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        public AgentVersion build() {
            return new AgentVersion(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AgentVersion> {
        public Builder agentArn(String var1);

        public Builder agentCollaboration(String var1);

        public Builder agentCollaboration(AgentCollaboration var1);

        public Builder agentId(String var1);

        public Builder agentName(String var1);

        public Builder agentResourceRoleArn(String var1);

        public Builder agentStatus(String var1);

        public Builder agentStatus(AgentStatus var1);

        public Builder createdAt(Instant var1);

        public Builder customerEncryptionKeyArn(String var1);

        public Builder description(String var1);

        public Builder failureReasons(Collection<String> var1);

        public Builder failureReasons(String ... var1);

        public Builder foundationModel(String var1);

        public Builder guardrailConfiguration(GuardrailConfiguration var1);

        default public Builder guardrailConfiguration(Consumer<GuardrailConfiguration.Builder> guardrailConfiguration) {
            return this.guardrailConfiguration((GuardrailConfiguration)((GuardrailConfiguration.Builder)GuardrailConfiguration.builder().applyMutation(guardrailConfiguration)).build());
        }

        public Builder idleSessionTTLInSeconds(Integer var1);

        public Builder instruction(String var1);

        public Builder memoryConfiguration(MemoryConfiguration var1);

        default public Builder memoryConfiguration(Consumer<MemoryConfiguration.Builder> memoryConfiguration) {
            return this.memoryConfiguration((MemoryConfiguration)((MemoryConfiguration.Builder)MemoryConfiguration.builder().applyMutation(memoryConfiguration)).build());
        }

        public Builder promptOverrideConfiguration(PromptOverrideConfiguration var1);

        default public Builder promptOverrideConfiguration(Consumer<PromptOverrideConfiguration.Builder> promptOverrideConfiguration) {
            return this.promptOverrideConfiguration((PromptOverrideConfiguration)((PromptOverrideConfiguration.Builder)PromptOverrideConfiguration.builder().applyMutation(promptOverrideConfiguration)).build());
        }

        public Builder recommendedActions(Collection<String> var1);

        public Builder recommendedActions(String ... var1);

        public Builder updatedAt(Instant var1);

        public Builder version(String var1);
    }
}

