/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagent.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details about an unknown output for a node.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UnknownNodeOutputFlowValidationDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<UnknownNodeOutputFlowValidationDetails.Builder, UnknownNodeOutputFlowValidationDetails> {
    private static final SdkField<String> NODE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("node")
            .getter(getter(UnknownNodeOutputFlowValidationDetails::node)).setter(setter(Builder::node))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("node").build()).build();

    private static final SdkField<String> OUTPUT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("output")
            .getter(getter(UnknownNodeOutputFlowValidationDetails::output)).setter(setter(Builder::output))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("output").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NODE_FIELD, OUTPUT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String node;

    private final String output;

    private UnknownNodeOutputFlowValidationDetails(BuilderImpl builder) {
        this.node = builder.node;
        this.output = builder.output;
    }

    /**
     * <p>
     * The name of the node with the unknown output.
     * </p>
     * 
     * @return The name of the node with the unknown output.
     */
    public final String node() {
        return node;
    }

    /**
     * <p>
     * The name of the unknown output.
     * </p>
     * 
     * @return The name of the unknown output.
     */
    public final String output() {
        return output;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(node());
        hashCode = 31 * hashCode + Objects.hashCode(output());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UnknownNodeOutputFlowValidationDetails)) {
            return false;
        }
        UnknownNodeOutputFlowValidationDetails other = (UnknownNodeOutputFlowValidationDetails) obj;
        return Objects.equals(node(), other.node()) && Objects.equals(output(), other.output());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UnknownNodeOutputFlowValidationDetails").add("Node", node()).add("Output", output()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "node":
            return Optional.ofNullable(clazz.cast(node()));
        case "output":
            return Optional.ofNullable(clazz.cast(output()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("node", NODE_FIELD);
        map.put("output", OUTPUT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UnknownNodeOutputFlowValidationDetails, T> g) {
        return obj -> g.apply((UnknownNodeOutputFlowValidationDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, UnknownNodeOutputFlowValidationDetails> {
        /**
         * <p>
         * The name of the node with the unknown output.
         * </p>
         * 
         * @param node
         *        The name of the node with the unknown output.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder node(String node);

        /**
         * <p>
         * The name of the unknown output.
         * </p>
         * 
         * @param output
         *        The name of the unknown output.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder output(String output);
    }

    static final class BuilderImpl implements Builder {
        private String node;

        private String output;

        private BuilderImpl() {
        }

        private BuilderImpl(UnknownNodeOutputFlowValidationDetails model) {
            node(model.node);
            output(model.output);
        }

        public final String getNode() {
            return node;
        }

        public final void setNode(String node) {
            this.node = node;
        }

        @Override
        public final Builder node(String node) {
            this.node = node;
            return this;
        }

        public final String getOutput() {
            return output;
        }

        public final void setOutput(String output) {
            this.output = output;
        }

        @Override
        public final Builder output(String output) {
            this.output = output;
            return this;
        }

        @Override
        public UnknownNodeOutputFlowValidationDetails build() {
            return new UnknownNodeOutputFlowValidationDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
