/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagent.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains configurations for an inline code node in your flow. Inline code nodes let you write and execute code
 * directly within your flow, enabling data transformations, custom logic, and integrations without needing an external
 * Lambda function.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class InlineCodeFlowNodeConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<InlineCodeFlowNodeConfiguration.Builder, InlineCodeFlowNodeConfiguration> {
    private static final SdkField<String> CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("code")
            .getter(getter(InlineCodeFlowNodeConfiguration::code)).setter(setter(Builder::code))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("code").build()).build();

    private static final SdkField<String> LANGUAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("language").getter(getter(InlineCodeFlowNodeConfiguration::languageAsString))
            .setter(setter(Builder::language))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("language").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CODE_FIELD, LANGUAGE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String code;

    private final String language;

    private InlineCodeFlowNodeConfiguration(BuilderImpl builder) {
        this.code = builder.code;
        this.language = builder.language;
    }

    /**
     * <p>
     * The code that's executed in your inline code node. The code can access input data from previous nodes in the
     * flow, perform operations on that data, and produce output that can be used by other nodes in your flow.
     * </p>
     * <p>
     * The code must be valid in the programming <code>language</code> that you specify.
     * </p>
     * 
     * @return The code that's executed in your inline code node. The code can access input data from previous nodes in
     *         the flow, perform operations on that data, and produce output that can be used by other nodes in your
     *         flow.</p>
     *         <p>
     *         The code must be valid in the programming <code>language</code> that you specify.
     */
    public final String code() {
        return code;
    }

    /**
     * <p>
     * The programming language used by your inline code node.
     * </p>
     * <p>
     * The code must be valid in the programming <code>language</code> that you specify. Currently, only Python 3 (
     * <code>Python_3</code>) is supported.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #language} will
     * return {@link SupportedLanguages#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #languageAsString}.
     * </p>
     * 
     * @return The programming language used by your inline code node.</p>
     *         <p>
     *         The code must be valid in the programming <code>language</code> that you specify. Currently, only Python
     *         3 (<code>Python_3</code>) is supported.
     * @see SupportedLanguages
     */
    public final SupportedLanguages language() {
        return SupportedLanguages.fromValue(language);
    }

    /**
     * <p>
     * The programming language used by your inline code node.
     * </p>
     * <p>
     * The code must be valid in the programming <code>language</code> that you specify. Currently, only Python 3 (
     * <code>Python_3</code>) is supported.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #language} will
     * return {@link SupportedLanguages#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #languageAsString}.
     * </p>
     * 
     * @return The programming language used by your inline code node.</p>
     *         <p>
     *         The code must be valid in the programming <code>language</code> that you specify. Currently, only Python
     *         3 (<code>Python_3</code>) is supported.
     * @see SupportedLanguages
     */
    public final String languageAsString() {
        return language;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(code());
        hashCode = 31 * hashCode + Objects.hashCode(languageAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InlineCodeFlowNodeConfiguration)) {
            return false;
        }
        InlineCodeFlowNodeConfiguration other = (InlineCodeFlowNodeConfiguration) obj;
        return Objects.equals(code(), other.code()) && Objects.equals(languageAsString(), other.languageAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("InlineCodeFlowNodeConfiguration")
                .add("Code", code() == null ? null : "*** Sensitive Data Redacted ***").add("Language", languageAsString())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "code":
            return Optional.ofNullable(clazz.cast(code()));
        case "language":
            return Optional.ofNullable(clazz.cast(languageAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("code", CODE_FIELD);
        map.put("language", LANGUAGE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<InlineCodeFlowNodeConfiguration, T> g) {
        return obj -> g.apply((InlineCodeFlowNodeConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, InlineCodeFlowNodeConfiguration> {
        /**
         * <p>
         * The code that's executed in your inline code node. The code can access input data from previous nodes in the
         * flow, perform operations on that data, and produce output that can be used by other nodes in your flow.
         * </p>
         * <p>
         * The code must be valid in the programming <code>language</code> that you specify.
         * </p>
         * 
         * @param code
         *        The code that's executed in your inline code node. The code can access input data from previous nodes
         *        in the flow, perform operations on that data, and produce output that can be used by other nodes in
         *        your flow.</p>
         *        <p>
         *        The code must be valid in the programming <code>language</code> that you specify.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder code(String code);

        /**
         * <p>
         * The programming language used by your inline code node.
         * </p>
         * <p>
         * The code must be valid in the programming <code>language</code> that you specify. Currently, only Python 3 (
         * <code>Python_3</code>) is supported.
         * </p>
         * 
         * @param language
         *        The programming language used by your inline code node.</p>
         *        <p>
         *        The code must be valid in the programming <code>language</code> that you specify. Currently, only
         *        Python 3 (<code>Python_3</code>) is supported.
         * @see SupportedLanguages
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SupportedLanguages
         */
        Builder language(String language);

        /**
         * <p>
         * The programming language used by your inline code node.
         * </p>
         * <p>
         * The code must be valid in the programming <code>language</code> that you specify. Currently, only Python 3 (
         * <code>Python_3</code>) is supported.
         * </p>
         * 
         * @param language
         *        The programming language used by your inline code node.</p>
         *        <p>
         *        The code must be valid in the programming <code>language</code> that you specify. Currently, only
         *        Python 3 (<code>Python_3</code>) is supported.
         * @see SupportedLanguages
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SupportedLanguages
         */
        Builder language(SupportedLanguages language);
    }

    static final class BuilderImpl implements Builder {
        private String code;

        private String language;

        private BuilderImpl() {
        }

        private BuilderImpl(InlineCodeFlowNodeConfiguration model) {
            code(model.code);
            language(model.language);
        }

        public final String getCode() {
            return code;
        }

        public final void setCode(String code) {
            this.code = code;
        }

        @Override
        public final Builder code(String code) {
            this.code = code;
            return this;
        }

        public final String getLanguage() {
            return language;
        }

        public final void setLanguage(String language) {
            this.language = language;
        }

        @Override
        public final Builder language(String language) {
            this.language = language;
            return this;
        }

        @Override
        public final Builder language(SupportedLanguages language) {
            this.language(language == null ? null : language.toString());
            return this;
        }

        @Override
        public InlineCodeFlowNodeConfiguration build() {
            return new InlineCodeFlowNodeConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
