/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagent.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains configurations for a node in your flow. For more information, see <a
 * href="https://docs.aws.amazon.com/bedrock/latest/userguide/flows-nodes.html">Node types in a flow</a> in the Amazon
 * Bedrock User Guide.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FlowNodeConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<FlowNodeConfiguration.Builder, FlowNodeConfiguration> {
    private static final SdkField<AgentFlowNodeConfiguration> AGENT_FIELD = SdkField
            .<AgentFlowNodeConfiguration> builder(MarshallingType.SDK_POJO).memberName("agent")
            .getter(getter(FlowNodeConfiguration::agent)).setter(setter(Builder::agent))
            .constructor(AgentFlowNodeConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("agent").build()).build();

    private static final SdkField<CollectorFlowNodeConfiguration> COLLECTOR_FIELD = SdkField
            .<CollectorFlowNodeConfiguration> builder(MarshallingType.SDK_POJO).memberName("collector")
            .getter(getter(FlowNodeConfiguration::collector)).setter(setter(Builder::collector))
            .constructor(CollectorFlowNodeConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("collector").build()).build();

    private static final SdkField<ConditionFlowNodeConfiguration> CONDITION_FIELD = SdkField
            .<ConditionFlowNodeConfiguration> builder(MarshallingType.SDK_POJO).memberName("condition")
            .getter(getter(FlowNodeConfiguration::condition)).setter(setter(Builder::condition))
            .constructor(ConditionFlowNodeConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("condition").build()).build();

    private static final SdkField<InlineCodeFlowNodeConfiguration> INLINE_CODE_FIELD = SdkField
            .<InlineCodeFlowNodeConfiguration> builder(MarshallingType.SDK_POJO).memberName("inlineCode")
            .getter(getter(FlowNodeConfiguration::inlineCode)).setter(setter(Builder::inlineCode))
            .constructor(InlineCodeFlowNodeConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inlineCode").build()).build();

    private static final SdkField<InputFlowNodeConfiguration> INPUT_FIELD = SdkField
            .<InputFlowNodeConfiguration> builder(MarshallingType.SDK_POJO).memberName("input")
            .getter(getter(FlowNodeConfiguration::input)).setter(setter(Builder::input))
            .constructor(InputFlowNodeConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("input").build()).build();

    private static final SdkField<IteratorFlowNodeConfiguration> ITERATOR_FIELD = SdkField
            .<IteratorFlowNodeConfiguration> builder(MarshallingType.SDK_POJO).memberName("iterator")
            .getter(getter(FlowNodeConfiguration::iterator)).setter(setter(Builder::iterator))
            .constructor(IteratorFlowNodeConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("iterator").build()).build();

    private static final SdkField<KnowledgeBaseFlowNodeConfiguration> KNOWLEDGE_BASE_FIELD = SdkField
            .<KnowledgeBaseFlowNodeConfiguration> builder(MarshallingType.SDK_POJO).memberName("knowledgeBase")
            .getter(getter(FlowNodeConfiguration::knowledgeBase)).setter(setter(Builder::knowledgeBase))
            .constructor(KnowledgeBaseFlowNodeConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("knowledgeBase").build()).build();

    private static final SdkField<LambdaFunctionFlowNodeConfiguration> LAMBDA_FUNCTION_FIELD = SdkField
            .<LambdaFunctionFlowNodeConfiguration> builder(MarshallingType.SDK_POJO).memberName("lambdaFunction")
            .getter(getter(FlowNodeConfiguration::lambdaFunction)).setter(setter(Builder::lambdaFunction))
            .constructor(LambdaFunctionFlowNodeConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lambdaFunction").build()).build();

    private static final SdkField<LexFlowNodeConfiguration> LEX_FIELD = SdkField
            .<LexFlowNodeConfiguration> builder(MarshallingType.SDK_POJO).memberName("lex")
            .getter(getter(FlowNodeConfiguration::lex)).setter(setter(Builder::lex))
            .constructor(LexFlowNodeConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lex").build()).build();

    private static final SdkField<LoopFlowNodeConfiguration> LOOP_FIELD = SdkField
            .<LoopFlowNodeConfiguration> builder(MarshallingType.SDK_POJO).memberName("loop")
            .getter(getter(FlowNodeConfiguration::loop)).setter(setter(Builder::loop))
            .constructor(LoopFlowNodeConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("loop").build()).build();

    private static final SdkField<LoopControllerFlowNodeConfiguration> LOOP_CONTROLLER_FIELD = SdkField
            .<LoopControllerFlowNodeConfiguration> builder(MarshallingType.SDK_POJO).memberName("loopController")
            .getter(getter(FlowNodeConfiguration::loopController)).setter(setter(Builder::loopController))
            .constructor(LoopControllerFlowNodeConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("loopController").build()).build();

    private static final SdkField<LoopInputFlowNodeConfiguration> LOOP_INPUT_FIELD = SdkField
            .<LoopInputFlowNodeConfiguration> builder(MarshallingType.SDK_POJO).memberName("loopInput")
            .getter(getter(FlowNodeConfiguration::loopInput)).setter(setter(Builder::loopInput))
            .constructor(LoopInputFlowNodeConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("loopInput").build()).build();

    private static final SdkField<OutputFlowNodeConfiguration> OUTPUT_FIELD = SdkField
            .<OutputFlowNodeConfiguration> builder(MarshallingType.SDK_POJO).memberName("output")
            .getter(getter(FlowNodeConfiguration::output)).setter(setter(Builder::output))
            .constructor(OutputFlowNodeConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("output").build()).build();

    private static final SdkField<PromptFlowNodeConfiguration> PROMPT_FIELD = SdkField
            .<PromptFlowNodeConfiguration> builder(MarshallingType.SDK_POJO).memberName("prompt")
            .getter(getter(FlowNodeConfiguration::prompt)).setter(setter(Builder::prompt))
            .constructor(PromptFlowNodeConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("prompt").build()).build();

    private static final SdkField<RetrievalFlowNodeConfiguration> RETRIEVAL_FIELD = SdkField
            .<RetrievalFlowNodeConfiguration> builder(MarshallingType.SDK_POJO).memberName("retrieval")
            .getter(getter(FlowNodeConfiguration::retrieval)).setter(setter(Builder::retrieval))
            .constructor(RetrievalFlowNodeConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("retrieval").build()).build();

    private static final SdkField<StorageFlowNodeConfiguration> STORAGE_FIELD = SdkField
            .<StorageFlowNodeConfiguration> builder(MarshallingType.SDK_POJO).memberName("storage")
            .getter(getter(FlowNodeConfiguration::storage)).setter(setter(Builder::storage))
            .constructor(StorageFlowNodeConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("storage").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AGENT_FIELD, COLLECTOR_FIELD,
            CONDITION_FIELD, INLINE_CODE_FIELD, INPUT_FIELD, ITERATOR_FIELD, KNOWLEDGE_BASE_FIELD, LAMBDA_FUNCTION_FIELD,
            LEX_FIELD, LOOP_FIELD, LOOP_CONTROLLER_FIELD, LOOP_INPUT_FIELD, OUTPUT_FIELD, PROMPT_FIELD, RETRIEVAL_FIELD,
            STORAGE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final AgentFlowNodeConfiguration agent;

    private final CollectorFlowNodeConfiguration collector;

    private final ConditionFlowNodeConfiguration condition;

    private final InlineCodeFlowNodeConfiguration inlineCode;

    private final InputFlowNodeConfiguration input;

    private final IteratorFlowNodeConfiguration iterator;

    private final KnowledgeBaseFlowNodeConfiguration knowledgeBase;

    private final LambdaFunctionFlowNodeConfiguration lambdaFunction;

    private final LexFlowNodeConfiguration lex;

    private final LoopFlowNodeConfiguration loop;

    private final LoopControllerFlowNodeConfiguration loopController;

    private final LoopInputFlowNodeConfiguration loopInput;

    private final OutputFlowNodeConfiguration output;

    private final PromptFlowNodeConfiguration prompt;

    private final RetrievalFlowNodeConfiguration retrieval;

    private final StorageFlowNodeConfiguration storage;

    private final Type type;

    private FlowNodeConfiguration(BuilderImpl builder) {
        this.agent = builder.agent;
        this.collector = builder.collector;
        this.condition = builder.condition;
        this.inlineCode = builder.inlineCode;
        this.input = builder.input;
        this.iterator = builder.iterator;
        this.knowledgeBase = builder.knowledgeBase;
        this.lambdaFunction = builder.lambdaFunction;
        this.lex = builder.lex;
        this.loop = builder.loop;
        this.loopController = builder.loopController;
        this.loopInput = builder.loopInput;
        this.output = builder.output;
        this.prompt = builder.prompt;
        this.retrieval = builder.retrieval;
        this.storage = builder.storage;
        this.type = builder.type;
    }

    /**
     * <p>
     * Contains configurations for an agent node in your flow. Invokes an alias of an agent and returns the response.
     * </p>
     * 
     * @return Contains configurations for an agent node in your flow. Invokes an alias of an agent and returns the
     *         response.
     */
    public final AgentFlowNodeConfiguration agent() {
        return agent;
    }

    /**
     * <p>
     * Contains configurations for a collector node in your flow. Collects an iteration of inputs and consolidates them
     * into an array of outputs.
     * </p>
     * 
     * @return Contains configurations for a collector node in your flow. Collects an iteration of inputs and
     *         consolidates them into an array of outputs.
     */
    public final CollectorFlowNodeConfiguration collector() {
        return collector;
    }

    /**
     * <p>
     * Contains configurations for a condition node in your flow. Defines conditions that lead to different branches of
     * the flow.
     * </p>
     * 
     * @return Contains configurations for a condition node in your flow. Defines conditions that lead to different
     *         branches of the flow.
     */
    public final ConditionFlowNodeConfiguration condition() {
        return condition;
    }

    /**
     * <p>
     * Contains configurations for an inline code node in your flow. Inline code nodes let you write and execute code
     * directly within your flow, enabling data transformations, custom logic, and integrations without needing an
     * external Lambda function.
     * </p>
     * 
     * @return Contains configurations for an inline code node in your flow. Inline code nodes let you write and execute
     *         code directly within your flow, enabling data transformations, custom logic, and integrations without
     *         needing an external Lambda function.
     */
    public final InlineCodeFlowNodeConfiguration inlineCode() {
        return inlineCode;
    }

    /**
     * <p>
     * Contains configurations for an input flow node in your flow. The first node in the flow. <code>inputs</code>
     * can't be specified for this node.
     * </p>
     * 
     * @return Contains configurations for an input flow node in your flow. The first node in the flow.
     *         <code>inputs</code> can't be specified for this node.
     */
    public final InputFlowNodeConfiguration input() {
        return input;
    }

    /**
     * <p>
     * Contains configurations for an iterator node in your flow. Takes an input that is an array and iteratively sends
     * each item of the array as an output to the following node. The size of the array is also returned in the output.
     * </p>
     * <p>
     * The output flow node at the end of the flow iteration will return a response for each member of the array. To
     * return only one response, you can include a collector node downstream from the iterator node.
     * </p>
     * 
     * @return Contains configurations for an iterator node in your flow. Takes an input that is an array and
     *         iteratively sends each item of the array as an output to the following node. The size of the array is
     *         also returned in the output.</p>
     *         <p>
     *         The output flow node at the end of the flow iteration will return a response for each member of the
     *         array. To return only one response, you can include a collector node downstream from the iterator node.
     */
    public final IteratorFlowNodeConfiguration iterator() {
        return iterator;
    }

    /**
     * <p>
     * Contains configurations for a knowledge base node in your flow. Queries a knowledge base and returns the
     * retrieved results or generated response.
     * </p>
     * 
     * @return Contains configurations for a knowledge base node in your flow. Queries a knowledge base and returns the
     *         retrieved results or generated response.
     */
    public final KnowledgeBaseFlowNodeConfiguration knowledgeBase() {
        return knowledgeBase;
    }

    /**
     * <p>
     * Contains configurations for a Lambda function node in your flow. Invokes an Lambda function.
     * </p>
     * 
     * @return Contains configurations for a Lambda function node in your flow. Invokes an Lambda function.
     */
    public final LambdaFunctionFlowNodeConfiguration lambdaFunction() {
        return lambdaFunction;
    }

    /**
     * <p>
     * Contains configurations for a Lex node in your flow. Invokes an Amazon Lex bot to identify the intent of the
     * input and return the intent as the output.
     * </p>
     * 
     * @return Contains configurations for a Lex node in your flow. Invokes an Amazon Lex bot to identify the intent of
     *         the input and return the intent as the output.
     */
    public final LexFlowNodeConfiguration lex() {
        return lex;
    }

    /**
     * <p>
     * Contains configurations for a DoWhile loop in your flow.
     * </p>
     * 
     * @return Contains configurations for a DoWhile loop in your flow.
     */
    public final LoopFlowNodeConfiguration loop() {
        return loop;
    }

    /**
     * <p>
     * Contains controller node configurations for a DoWhile loop in your flow.
     * </p>
     * 
     * @return Contains controller node configurations for a DoWhile loop in your flow.
     */
    public final LoopControllerFlowNodeConfiguration loopController() {
        return loopController;
    }

    /**
     * <p>
     * Contains input node configurations for a DoWhile loop in your flow.
     * </p>
     * 
     * @return Contains input node configurations for a DoWhile loop in your flow.
     */
    public final LoopInputFlowNodeConfiguration loopInput() {
        return loopInput;
    }

    /**
     * <p>
     * Contains configurations for an output flow node in your flow. The last node in the flow. <code>outputs</code>
     * can't be specified for this node.
     * </p>
     * 
     * @return Contains configurations for an output flow node in your flow. The last node in the flow.
     *         <code>outputs</code> can't be specified for this node.
     */
    public final OutputFlowNodeConfiguration output() {
        return output;
    }

    /**
     * <p>
     * Contains configurations for a prompt node in your flow. Runs a prompt and generates the model response as the
     * output. You can use a prompt from Prompt management or you can configure one in this node.
     * </p>
     * 
     * @return Contains configurations for a prompt node in your flow. Runs a prompt and generates the model response as
     *         the output. You can use a prompt from Prompt management or you can configure one in this node.
     */
    public final PromptFlowNodeConfiguration prompt() {
        return prompt;
    }

    /**
     * <p>
     * Contains configurations for a retrieval node in your flow. Retrieves data from an Amazon S3 location and returns
     * it as the output.
     * </p>
     * 
     * @return Contains configurations for a retrieval node in your flow. Retrieves data from an Amazon S3 location and
     *         returns it as the output.
     */
    public final RetrievalFlowNodeConfiguration retrieval() {
        return retrieval;
    }

    /**
     * <p>
     * Contains configurations for a storage node in your flow. Stores an input in an Amazon S3 location.
     * </p>
     * 
     * @return Contains configurations for a storage node in your flow. Stores an input in an Amazon S3 location.
     */
    public final StorageFlowNodeConfiguration storage() {
        return storage;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(agent());
        hashCode = 31 * hashCode + Objects.hashCode(collector());
        hashCode = 31 * hashCode + Objects.hashCode(condition());
        hashCode = 31 * hashCode + Objects.hashCode(inlineCode());
        hashCode = 31 * hashCode + Objects.hashCode(input());
        hashCode = 31 * hashCode + Objects.hashCode(iterator());
        hashCode = 31 * hashCode + Objects.hashCode(knowledgeBase());
        hashCode = 31 * hashCode + Objects.hashCode(lambdaFunction());
        hashCode = 31 * hashCode + Objects.hashCode(lex());
        hashCode = 31 * hashCode + Objects.hashCode(loop());
        hashCode = 31 * hashCode + Objects.hashCode(loopController());
        hashCode = 31 * hashCode + Objects.hashCode(loopInput());
        hashCode = 31 * hashCode + Objects.hashCode(output());
        hashCode = 31 * hashCode + Objects.hashCode(prompt());
        hashCode = 31 * hashCode + Objects.hashCode(retrieval());
        hashCode = 31 * hashCode + Objects.hashCode(storage());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FlowNodeConfiguration)) {
            return false;
        }
        FlowNodeConfiguration other = (FlowNodeConfiguration) obj;
        return Objects.equals(agent(), other.agent()) && Objects.equals(collector(), other.collector())
                && Objects.equals(condition(), other.condition()) && Objects.equals(inlineCode(), other.inlineCode())
                && Objects.equals(input(), other.input()) && Objects.equals(iterator(), other.iterator())
                && Objects.equals(knowledgeBase(), other.knowledgeBase())
                && Objects.equals(lambdaFunction(), other.lambdaFunction()) && Objects.equals(lex(), other.lex())
                && Objects.equals(loop(), other.loop()) && Objects.equals(loopController(), other.loopController())
                && Objects.equals(loopInput(), other.loopInput()) && Objects.equals(output(), other.output())
                && Objects.equals(prompt(), other.prompt()) && Objects.equals(retrieval(), other.retrieval())
                && Objects.equals(storage(), other.storage());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FlowNodeConfiguration").add("Agent", agent()).add("Collector", collector())
                .add("Condition", condition()).add("InlineCode", inlineCode()).add("Input", input()).add("Iterator", iterator())
                .add("KnowledgeBase", knowledgeBase()).add("LambdaFunction", lambdaFunction()).add("Lex", lex())
                .add("Loop", loop()).add("LoopController", loopController()).add("LoopInput", loopInput())
                .add("Output", output()).add("Prompt", prompt()).add("Retrieval", retrieval()).add("Storage", storage()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "agent":
            return Optional.ofNullable(clazz.cast(agent()));
        case "collector":
            return Optional.ofNullable(clazz.cast(collector()));
        case "condition":
            return Optional.ofNullable(clazz.cast(condition()));
        case "inlineCode":
            return Optional.ofNullable(clazz.cast(inlineCode()));
        case "input":
            return Optional.ofNullable(clazz.cast(input()));
        case "iterator":
            return Optional.ofNullable(clazz.cast(iterator()));
        case "knowledgeBase":
            return Optional.ofNullable(clazz.cast(knowledgeBase()));
        case "lambdaFunction":
            return Optional.ofNullable(clazz.cast(lambdaFunction()));
        case "lex":
            return Optional.ofNullable(clazz.cast(lex()));
        case "loop":
            return Optional.ofNullable(clazz.cast(loop()));
        case "loopController":
            return Optional.ofNullable(clazz.cast(loopController()));
        case "loopInput":
            return Optional.ofNullable(clazz.cast(loopInput()));
        case "output":
            return Optional.ofNullable(clazz.cast(output()));
        case "prompt":
            return Optional.ofNullable(clazz.cast(prompt()));
        case "retrieval":
            return Optional.ofNullable(clazz.cast(retrieval()));
        case "storage":
            return Optional.ofNullable(clazz.cast(storage()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #agent()} initialized to the given value.
     *
     * <p>
     * Contains configurations for an agent node in your flow. Invokes an alias of an agent and returns the response.
     * </p>
     * 
     * @param agent
     *        Contains configurations for an agent node in your flow. Invokes an alias of an agent and returns the
     *        response.
     */
    public static FlowNodeConfiguration fromAgent(AgentFlowNodeConfiguration agent) {
        return builder().agent(agent).build();
    }

    /**
     * Create an instance of this class with {@link #agent()} initialized to the given value.
     *
     * <p>
     * Contains configurations for an agent node in your flow. Invokes an alias of an agent and returns the response.
     * </p>
     * 
     * @param agent
     *        Contains configurations for an agent node in your flow. Invokes an alias of an agent and returns the
     *        response.
     */
    public static FlowNodeConfiguration fromAgent(Consumer<AgentFlowNodeConfiguration.Builder> agent) {
        AgentFlowNodeConfiguration.Builder builder = AgentFlowNodeConfiguration.builder();
        agent.accept(builder);
        return fromAgent(builder.build());
    }

    /**
     * Create an instance of this class with {@link #collector()} initialized to the given value.
     *
     * <p>
     * Contains configurations for a collector node in your flow. Collects an iteration of inputs and consolidates them
     * into an array of outputs.
     * </p>
     * 
     * @param collector
     *        Contains configurations for a collector node in your flow. Collects an iteration of inputs and
     *        consolidates them into an array of outputs.
     */
    public static FlowNodeConfiguration fromCollector(CollectorFlowNodeConfiguration collector) {
        return builder().collector(collector).build();
    }

    /**
     * Create an instance of this class with {@link #collector()} initialized to the given value.
     *
     * <p>
     * Contains configurations for a collector node in your flow. Collects an iteration of inputs and consolidates them
     * into an array of outputs.
     * </p>
     * 
     * @param collector
     *        Contains configurations for a collector node in your flow. Collects an iteration of inputs and
     *        consolidates them into an array of outputs.
     */
    public static FlowNodeConfiguration fromCollector(Consumer<CollectorFlowNodeConfiguration.Builder> collector) {
        CollectorFlowNodeConfiguration.Builder builder = CollectorFlowNodeConfiguration.builder();
        collector.accept(builder);
        return fromCollector(builder.build());
    }

    /**
     * Create an instance of this class with {@link #condition()} initialized to the given value.
     *
     * <p>
     * Contains configurations for a condition node in your flow. Defines conditions that lead to different branches of
     * the flow.
     * </p>
     * 
     * @param condition
     *        Contains configurations for a condition node in your flow. Defines conditions that lead to different
     *        branches of the flow.
     */
    public static FlowNodeConfiguration fromCondition(ConditionFlowNodeConfiguration condition) {
        return builder().condition(condition).build();
    }

    /**
     * Create an instance of this class with {@link #condition()} initialized to the given value.
     *
     * <p>
     * Contains configurations for a condition node in your flow. Defines conditions that lead to different branches of
     * the flow.
     * </p>
     * 
     * @param condition
     *        Contains configurations for a condition node in your flow. Defines conditions that lead to different
     *        branches of the flow.
     */
    public static FlowNodeConfiguration fromCondition(Consumer<ConditionFlowNodeConfiguration.Builder> condition) {
        ConditionFlowNodeConfiguration.Builder builder = ConditionFlowNodeConfiguration.builder();
        condition.accept(builder);
        return fromCondition(builder.build());
    }

    /**
     * Create an instance of this class with {@link #inlineCode()} initialized to the given value.
     *
     * <p>
     * Contains configurations for an inline code node in your flow. Inline code nodes let you write and execute code
     * directly within your flow, enabling data transformations, custom logic, and integrations without needing an
     * external Lambda function.
     * </p>
     * 
     * @param inlineCode
     *        Contains configurations for an inline code node in your flow. Inline code nodes let you write and execute
     *        code directly within your flow, enabling data transformations, custom logic, and integrations without
     *        needing an external Lambda function.
     */
    public static FlowNodeConfiguration fromInlineCode(InlineCodeFlowNodeConfiguration inlineCode) {
        return builder().inlineCode(inlineCode).build();
    }

    /**
     * Create an instance of this class with {@link #inlineCode()} initialized to the given value.
     *
     * <p>
     * Contains configurations for an inline code node in your flow. Inline code nodes let you write and execute code
     * directly within your flow, enabling data transformations, custom logic, and integrations without needing an
     * external Lambda function.
     * </p>
     * 
     * @param inlineCode
     *        Contains configurations for an inline code node in your flow. Inline code nodes let you write and execute
     *        code directly within your flow, enabling data transformations, custom logic, and integrations without
     *        needing an external Lambda function.
     */
    public static FlowNodeConfiguration fromInlineCode(Consumer<InlineCodeFlowNodeConfiguration.Builder> inlineCode) {
        InlineCodeFlowNodeConfiguration.Builder builder = InlineCodeFlowNodeConfiguration.builder();
        inlineCode.accept(builder);
        return fromInlineCode(builder.build());
    }

    /**
     * Create an instance of this class with {@link #input()} initialized to the given value.
     *
     * <p>
     * Contains configurations for an input flow node in your flow. The first node in the flow. <code>inputs</code>
     * can't be specified for this node.
     * </p>
     * 
     * @param input
     *        Contains configurations for an input flow node in your flow. The first node in the flow.
     *        <code>inputs</code> can't be specified for this node.
     */
    public static FlowNodeConfiguration fromInput(InputFlowNodeConfiguration input) {
        return builder().input(input).build();
    }

    /**
     * Create an instance of this class with {@link #input()} initialized to the given value.
     *
     * <p>
     * Contains configurations for an input flow node in your flow. The first node in the flow. <code>inputs</code>
     * can't be specified for this node.
     * </p>
     * 
     * @param input
     *        Contains configurations for an input flow node in your flow. The first node in the flow.
     *        <code>inputs</code> can't be specified for this node.
     */
    public static FlowNodeConfiguration fromInput(Consumer<InputFlowNodeConfiguration.Builder> input) {
        InputFlowNodeConfiguration.Builder builder = InputFlowNodeConfiguration.builder();
        input.accept(builder);
        return fromInput(builder.build());
    }

    /**
     * Create an instance of this class with {@link #iterator()} initialized to the given value.
     *
     * <p>
     * Contains configurations for an iterator node in your flow. Takes an input that is an array and iteratively sends
     * each item of the array as an output to the following node. The size of the array is also returned in the output.
     * </p>
     * <p>
     * The output flow node at the end of the flow iteration will return a response for each member of the array. To
     * return only one response, you can include a collector node downstream from the iterator node.
     * </p>
     * 
     * @param iterator
     *        Contains configurations for an iterator node in your flow. Takes an input that is an array and iteratively
     *        sends each item of the array as an output to the following node. The size of the array is also returned in
     *        the output.</p>
     *        <p>
     *        The output flow node at the end of the flow iteration will return a response for each member of the array.
     *        To return only one response, you can include a collector node downstream from the iterator node.
     */
    public static FlowNodeConfiguration fromIterator(IteratorFlowNodeConfiguration iterator) {
        return builder().iterator(iterator).build();
    }

    /**
     * Create an instance of this class with {@link #iterator()} initialized to the given value.
     *
     * <p>
     * Contains configurations for an iterator node in your flow. Takes an input that is an array and iteratively sends
     * each item of the array as an output to the following node. The size of the array is also returned in the output.
     * </p>
     * <p>
     * The output flow node at the end of the flow iteration will return a response for each member of the array. To
     * return only one response, you can include a collector node downstream from the iterator node.
     * </p>
     * 
     * @param iterator
     *        Contains configurations for an iterator node in your flow. Takes an input that is an array and iteratively
     *        sends each item of the array as an output to the following node. The size of the array is also returned in
     *        the output.</p>
     *        <p>
     *        The output flow node at the end of the flow iteration will return a response for each member of the array.
     *        To return only one response, you can include a collector node downstream from the iterator node.
     */
    public static FlowNodeConfiguration fromIterator(Consumer<IteratorFlowNodeConfiguration.Builder> iterator) {
        IteratorFlowNodeConfiguration.Builder builder = IteratorFlowNodeConfiguration.builder();
        iterator.accept(builder);
        return fromIterator(builder.build());
    }

    /**
     * Create an instance of this class with {@link #knowledgeBase()} initialized to the given value.
     *
     * <p>
     * Contains configurations for a knowledge base node in your flow. Queries a knowledge base and returns the
     * retrieved results or generated response.
     * </p>
     * 
     * @param knowledgeBase
     *        Contains configurations for a knowledge base node in your flow. Queries a knowledge base and returns the
     *        retrieved results or generated response.
     */
    public static FlowNodeConfiguration fromKnowledgeBase(KnowledgeBaseFlowNodeConfiguration knowledgeBase) {
        return builder().knowledgeBase(knowledgeBase).build();
    }

    /**
     * Create an instance of this class with {@link #knowledgeBase()} initialized to the given value.
     *
     * <p>
     * Contains configurations for a knowledge base node in your flow. Queries a knowledge base and returns the
     * retrieved results or generated response.
     * </p>
     * 
     * @param knowledgeBase
     *        Contains configurations for a knowledge base node in your flow. Queries a knowledge base and returns the
     *        retrieved results or generated response.
     */
    public static FlowNodeConfiguration fromKnowledgeBase(Consumer<KnowledgeBaseFlowNodeConfiguration.Builder> knowledgeBase) {
        KnowledgeBaseFlowNodeConfiguration.Builder builder = KnowledgeBaseFlowNodeConfiguration.builder();
        knowledgeBase.accept(builder);
        return fromKnowledgeBase(builder.build());
    }

    /**
     * Create an instance of this class with {@link #lambdaFunction()} initialized to the given value.
     *
     * <p>
     * Contains configurations for a Lambda function node in your flow. Invokes an Lambda function.
     * </p>
     * 
     * @param lambdaFunction
     *        Contains configurations for a Lambda function node in your flow. Invokes an Lambda function.
     */
    public static FlowNodeConfiguration fromLambdaFunction(LambdaFunctionFlowNodeConfiguration lambdaFunction) {
        return builder().lambdaFunction(lambdaFunction).build();
    }

    /**
     * Create an instance of this class with {@link #lambdaFunction()} initialized to the given value.
     *
     * <p>
     * Contains configurations for a Lambda function node in your flow. Invokes an Lambda function.
     * </p>
     * 
     * @param lambdaFunction
     *        Contains configurations for a Lambda function node in your flow. Invokes an Lambda function.
     */
    public static FlowNodeConfiguration fromLambdaFunction(Consumer<LambdaFunctionFlowNodeConfiguration.Builder> lambdaFunction) {
        LambdaFunctionFlowNodeConfiguration.Builder builder = LambdaFunctionFlowNodeConfiguration.builder();
        lambdaFunction.accept(builder);
        return fromLambdaFunction(builder.build());
    }

    /**
     * Create an instance of this class with {@link #lex()} initialized to the given value.
     *
     * <p>
     * Contains configurations for a Lex node in your flow. Invokes an Amazon Lex bot to identify the intent of the
     * input and return the intent as the output.
     * </p>
     * 
     * @param lex
     *        Contains configurations for a Lex node in your flow. Invokes an Amazon Lex bot to identify the intent of
     *        the input and return the intent as the output.
     */
    public static FlowNodeConfiguration fromLex(LexFlowNodeConfiguration lex) {
        return builder().lex(lex).build();
    }

    /**
     * Create an instance of this class with {@link #lex()} initialized to the given value.
     *
     * <p>
     * Contains configurations for a Lex node in your flow. Invokes an Amazon Lex bot to identify the intent of the
     * input and return the intent as the output.
     * </p>
     * 
     * @param lex
     *        Contains configurations for a Lex node in your flow. Invokes an Amazon Lex bot to identify the intent of
     *        the input and return the intent as the output.
     */
    public static FlowNodeConfiguration fromLex(Consumer<LexFlowNodeConfiguration.Builder> lex) {
        LexFlowNodeConfiguration.Builder builder = LexFlowNodeConfiguration.builder();
        lex.accept(builder);
        return fromLex(builder.build());
    }

    /**
     * Create an instance of this class with {@link #loop()} initialized to the given value.
     *
     * <p>
     * Contains configurations for a DoWhile loop in your flow.
     * </p>
     * 
     * @param loop
     *        Contains configurations for a DoWhile loop in your flow.
     */
    public static FlowNodeConfiguration fromLoop(LoopFlowNodeConfiguration loop) {
        return builder().loop(loop).build();
    }

    /**
     * Create an instance of this class with {@link #loop()} initialized to the given value.
     *
     * <p>
     * Contains configurations for a DoWhile loop in your flow.
     * </p>
     * 
     * @param loop
     *        Contains configurations for a DoWhile loop in your flow.
     */
    public static FlowNodeConfiguration fromLoop(Consumer<LoopFlowNodeConfiguration.Builder> loop) {
        LoopFlowNodeConfiguration.Builder builder = LoopFlowNodeConfiguration.builder();
        loop.accept(builder);
        return fromLoop(builder.build());
    }

    /**
     * Create an instance of this class with {@link #loopController()} initialized to the given value.
     *
     * <p>
     * Contains controller node configurations for a DoWhile loop in your flow.
     * </p>
     * 
     * @param loopController
     *        Contains controller node configurations for a DoWhile loop in your flow.
     */
    public static FlowNodeConfiguration fromLoopController(LoopControllerFlowNodeConfiguration loopController) {
        return builder().loopController(loopController).build();
    }

    /**
     * Create an instance of this class with {@link #loopController()} initialized to the given value.
     *
     * <p>
     * Contains controller node configurations for a DoWhile loop in your flow.
     * </p>
     * 
     * @param loopController
     *        Contains controller node configurations for a DoWhile loop in your flow.
     */
    public static FlowNodeConfiguration fromLoopController(Consumer<LoopControllerFlowNodeConfiguration.Builder> loopController) {
        LoopControllerFlowNodeConfiguration.Builder builder = LoopControllerFlowNodeConfiguration.builder();
        loopController.accept(builder);
        return fromLoopController(builder.build());
    }

    /**
     * Create an instance of this class with {@link #loopInput()} initialized to the given value.
     *
     * <p>
     * Contains input node configurations for a DoWhile loop in your flow.
     * </p>
     * 
     * @param loopInput
     *        Contains input node configurations for a DoWhile loop in your flow.
     */
    public static FlowNodeConfiguration fromLoopInput(LoopInputFlowNodeConfiguration loopInput) {
        return builder().loopInput(loopInput).build();
    }

    /**
     * Create an instance of this class with {@link #loopInput()} initialized to the given value.
     *
     * <p>
     * Contains input node configurations for a DoWhile loop in your flow.
     * </p>
     * 
     * @param loopInput
     *        Contains input node configurations for a DoWhile loop in your flow.
     */
    public static FlowNodeConfiguration fromLoopInput(Consumer<LoopInputFlowNodeConfiguration.Builder> loopInput) {
        LoopInputFlowNodeConfiguration.Builder builder = LoopInputFlowNodeConfiguration.builder();
        loopInput.accept(builder);
        return fromLoopInput(builder.build());
    }

    /**
     * Create an instance of this class with {@link #output()} initialized to the given value.
     *
     * <p>
     * Contains configurations for an output flow node in your flow. The last node in the flow. <code>outputs</code>
     * can't be specified for this node.
     * </p>
     * 
     * @param output
     *        Contains configurations for an output flow node in your flow. The last node in the flow.
     *        <code>outputs</code> can't be specified for this node.
     */
    public static FlowNodeConfiguration fromOutput(OutputFlowNodeConfiguration output) {
        return builder().output(output).build();
    }

    /**
     * Create an instance of this class with {@link #output()} initialized to the given value.
     *
     * <p>
     * Contains configurations for an output flow node in your flow. The last node in the flow. <code>outputs</code>
     * can't be specified for this node.
     * </p>
     * 
     * @param output
     *        Contains configurations for an output flow node in your flow. The last node in the flow.
     *        <code>outputs</code> can't be specified for this node.
     */
    public static FlowNodeConfiguration fromOutput(Consumer<OutputFlowNodeConfiguration.Builder> output) {
        OutputFlowNodeConfiguration.Builder builder = OutputFlowNodeConfiguration.builder();
        output.accept(builder);
        return fromOutput(builder.build());
    }

    /**
     * Create an instance of this class with {@link #prompt()} initialized to the given value.
     *
     * <p>
     * Contains configurations for a prompt node in your flow. Runs a prompt and generates the model response as the
     * output. You can use a prompt from Prompt management or you can configure one in this node.
     * </p>
     * 
     * @param prompt
     *        Contains configurations for a prompt node in your flow. Runs a prompt and generates the model response as
     *        the output. You can use a prompt from Prompt management or you can configure one in this node.
     */
    public static FlowNodeConfiguration fromPrompt(PromptFlowNodeConfiguration prompt) {
        return builder().prompt(prompt).build();
    }

    /**
     * Create an instance of this class with {@link #prompt()} initialized to the given value.
     *
     * <p>
     * Contains configurations for a prompt node in your flow. Runs a prompt and generates the model response as the
     * output. You can use a prompt from Prompt management or you can configure one in this node.
     * </p>
     * 
     * @param prompt
     *        Contains configurations for a prompt node in your flow. Runs a prompt and generates the model response as
     *        the output. You can use a prompt from Prompt management or you can configure one in this node.
     */
    public static FlowNodeConfiguration fromPrompt(Consumer<PromptFlowNodeConfiguration.Builder> prompt) {
        PromptFlowNodeConfiguration.Builder builder = PromptFlowNodeConfiguration.builder();
        prompt.accept(builder);
        return fromPrompt(builder.build());
    }

    /**
     * Create an instance of this class with {@link #retrieval()} initialized to the given value.
     *
     * <p>
     * Contains configurations for a retrieval node in your flow. Retrieves data from an Amazon S3 location and returns
     * it as the output.
     * </p>
     * 
     * @param retrieval
     *        Contains configurations for a retrieval node in your flow. Retrieves data from an Amazon S3 location and
     *        returns it as the output.
     */
    public static FlowNodeConfiguration fromRetrieval(RetrievalFlowNodeConfiguration retrieval) {
        return builder().retrieval(retrieval).build();
    }

    /**
     * Create an instance of this class with {@link #retrieval()} initialized to the given value.
     *
     * <p>
     * Contains configurations for a retrieval node in your flow. Retrieves data from an Amazon S3 location and returns
     * it as the output.
     * </p>
     * 
     * @param retrieval
     *        Contains configurations for a retrieval node in your flow. Retrieves data from an Amazon S3 location and
     *        returns it as the output.
     */
    public static FlowNodeConfiguration fromRetrieval(Consumer<RetrievalFlowNodeConfiguration.Builder> retrieval) {
        RetrievalFlowNodeConfiguration.Builder builder = RetrievalFlowNodeConfiguration.builder();
        retrieval.accept(builder);
        return fromRetrieval(builder.build());
    }

    /**
     * Create an instance of this class with {@link #storage()} initialized to the given value.
     *
     * <p>
     * Contains configurations for a storage node in your flow. Stores an input in an Amazon S3 location.
     * </p>
     * 
     * @param storage
     *        Contains configurations for a storage node in your flow. Stores an input in an Amazon S3 location.
     */
    public static FlowNodeConfiguration fromStorage(StorageFlowNodeConfiguration storage) {
        return builder().storage(storage).build();
    }

    /**
     * Create an instance of this class with {@link #storage()} initialized to the given value.
     *
     * <p>
     * Contains configurations for a storage node in your flow. Stores an input in an Amazon S3 location.
     * </p>
     * 
     * @param storage
     *        Contains configurations for a storage node in your flow. Stores an input in an Amazon S3 location.
     */
    public static FlowNodeConfiguration fromStorage(Consumer<StorageFlowNodeConfiguration.Builder> storage) {
        StorageFlowNodeConfiguration.Builder builder = StorageFlowNodeConfiguration.builder();
        storage.accept(builder);
        return fromStorage(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("agent", AGENT_FIELD);
        map.put("collector", COLLECTOR_FIELD);
        map.put("condition", CONDITION_FIELD);
        map.put("inlineCode", INLINE_CODE_FIELD);
        map.put("input", INPUT_FIELD);
        map.put("iterator", ITERATOR_FIELD);
        map.put("knowledgeBase", KNOWLEDGE_BASE_FIELD);
        map.put("lambdaFunction", LAMBDA_FUNCTION_FIELD);
        map.put("lex", LEX_FIELD);
        map.put("loop", LOOP_FIELD);
        map.put("loopController", LOOP_CONTROLLER_FIELD);
        map.put("loopInput", LOOP_INPUT_FIELD);
        map.put("output", OUTPUT_FIELD);
        map.put("prompt", PROMPT_FIELD);
        map.put("retrieval", RETRIEVAL_FIELD);
        map.put("storage", STORAGE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<FlowNodeConfiguration, T> g) {
        return obj -> g.apply((FlowNodeConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FlowNodeConfiguration> {
        /**
         * <p>
         * Contains configurations for an agent node in your flow. Invokes an alias of an agent and returns the
         * response.
         * </p>
         * 
         * @param agent
         *        Contains configurations for an agent node in your flow. Invokes an alias of an agent and returns the
         *        response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder agent(AgentFlowNodeConfiguration agent);

        /**
         * <p>
         * Contains configurations for an agent node in your flow. Invokes an alias of an agent and returns the
         * response.
         * </p>
         * This is a convenience method that creates an instance of the {@link AgentFlowNodeConfiguration.Builder}
         * avoiding the need to create one manually via {@link AgentFlowNodeConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AgentFlowNodeConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #agent(AgentFlowNodeConfiguration)}.
         * 
         * @param agent
         *        a consumer that will call methods on {@link AgentFlowNodeConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #agent(AgentFlowNodeConfiguration)
         */
        default Builder agent(Consumer<AgentFlowNodeConfiguration.Builder> agent) {
            return agent(AgentFlowNodeConfiguration.builder().applyMutation(agent).build());
        }

        /**
         * <p>
         * Contains configurations for a collector node in your flow. Collects an iteration of inputs and consolidates
         * them into an array of outputs.
         * </p>
         * 
         * @param collector
         *        Contains configurations for a collector node in your flow. Collects an iteration of inputs and
         *        consolidates them into an array of outputs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder collector(CollectorFlowNodeConfiguration collector);

        /**
         * <p>
         * Contains configurations for a collector node in your flow. Collects an iteration of inputs and consolidates
         * them into an array of outputs.
         * </p>
         * This is a convenience method that creates an instance of the {@link CollectorFlowNodeConfiguration.Builder}
         * avoiding the need to create one manually via {@link CollectorFlowNodeConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CollectorFlowNodeConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #collector(CollectorFlowNodeConfiguration)}.
         * 
         * @param collector
         *        a consumer that will call methods on {@link CollectorFlowNodeConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #collector(CollectorFlowNodeConfiguration)
         */
        default Builder collector(Consumer<CollectorFlowNodeConfiguration.Builder> collector) {
            return collector(CollectorFlowNodeConfiguration.builder().applyMutation(collector).build());
        }

        /**
         * <p>
         * Contains configurations for a condition node in your flow. Defines conditions that lead to different branches
         * of the flow.
         * </p>
         * 
         * @param condition
         *        Contains configurations for a condition node in your flow. Defines conditions that lead to different
         *        branches of the flow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder condition(ConditionFlowNodeConfiguration condition);

        /**
         * <p>
         * Contains configurations for a condition node in your flow. Defines conditions that lead to different branches
         * of the flow.
         * </p>
         * This is a convenience method that creates an instance of the {@link ConditionFlowNodeConfiguration.Builder}
         * avoiding the need to create one manually via {@link ConditionFlowNodeConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ConditionFlowNodeConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #condition(ConditionFlowNodeConfiguration)}.
         * 
         * @param condition
         *        a consumer that will call methods on {@link ConditionFlowNodeConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #condition(ConditionFlowNodeConfiguration)
         */
        default Builder condition(Consumer<ConditionFlowNodeConfiguration.Builder> condition) {
            return condition(ConditionFlowNodeConfiguration.builder().applyMutation(condition).build());
        }

        /**
         * <p>
         * Contains configurations for an inline code node in your flow. Inline code nodes let you write and execute
         * code directly within your flow, enabling data transformations, custom logic, and integrations without needing
         * an external Lambda function.
         * </p>
         * 
         * @param inlineCode
         *        Contains configurations for an inline code node in your flow. Inline code nodes let you write and
         *        execute code directly within your flow, enabling data transformations, custom logic, and integrations
         *        without needing an external Lambda function.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inlineCode(InlineCodeFlowNodeConfiguration inlineCode);

        /**
         * <p>
         * Contains configurations for an inline code node in your flow. Inline code nodes let you write and execute
         * code directly within your flow, enabling data transformations, custom logic, and integrations without needing
         * an external Lambda function.
         * </p>
         * This is a convenience method that creates an instance of the {@link InlineCodeFlowNodeConfiguration.Builder}
         * avoiding the need to create one manually via {@link InlineCodeFlowNodeConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link InlineCodeFlowNodeConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #inlineCode(InlineCodeFlowNodeConfiguration)}.
         * 
         * @param inlineCode
         *        a consumer that will call methods on {@link InlineCodeFlowNodeConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #inlineCode(InlineCodeFlowNodeConfiguration)
         */
        default Builder inlineCode(Consumer<InlineCodeFlowNodeConfiguration.Builder> inlineCode) {
            return inlineCode(InlineCodeFlowNodeConfiguration.builder().applyMutation(inlineCode).build());
        }

        /**
         * <p>
         * Contains configurations for an input flow node in your flow. The first node in the flow. <code>inputs</code>
         * can't be specified for this node.
         * </p>
         * 
         * @param input
         *        Contains configurations for an input flow node in your flow. The first node in the flow.
         *        <code>inputs</code> can't be specified for this node.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder input(InputFlowNodeConfiguration input);

        /**
         * <p>
         * Contains configurations for an input flow node in your flow. The first node in the flow. <code>inputs</code>
         * can't be specified for this node.
         * </p>
         * This is a convenience method that creates an instance of the {@link InputFlowNodeConfiguration.Builder}
         * avoiding the need to create one manually via {@link InputFlowNodeConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link InputFlowNodeConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #input(InputFlowNodeConfiguration)}.
         * 
         * @param input
         *        a consumer that will call methods on {@link InputFlowNodeConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #input(InputFlowNodeConfiguration)
         */
        default Builder input(Consumer<InputFlowNodeConfiguration.Builder> input) {
            return input(InputFlowNodeConfiguration.builder().applyMutation(input).build());
        }

        /**
         * <p>
         * Contains configurations for an iterator node in your flow. Takes an input that is an array and iteratively
         * sends each item of the array as an output to the following node. The size of the array is also returned in
         * the output.
         * </p>
         * <p>
         * The output flow node at the end of the flow iteration will return a response for each member of the array. To
         * return only one response, you can include a collector node downstream from the iterator node.
         * </p>
         * 
         * @param iterator
         *        Contains configurations for an iterator node in your flow. Takes an input that is an array and
         *        iteratively sends each item of the array as an output to the following node. The size of the array is
         *        also returned in the output.</p>
         *        <p>
         *        The output flow node at the end of the flow iteration will return a response for each member of the
         *        array. To return only one response, you can include a collector node downstream from the iterator
         *        node.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iterator(IteratorFlowNodeConfiguration iterator);

        /**
         * <p>
         * Contains configurations for an iterator node in your flow. Takes an input that is an array and iteratively
         * sends each item of the array as an output to the following node. The size of the array is also returned in
         * the output.
         * </p>
         * <p>
         * The output flow node at the end of the flow iteration will return a response for each member of the array. To
         * return only one response, you can include a collector node downstream from the iterator node.
         * </p>
         * This is a convenience method that creates an instance of the {@link IteratorFlowNodeConfiguration.Builder}
         * avoiding the need to create one manually via {@link IteratorFlowNodeConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link IteratorFlowNodeConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #iterator(IteratorFlowNodeConfiguration)}.
         * 
         * @param iterator
         *        a consumer that will call methods on {@link IteratorFlowNodeConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #iterator(IteratorFlowNodeConfiguration)
         */
        default Builder iterator(Consumer<IteratorFlowNodeConfiguration.Builder> iterator) {
            return iterator(IteratorFlowNodeConfiguration.builder().applyMutation(iterator).build());
        }

        /**
         * <p>
         * Contains configurations for a knowledge base node in your flow. Queries a knowledge base and returns the
         * retrieved results or generated response.
         * </p>
         * 
         * @param knowledgeBase
         *        Contains configurations for a knowledge base node in your flow. Queries a knowledge base and returns
         *        the retrieved results or generated response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder knowledgeBase(KnowledgeBaseFlowNodeConfiguration knowledgeBase);

        /**
         * <p>
         * Contains configurations for a knowledge base node in your flow. Queries a knowledge base and returns the
         * retrieved results or generated response.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link KnowledgeBaseFlowNodeConfiguration.Builder} avoiding the need to create one manually via
         * {@link KnowledgeBaseFlowNodeConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link KnowledgeBaseFlowNodeConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #knowledgeBase(KnowledgeBaseFlowNodeConfiguration)}.
         * 
         * @param knowledgeBase
         *        a consumer that will call methods on {@link KnowledgeBaseFlowNodeConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #knowledgeBase(KnowledgeBaseFlowNodeConfiguration)
         */
        default Builder knowledgeBase(Consumer<KnowledgeBaseFlowNodeConfiguration.Builder> knowledgeBase) {
            return knowledgeBase(KnowledgeBaseFlowNodeConfiguration.builder().applyMutation(knowledgeBase).build());
        }

        /**
         * <p>
         * Contains configurations for a Lambda function node in your flow. Invokes an Lambda function.
         * </p>
         * 
         * @param lambdaFunction
         *        Contains configurations for a Lambda function node in your flow. Invokes an Lambda function.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lambdaFunction(LambdaFunctionFlowNodeConfiguration lambdaFunction);

        /**
         * <p>
         * Contains configurations for a Lambda function node in your flow. Invokes an Lambda function.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link LambdaFunctionFlowNodeConfiguration.Builder} avoiding the need to create one manually via
         * {@link LambdaFunctionFlowNodeConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LambdaFunctionFlowNodeConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #lambdaFunction(LambdaFunctionFlowNodeConfiguration)}.
         * 
         * @param lambdaFunction
         *        a consumer that will call methods on {@link LambdaFunctionFlowNodeConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #lambdaFunction(LambdaFunctionFlowNodeConfiguration)
         */
        default Builder lambdaFunction(Consumer<LambdaFunctionFlowNodeConfiguration.Builder> lambdaFunction) {
            return lambdaFunction(LambdaFunctionFlowNodeConfiguration.builder().applyMutation(lambdaFunction).build());
        }

        /**
         * <p>
         * Contains configurations for a Lex node in your flow. Invokes an Amazon Lex bot to identify the intent of the
         * input and return the intent as the output.
         * </p>
         * 
         * @param lex
         *        Contains configurations for a Lex node in your flow. Invokes an Amazon Lex bot to identify the intent
         *        of the input and return the intent as the output.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lex(LexFlowNodeConfiguration lex);

        /**
         * <p>
         * Contains configurations for a Lex node in your flow. Invokes an Amazon Lex bot to identify the intent of the
         * input and return the intent as the output.
         * </p>
         * This is a convenience method that creates an instance of the {@link LexFlowNodeConfiguration.Builder}
         * avoiding the need to create one manually via {@link LexFlowNodeConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LexFlowNodeConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #lex(LexFlowNodeConfiguration)}.
         * 
         * @param lex
         *        a consumer that will call methods on {@link LexFlowNodeConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #lex(LexFlowNodeConfiguration)
         */
        default Builder lex(Consumer<LexFlowNodeConfiguration.Builder> lex) {
            return lex(LexFlowNodeConfiguration.builder().applyMutation(lex).build());
        }

        /**
         * <p>
         * Contains configurations for a DoWhile loop in your flow.
         * </p>
         * 
         * @param loop
         *        Contains configurations for a DoWhile loop in your flow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder loop(LoopFlowNodeConfiguration loop);

        /**
         * <p>
         * Contains configurations for a DoWhile loop in your flow.
         * </p>
         * This is a convenience method that creates an instance of the {@link LoopFlowNodeConfiguration.Builder}
         * avoiding the need to create one manually via {@link LoopFlowNodeConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LoopFlowNodeConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #loop(LoopFlowNodeConfiguration)}.
         * 
         * @param loop
         *        a consumer that will call methods on {@link LoopFlowNodeConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #loop(LoopFlowNodeConfiguration)
         */
        default Builder loop(Consumer<LoopFlowNodeConfiguration.Builder> loop) {
            return loop(LoopFlowNodeConfiguration.builder().applyMutation(loop).build());
        }

        /**
         * <p>
         * Contains controller node configurations for a DoWhile loop in your flow.
         * </p>
         * 
         * @param loopController
         *        Contains controller node configurations for a DoWhile loop in your flow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder loopController(LoopControllerFlowNodeConfiguration loopController);

        /**
         * <p>
         * Contains controller node configurations for a DoWhile loop in your flow.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link LoopControllerFlowNodeConfiguration.Builder} avoiding the need to create one manually via
         * {@link LoopControllerFlowNodeConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LoopControllerFlowNodeConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #loopController(LoopControllerFlowNodeConfiguration)}.
         * 
         * @param loopController
         *        a consumer that will call methods on {@link LoopControllerFlowNodeConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #loopController(LoopControllerFlowNodeConfiguration)
         */
        default Builder loopController(Consumer<LoopControllerFlowNodeConfiguration.Builder> loopController) {
            return loopController(LoopControllerFlowNodeConfiguration.builder().applyMutation(loopController).build());
        }

        /**
         * <p>
         * Contains input node configurations for a DoWhile loop in your flow.
         * </p>
         * 
         * @param loopInput
         *        Contains input node configurations for a DoWhile loop in your flow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder loopInput(LoopInputFlowNodeConfiguration loopInput);

        /**
         * <p>
         * Contains input node configurations for a DoWhile loop in your flow.
         * </p>
         * This is a convenience method that creates an instance of the {@link LoopInputFlowNodeConfiguration.Builder}
         * avoiding the need to create one manually via {@link LoopInputFlowNodeConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LoopInputFlowNodeConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #loopInput(LoopInputFlowNodeConfiguration)}.
         * 
         * @param loopInput
         *        a consumer that will call methods on {@link LoopInputFlowNodeConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #loopInput(LoopInputFlowNodeConfiguration)
         */
        default Builder loopInput(Consumer<LoopInputFlowNodeConfiguration.Builder> loopInput) {
            return loopInput(LoopInputFlowNodeConfiguration.builder().applyMutation(loopInput).build());
        }

        /**
         * <p>
         * Contains configurations for an output flow node in your flow. The last node in the flow. <code>outputs</code>
         * can't be specified for this node.
         * </p>
         * 
         * @param output
         *        Contains configurations for an output flow node in your flow. The last node in the flow.
         *        <code>outputs</code> can't be specified for this node.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder output(OutputFlowNodeConfiguration output);

        /**
         * <p>
         * Contains configurations for an output flow node in your flow. The last node in the flow. <code>outputs</code>
         * can't be specified for this node.
         * </p>
         * This is a convenience method that creates an instance of the {@link OutputFlowNodeConfiguration.Builder}
         * avoiding the need to create one manually via {@link OutputFlowNodeConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link OutputFlowNodeConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #output(OutputFlowNodeConfiguration)}.
         * 
         * @param output
         *        a consumer that will call methods on {@link OutputFlowNodeConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #output(OutputFlowNodeConfiguration)
         */
        default Builder output(Consumer<OutputFlowNodeConfiguration.Builder> output) {
            return output(OutputFlowNodeConfiguration.builder().applyMutation(output).build());
        }

        /**
         * <p>
         * Contains configurations for a prompt node in your flow. Runs a prompt and generates the model response as the
         * output. You can use a prompt from Prompt management or you can configure one in this node.
         * </p>
         * 
         * @param prompt
         *        Contains configurations for a prompt node in your flow. Runs a prompt and generates the model response
         *        as the output. You can use a prompt from Prompt management or you can configure one in this node.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder prompt(PromptFlowNodeConfiguration prompt);

        /**
         * <p>
         * Contains configurations for a prompt node in your flow. Runs a prompt and generates the model response as the
         * output. You can use a prompt from Prompt management or you can configure one in this node.
         * </p>
         * This is a convenience method that creates an instance of the {@link PromptFlowNodeConfiguration.Builder}
         * avoiding the need to create one manually via {@link PromptFlowNodeConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PromptFlowNodeConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #prompt(PromptFlowNodeConfiguration)}.
         * 
         * @param prompt
         *        a consumer that will call methods on {@link PromptFlowNodeConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #prompt(PromptFlowNodeConfiguration)
         */
        default Builder prompt(Consumer<PromptFlowNodeConfiguration.Builder> prompt) {
            return prompt(PromptFlowNodeConfiguration.builder().applyMutation(prompt).build());
        }

        /**
         * <p>
         * Contains configurations for a retrieval node in your flow. Retrieves data from an Amazon S3 location and
         * returns it as the output.
         * </p>
         * 
         * @param retrieval
         *        Contains configurations for a retrieval node in your flow. Retrieves data from an Amazon S3 location
         *        and returns it as the output.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder retrieval(RetrievalFlowNodeConfiguration retrieval);

        /**
         * <p>
         * Contains configurations for a retrieval node in your flow. Retrieves data from an Amazon S3 location and
         * returns it as the output.
         * </p>
         * This is a convenience method that creates an instance of the {@link RetrievalFlowNodeConfiguration.Builder}
         * avoiding the need to create one manually via {@link RetrievalFlowNodeConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RetrievalFlowNodeConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #retrieval(RetrievalFlowNodeConfiguration)}.
         * 
         * @param retrieval
         *        a consumer that will call methods on {@link RetrievalFlowNodeConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #retrieval(RetrievalFlowNodeConfiguration)
         */
        default Builder retrieval(Consumer<RetrievalFlowNodeConfiguration.Builder> retrieval) {
            return retrieval(RetrievalFlowNodeConfiguration.builder().applyMutation(retrieval).build());
        }

        /**
         * <p>
         * Contains configurations for a storage node in your flow. Stores an input in an Amazon S3 location.
         * </p>
         * 
         * @param storage
         *        Contains configurations for a storage node in your flow. Stores an input in an Amazon S3 location.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder storage(StorageFlowNodeConfiguration storage);

        /**
         * <p>
         * Contains configurations for a storage node in your flow. Stores an input in an Amazon S3 location.
         * </p>
         * This is a convenience method that creates an instance of the {@link StorageFlowNodeConfiguration.Builder}
         * avoiding the need to create one manually via {@link StorageFlowNodeConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link StorageFlowNodeConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #storage(StorageFlowNodeConfiguration)}.
         * 
         * @param storage
         *        a consumer that will call methods on {@link StorageFlowNodeConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #storage(StorageFlowNodeConfiguration)
         */
        default Builder storage(Consumer<StorageFlowNodeConfiguration.Builder> storage) {
            return storage(StorageFlowNodeConfiguration.builder().applyMutation(storage).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private AgentFlowNodeConfiguration agent;

        private CollectorFlowNodeConfiguration collector;

        private ConditionFlowNodeConfiguration condition;

        private InlineCodeFlowNodeConfiguration inlineCode;

        private InputFlowNodeConfiguration input;

        private IteratorFlowNodeConfiguration iterator;

        private KnowledgeBaseFlowNodeConfiguration knowledgeBase;

        private LambdaFunctionFlowNodeConfiguration lambdaFunction;

        private LexFlowNodeConfiguration lex;

        private LoopFlowNodeConfiguration loop;

        private LoopControllerFlowNodeConfiguration loopController;

        private LoopInputFlowNodeConfiguration loopInput;

        private OutputFlowNodeConfiguration output;

        private PromptFlowNodeConfiguration prompt;

        private RetrievalFlowNodeConfiguration retrieval;

        private StorageFlowNodeConfiguration storage;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(FlowNodeConfiguration model) {
            agent(model.agent);
            collector(model.collector);
            condition(model.condition);
            inlineCode(model.inlineCode);
            input(model.input);
            iterator(model.iterator);
            knowledgeBase(model.knowledgeBase);
            lambdaFunction(model.lambdaFunction);
            lex(model.lex);
            loop(model.loop);
            loopController(model.loopController);
            loopInput(model.loopInput);
            output(model.output);
            prompt(model.prompt);
            retrieval(model.retrieval);
            storage(model.storage);
        }

        public final AgentFlowNodeConfiguration.Builder getAgent() {
            return agent != null ? agent.toBuilder() : null;
        }

        public final void setAgent(AgentFlowNodeConfiguration.BuilderImpl agent) {
            Object oldValue = this.agent;
            this.agent = agent != null ? agent.build() : null;
            handleUnionValueChange(Type.AGENT, oldValue, this.agent);
        }

        @Override
        public final Builder agent(AgentFlowNodeConfiguration agent) {
            Object oldValue = this.agent;
            this.agent = agent;
            handleUnionValueChange(Type.AGENT, oldValue, this.agent);
            return this;
        }

        public final CollectorFlowNodeConfiguration.Builder getCollector() {
            return collector != null ? collector.toBuilder() : null;
        }

        public final void setCollector(CollectorFlowNodeConfiguration.BuilderImpl collector) {
            Object oldValue = this.collector;
            this.collector = collector != null ? collector.build() : null;
            handleUnionValueChange(Type.COLLECTOR, oldValue, this.collector);
        }

        @Override
        public final Builder collector(CollectorFlowNodeConfiguration collector) {
            Object oldValue = this.collector;
            this.collector = collector;
            handleUnionValueChange(Type.COLLECTOR, oldValue, this.collector);
            return this;
        }

        public final ConditionFlowNodeConfiguration.Builder getCondition() {
            return condition != null ? condition.toBuilder() : null;
        }

        public final void setCondition(ConditionFlowNodeConfiguration.BuilderImpl condition) {
            Object oldValue = this.condition;
            this.condition = condition != null ? condition.build() : null;
            handleUnionValueChange(Type.CONDITION, oldValue, this.condition);
        }

        @Override
        public final Builder condition(ConditionFlowNodeConfiguration condition) {
            Object oldValue = this.condition;
            this.condition = condition;
            handleUnionValueChange(Type.CONDITION, oldValue, this.condition);
            return this;
        }

        public final InlineCodeFlowNodeConfiguration.Builder getInlineCode() {
            return inlineCode != null ? inlineCode.toBuilder() : null;
        }

        public final void setInlineCode(InlineCodeFlowNodeConfiguration.BuilderImpl inlineCode) {
            Object oldValue = this.inlineCode;
            this.inlineCode = inlineCode != null ? inlineCode.build() : null;
            handleUnionValueChange(Type.INLINE_CODE, oldValue, this.inlineCode);
        }

        @Override
        public final Builder inlineCode(InlineCodeFlowNodeConfiguration inlineCode) {
            Object oldValue = this.inlineCode;
            this.inlineCode = inlineCode;
            handleUnionValueChange(Type.INLINE_CODE, oldValue, this.inlineCode);
            return this;
        }

        public final InputFlowNodeConfiguration.Builder getInput() {
            return input != null ? input.toBuilder() : null;
        }

        public final void setInput(InputFlowNodeConfiguration.BuilderImpl input) {
            Object oldValue = this.input;
            this.input = input != null ? input.build() : null;
            handleUnionValueChange(Type.INPUT, oldValue, this.input);
        }

        @Override
        public final Builder input(InputFlowNodeConfiguration input) {
            Object oldValue = this.input;
            this.input = input;
            handleUnionValueChange(Type.INPUT, oldValue, this.input);
            return this;
        }

        public final IteratorFlowNodeConfiguration.Builder getIterator() {
            return iterator != null ? iterator.toBuilder() : null;
        }

        public final void setIterator(IteratorFlowNodeConfiguration.BuilderImpl iterator) {
            Object oldValue = this.iterator;
            this.iterator = iterator != null ? iterator.build() : null;
            handleUnionValueChange(Type.ITERATOR, oldValue, this.iterator);
        }

        @Override
        public final Builder iterator(IteratorFlowNodeConfiguration iterator) {
            Object oldValue = this.iterator;
            this.iterator = iterator;
            handleUnionValueChange(Type.ITERATOR, oldValue, this.iterator);
            return this;
        }

        public final KnowledgeBaseFlowNodeConfiguration.Builder getKnowledgeBase() {
            return knowledgeBase != null ? knowledgeBase.toBuilder() : null;
        }

        public final void setKnowledgeBase(KnowledgeBaseFlowNodeConfiguration.BuilderImpl knowledgeBase) {
            Object oldValue = this.knowledgeBase;
            this.knowledgeBase = knowledgeBase != null ? knowledgeBase.build() : null;
            handleUnionValueChange(Type.KNOWLEDGE_BASE, oldValue, this.knowledgeBase);
        }

        @Override
        public final Builder knowledgeBase(KnowledgeBaseFlowNodeConfiguration knowledgeBase) {
            Object oldValue = this.knowledgeBase;
            this.knowledgeBase = knowledgeBase;
            handleUnionValueChange(Type.KNOWLEDGE_BASE, oldValue, this.knowledgeBase);
            return this;
        }

        public final LambdaFunctionFlowNodeConfiguration.Builder getLambdaFunction() {
            return lambdaFunction != null ? lambdaFunction.toBuilder() : null;
        }

        public final void setLambdaFunction(LambdaFunctionFlowNodeConfiguration.BuilderImpl lambdaFunction) {
            Object oldValue = this.lambdaFunction;
            this.lambdaFunction = lambdaFunction != null ? lambdaFunction.build() : null;
            handleUnionValueChange(Type.LAMBDA_FUNCTION, oldValue, this.lambdaFunction);
        }

        @Override
        public final Builder lambdaFunction(LambdaFunctionFlowNodeConfiguration lambdaFunction) {
            Object oldValue = this.lambdaFunction;
            this.lambdaFunction = lambdaFunction;
            handleUnionValueChange(Type.LAMBDA_FUNCTION, oldValue, this.lambdaFunction);
            return this;
        }

        public final LexFlowNodeConfiguration.Builder getLex() {
            return lex != null ? lex.toBuilder() : null;
        }

        public final void setLex(LexFlowNodeConfiguration.BuilderImpl lex) {
            Object oldValue = this.lex;
            this.lex = lex != null ? lex.build() : null;
            handleUnionValueChange(Type.LEX, oldValue, this.lex);
        }

        @Override
        public final Builder lex(LexFlowNodeConfiguration lex) {
            Object oldValue = this.lex;
            this.lex = lex;
            handleUnionValueChange(Type.LEX, oldValue, this.lex);
            return this;
        }

        public final LoopFlowNodeConfiguration.Builder getLoop() {
            return loop != null ? loop.toBuilder() : null;
        }

        public final void setLoop(LoopFlowNodeConfiguration.BuilderImpl loop) {
            Object oldValue = this.loop;
            this.loop = loop != null ? loop.build() : null;
            handleUnionValueChange(Type.LOOP, oldValue, this.loop);
        }

        @Override
        public final Builder loop(LoopFlowNodeConfiguration loop) {
            Object oldValue = this.loop;
            this.loop = loop;
            handleUnionValueChange(Type.LOOP, oldValue, this.loop);
            return this;
        }

        public final LoopControllerFlowNodeConfiguration.Builder getLoopController() {
            return loopController != null ? loopController.toBuilder() : null;
        }

        public final void setLoopController(LoopControllerFlowNodeConfiguration.BuilderImpl loopController) {
            Object oldValue = this.loopController;
            this.loopController = loopController != null ? loopController.build() : null;
            handleUnionValueChange(Type.LOOP_CONTROLLER, oldValue, this.loopController);
        }

        @Override
        public final Builder loopController(LoopControllerFlowNodeConfiguration loopController) {
            Object oldValue = this.loopController;
            this.loopController = loopController;
            handleUnionValueChange(Type.LOOP_CONTROLLER, oldValue, this.loopController);
            return this;
        }

        public final LoopInputFlowNodeConfiguration.Builder getLoopInput() {
            return loopInput != null ? loopInput.toBuilder() : null;
        }

        public final void setLoopInput(LoopInputFlowNodeConfiguration.BuilderImpl loopInput) {
            Object oldValue = this.loopInput;
            this.loopInput = loopInput != null ? loopInput.build() : null;
            handleUnionValueChange(Type.LOOP_INPUT, oldValue, this.loopInput);
        }

        @Override
        public final Builder loopInput(LoopInputFlowNodeConfiguration loopInput) {
            Object oldValue = this.loopInput;
            this.loopInput = loopInput;
            handleUnionValueChange(Type.LOOP_INPUT, oldValue, this.loopInput);
            return this;
        }

        public final OutputFlowNodeConfiguration.Builder getOutput() {
            return output != null ? output.toBuilder() : null;
        }

        public final void setOutput(OutputFlowNodeConfiguration.BuilderImpl output) {
            Object oldValue = this.output;
            this.output = output != null ? output.build() : null;
            handleUnionValueChange(Type.OUTPUT, oldValue, this.output);
        }

        @Override
        public final Builder output(OutputFlowNodeConfiguration output) {
            Object oldValue = this.output;
            this.output = output;
            handleUnionValueChange(Type.OUTPUT, oldValue, this.output);
            return this;
        }

        public final PromptFlowNodeConfiguration.Builder getPrompt() {
            return prompt != null ? prompt.toBuilder() : null;
        }

        public final void setPrompt(PromptFlowNodeConfiguration.BuilderImpl prompt) {
            Object oldValue = this.prompt;
            this.prompt = prompt != null ? prompt.build() : null;
            handleUnionValueChange(Type.PROMPT, oldValue, this.prompt);
        }

        @Override
        public final Builder prompt(PromptFlowNodeConfiguration prompt) {
            Object oldValue = this.prompt;
            this.prompt = prompt;
            handleUnionValueChange(Type.PROMPT, oldValue, this.prompt);
            return this;
        }

        public final RetrievalFlowNodeConfiguration.Builder getRetrieval() {
            return retrieval != null ? retrieval.toBuilder() : null;
        }

        public final void setRetrieval(RetrievalFlowNodeConfiguration.BuilderImpl retrieval) {
            Object oldValue = this.retrieval;
            this.retrieval = retrieval != null ? retrieval.build() : null;
            handleUnionValueChange(Type.RETRIEVAL, oldValue, this.retrieval);
        }

        @Override
        public final Builder retrieval(RetrievalFlowNodeConfiguration retrieval) {
            Object oldValue = this.retrieval;
            this.retrieval = retrieval;
            handleUnionValueChange(Type.RETRIEVAL, oldValue, this.retrieval);
            return this;
        }

        public final StorageFlowNodeConfiguration.Builder getStorage() {
            return storage != null ? storage.toBuilder() : null;
        }

        public final void setStorage(StorageFlowNodeConfiguration.BuilderImpl storage) {
            Object oldValue = this.storage;
            this.storage = storage != null ? storage.build() : null;
            handleUnionValueChange(Type.STORAGE, oldValue, this.storage);
        }

        @Override
        public final Builder storage(StorageFlowNodeConfiguration storage) {
            Object oldValue = this.storage;
            this.storage = storage;
            handleUnionValueChange(Type.STORAGE, oldValue, this.storage);
            return this;
        }

        @Override
        public FlowNodeConfiguration build() {
            return new FlowNodeConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see FlowNodeConfiguration#type()
     */
    public enum Type {
        AGENT,

        COLLECTOR,

        CONDITION,

        INLINE_CODE,

        INPUT,

        ITERATOR,

        KNOWLEDGE_BASE,

        LAMBDA_FUNCTION,

        LEX,

        LOOP,

        LOOP_CONTROLLER,

        LOOP_INPUT,

        OUTPUT,

        PROMPT,

        RETRIEVAL,

        STORAGE,

        UNKNOWN_TO_SDK_VERSION
    }
}
