/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagent.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details of custom orchestration.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CustomOrchestration implements SdkPojo, Serializable,
        ToCopyableBuilder<CustomOrchestration.Builder, CustomOrchestration> {
    private static final SdkField<OrchestrationExecutor> EXECUTOR_FIELD = SdkField
            .<OrchestrationExecutor> builder(MarshallingType.SDK_POJO).memberName("executor")
            .getter(getter(CustomOrchestration::executor)).setter(setter(Builder::executor))
            .constructor(OrchestrationExecutor::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("executor").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXECUTOR_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final OrchestrationExecutor executor;

    private CustomOrchestration(BuilderImpl builder) {
        this.executor = builder.executor;
    }

    /**
     * <p>
     * The structure of the executor invoking the actions in custom orchestration.
     * </p>
     * 
     * @return The structure of the executor invoking the actions in custom orchestration.
     */
    public final OrchestrationExecutor executor() {
        return executor;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(executor());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CustomOrchestration)) {
            return false;
        }
        CustomOrchestration other = (CustomOrchestration) obj;
        return Objects.equals(executor(), other.executor());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CustomOrchestration").add("Executor", executor()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "executor":
            return Optional.ofNullable(clazz.cast(executor()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("executor", EXECUTOR_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CustomOrchestration, T> g) {
        return obj -> g.apply((CustomOrchestration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CustomOrchestration> {
        /**
         * <p>
         * The structure of the executor invoking the actions in custom orchestration.
         * </p>
         * 
         * @param executor
         *        The structure of the executor invoking the actions in custom orchestration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executor(OrchestrationExecutor executor);

        /**
         * <p>
         * The structure of the executor invoking the actions in custom orchestration.
         * </p>
         * This is a convenience method that creates an instance of the {@link OrchestrationExecutor.Builder} avoiding
         * the need to create one manually via {@link OrchestrationExecutor#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link OrchestrationExecutor.Builder#build()} is called immediately and
         * its result is passed to {@link #executor(OrchestrationExecutor)}.
         * 
         * @param executor
         *        a consumer that will call methods on {@link OrchestrationExecutor.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #executor(OrchestrationExecutor)
         */
        default Builder executor(Consumer<OrchestrationExecutor.Builder> executor) {
            return executor(OrchestrationExecutor.builder().applyMutation(executor).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private OrchestrationExecutor executor;

        private BuilderImpl() {
        }

        private BuilderImpl(CustomOrchestration model) {
            executor(model.executor);
        }

        public final OrchestrationExecutor.Builder getExecutor() {
            return executor != null ? executor.toBuilder() : null;
        }

        public final void setExecutor(OrchestrationExecutor.BuilderImpl executor) {
            this.executor = executor != null ? executor.build() : null;
        }

        @Override
        public final Builder executor(OrchestrationExecutor executor) {
            this.executor = executor;
            return this;
        }

        @Override
        public CustomOrchestration build() {
            return new CustomOrchestration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
