/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagent.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about the content to ingest into a knowledge base connected to a custom data source. Choose a
 * <code>sourceType</code> and include the field that corresponds to it.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CustomContent implements SdkPojo, Serializable, ToCopyableBuilder<CustomContent.Builder, CustomContent> {
    private static final SdkField<CustomDocumentIdentifier> CUSTOM_DOCUMENT_IDENTIFIER_FIELD = SdkField
            .<CustomDocumentIdentifier> builder(MarshallingType.SDK_POJO).memberName("customDocumentIdentifier")
            .getter(getter(CustomContent::customDocumentIdentifier)).setter(setter(Builder::customDocumentIdentifier))
            .constructor(CustomDocumentIdentifier::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customDocumentIdentifier").build())
            .build();

    private static final SdkField<InlineContent> INLINE_CONTENT_FIELD = SdkField
            .<InlineContent> builder(MarshallingType.SDK_POJO).memberName("inlineContent")
            .getter(getter(CustomContent::inlineContent)).setter(setter(Builder::inlineContent))
            .constructor(InlineContent::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inlineContent").build()).build();

    private static final SdkField<CustomS3Location> S3_LOCATION_FIELD = SdkField
            .<CustomS3Location> builder(MarshallingType.SDK_POJO).memberName("s3Location")
            .getter(getter(CustomContent::s3Location)).setter(setter(Builder::s3Location)).constructor(CustomS3Location::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3Location").build()).build();

    private static final SdkField<String> SOURCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sourceType").getter(getter(CustomContent::sourceTypeAsString)).setter(setter(Builder::sourceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            CUSTOM_DOCUMENT_IDENTIFIER_FIELD, INLINE_CONTENT_FIELD, S3_LOCATION_FIELD, SOURCE_TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final CustomDocumentIdentifier customDocumentIdentifier;

    private final InlineContent inlineContent;

    private final CustomS3Location s3Location;

    private final String sourceType;

    private CustomContent(BuilderImpl builder) {
        this.customDocumentIdentifier = builder.customDocumentIdentifier;
        this.inlineContent = builder.inlineContent;
        this.s3Location = builder.s3Location;
        this.sourceType = builder.sourceType;
    }

    /**
     * <p>
     * A unique identifier for the document.
     * </p>
     * 
     * @return A unique identifier for the document.
     */
    public final CustomDocumentIdentifier customDocumentIdentifier() {
        return customDocumentIdentifier;
    }

    /**
     * <p>
     * Contains information about content defined inline to ingest into a knowledge base.
     * </p>
     * 
     * @return Contains information about content defined inline to ingest into a knowledge base.
     */
    public final InlineContent inlineContent() {
        return inlineContent;
    }

    /**
     * <p>
     * Contains information about the Amazon S3 location of the file from which to ingest data.
     * </p>
     * 
     * @return Contains information about the Amazon S3 location of the file from which to ingest data.
     */
    public final CustomS3Location s3Location() {
        return s3Location;
    }

    /**
     * <p>
     * The source of the data to ingest.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sourceType} will
     * return {@link CustomSourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sourceTypeAsString}.
     * </p>
     * 
     * @return The source of the data to ingest.
     * @see CustomSourceType
     */
    public final CustomSourceType sourceType() {
        return CustomSourceType.fromValue(sourceType);
    }

    /**
     * <p>
     * The source of the data to ingest.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sourceType} will
     * return {@link CustomSourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sourceTypeAsString}.
     * </p>
     * 
     * @return The source of the data to ingest.
     * @see CustomSourceType
     */
    public final String sourceTypeAsString() {
        return sourceType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(customDocumentIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(inlineContent());
        hashCode = 31 * hashCode + Objects.hashCode(s3Location());
        hashCode = 31 * hashCode + Objects.hashCode(sourceTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CustomContent)) {
            return false;
        }
        CustomContent other = (CustomContent) obj;
        return Objects.equals(customDocumentIdentifier(), other.customDocumentIdentifier())
                && Objects.equals(inlineContent(), other.inlineContent()) && Objects.equals(s3Location(), other.s3Location())
                && Objects.equals(sourceTypeAsString(), other.sourceTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CustomContent").add("CustomDocumentIdentifier", customDocumentIdentifier())
                .add("InlineContent", inlineContent()).add("S3Location", s3Location()).add("SourceType", sourceTypeAsString())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "customDocumentIdentifier":
            return Optional.ofNullable(clazz.cast(customDocumentIdentifier()));
        case "inlineContent":
            return Optional.ofNullable(clazz.cast(inlineContent()));
        case "s3Location":
            return Optional.ofNullable(clazz.cast(s3Location()));
        case "sourceType":
            return Optional.ofNullable(clazz.cast(sourceTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("customDocumentIdentifier", CUSTOM_DOCUMENT_IDENTIFIER_FIELD);
        map.put("inlineContent", INLINE_CONTENT_FIELD);
        map.put("s3Location", S3_LOCATION_FIELD);
        map.put("sourceType", SOURCE_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CustomContent, T> g) {
        return obj -> g.apply((CustomContent) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CustomContent> {
        /**
         * <p>
         * A unique identifier for the document.
         * </p>
         * 
         * @param customDocumentIdentifier
         *        A unique identifier for the document.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customDocumentIdentifier(CustomDocumentIdentifier customDocumentIdentifier);

        /**
         * <p>
         * A unique identifier for the document.
         * </p>
         * This is a convenience method that creates an instance of the {@link CustomDocumentIdentifier.Builder}
         * avoiding the need to create one manually via {@link CustomDocumentIdentifier#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CustomDocumentIdentifier.Builder#build()} is called immediately
         * and its result is passed to {@link #customDocumentIdentifier(CustomDocumentIdentifier)}.
         * 
         * @param customDocumentIdentifier
         *        a consumer that will call methods on {@link CustomDocumentIdentifier.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #customDocumentIdentifier(CustomDocumentIdentifier)
         */
        default Builder customDocumentIdentifier(Consumer<CustomDocumentIdentifier.Builder> customDocumentIdentifier) {
            return customDocumentIdentifier(CustomDocumentIdentifier.builder().applyMutation(customDocumentIdentifier).build());
        }

        /**
         * <p>
         * Contains information about content defined inline to ingest into a knowledge base.
         * </p>
         * 
         * @param inlineContent
         *        Contains information about content defined inline to ingest into a knowledge base.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inlineContent(InlineContent inlineContent);

        /**
         * <p>
         * Contains information about content defined inline to ingest into a knowledge base.
         * </p>
         * This is a convenience method that creates an instance of the {@link InlineContent.Builder} avoiding the need
         * to create one manually via {@link InlineContent#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link InlineContent.Builder#build()} is called immediately and its
         * result is passed to {@link #inlineContent(InlineContent)}.
         * 
         * @param inlineContent
         *        a consumer that will call methods on {@link InlineContent.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #inlineContent(InlineContent)
         */
        default Builder inlineContent(Consumer<InlineContent.Builder> inlineContent) {
            return inlineContent(InlineContent.builder().applyMutation(inlineContent).build());
        }

        /**
         * <p>
         * Contains information about the Amazon S3 location of the file from which to ingest data.
         * </p>
         * 
         * @param s3Location
         *        Contains information about the Amazon S3 location of the file from which to ingest data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3Location(CustomS3Location s3Location);

        /**
         * <p>
         * Contains information about the Amazon S3 location of the file from which to ingest data.
         * </p>
         * This is a convenience method that creates an instance of the {@link CustomS3Location.Builder} avoiding the
         * need to create one manually via {@link CustomS3Location#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CustomS3Location.Builder#build()} is called immediately and its
         * result is passed to {@link #s3Location(CustomS3Location)}.
         * 
         * @param s3Location
         *        a consumer that will call methods on {@link CustomS3Location.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #s3Location(CustomS3Location)
         */
        default Builder s3Location(Consumer<CustomS3Location.Builder> s3Location) {
            return s3Location(CustomS3Location.builder().applyMutation(s3Location).build());
        }

        /**
         * <p>
         * The source of the data to ingest.
         * </p>
         * 
         * @param sourceType
         *        The source of the data to ingest.
         * @see CustomSourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CustomSourceType
         */
        Builder sourceType(String sourceType);

        /**
         * <p>
         * The source of the data to ingest.
         * </p>
         * 
         * @param sourceType
         *        The source of the data to ingest.
         * @see CustomSourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CustomSourceType
         */
        Builder sourceType(CustomSourceType sourceType);
    }

    static final class BuilderImpl implements Builder {
        private CustomDocumentIdentifier customDocumentIdentifier;

        private InlineContent inlineContent;

        private CustomS3Location s3Location;

        private String sourceType;

        private BuilderImpl() {
        }

        private BuilderImpl(CustomContent model) {
            customDocumentIdentifier(model.customDocumentIdentifier);
            inlineContent(model.inlineContent);
            s3Location(model.s3Location);
            sourceType(model.sourceType);
        }

        public final CustomDocumentIdentifier.Builder getCustomDocumentIdentifier() {
            return customDocumentIdentifier != null ? customDocumentIdentifier.toBuilder() : null;
        }

        public final void setCustomDocumentIdentifier(CustomDocumentIdentifier.BuilderImpl customDocumentIdentifier) {
            this.customDocumentIdentifier = customDocumentIdentifier != null ? customDocumentIdentifier.build() : null;
        }

        @Override
        public final Builder customDocumentIdentifier(CustomDocumentIdentifier customDocumentIdentifier) {
            this.customDocumentIdentifier = customDocumentIdentifier;
            return this;
        }

        public final InlineContent.Builder getInlineContent() {
            return inlineContent != null ? inlineContent.toBuilder() : null;
        }

        public final void setInlineContent(InlineContent.BuilderImpl inlineContent) {
            this.inlineContent = inlineContent != null ? inlineContent.build() : null;
        }

        @Override
        public final Builder inlineContent(InlineContent inlineContent) {
            this.inlineContent = inlineContent;
            return this;
        }

        public final CustomS3Location.Builder getS3Location() {
            return s3Location != null ? s3Location.toBuilder() : null;
        }

        public final void setS3Location(CustomS3Location.BuilderImpl s3Location) {
            this.s3Location = s3Location != null ? s3Location.build() : null;
        }

        @Override
        public final Builder s3Location(CustomS3Location s3Location) {
            this.s3Location = s3Location;
            return this;
        }

        public final String getSourceType() {
            return sourceType;
        }

        public final void setSourceType(String sourceType) {
            this.sourceType = sourceType;
        }

        @Override
        public final Builder sourceType(String sourceType) {
            this.sourceType = sourceType;
            return this;
        }

        @Override
        public final Builder sourceType(CustomSourceType sourceType) {
            this.sourceType(sourceType == null ? null : sourceType.toString());
            return this;
        }

        @Override
        public CustomContent build() {
            return new CustomContent(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
