/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagent.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Context enrichment configuration is used to provide additional context to the RAG application.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ContextEnrichmentConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<ContextEnrichmentConfiguration.Builder, ContextEnrichmentConfiguration> {
    private static final SdkField<BedrockFoundationModelContextEnrichmentConfiguration> BEDROCK_FOUNDATION_MODEL_CONFIGURATION_FIELD = SdkField
            .<BedrockFoundationModelContextEnrichmentConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("bedrockFoundationModelConfiguration")
            .getter(getter(ContextEnrichmentConfiguration::bedrockFoundationModelConfiguration))
            .setter(setter(Builder::bedrockFoundationModelConfiguration))
            .constructor(BedrockFoundationModelContextEnrichmentConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("bedrockFoundationModelConfiguration").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(ContextEnrichmentConfiguration::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            BEDROCK_FOUNDATION_MODEL_CONFIGURATION_FIELD, TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final BedrockFoundationModelContextEnrichmentConfiguration bedrockFoundationModelConfiguration;

    private final String type;

    private ContextEnrichmentConfiguration(BuilderImpl builder) {
        this.bedrockFoundationModelConfiguration = builder.bedrockFoundationModelConfiguration;
        this.type = builder.type;
    }

    /**
     * <p>
     * The configuration of the Amazon Bedrock foundation model used for context enrichment.
     * </p>
     * 
     * @return The configuration of the Amazon Bedrock foundation model used for context enrichment.
     */
    public final BedrockFoundationModelContextEnrichmentConfiguration bedrockFoundationModelConfiguration() {
        return bedrockFoundationModelConfiguration;
    }

    /**
     * <p>
     * The method used for context enrichment. It must be Amazon Bedrock foundation models.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link ContextEnrichmentType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The method used for context enrichment. It must be Amazon Bedrock foundation models.
     * @see ContextEnrichmentType
     */
    public final ContextEnrichmentType type() {
        return ContextEnrichmentType.fromValue(type);
    }

    /**
     * <p>
     * The method used for context enrichment. It must be Amazon Bedrock foundation models.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link ContextEnrichmentType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The method used for context enrichment. It must be Amazon Bedrock foundation models.
     * @see ContextEnrichmentType
     */
    public final String typeAsString() {
        return type;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(bedrockFoundationModelConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ContextEnrichmentConfiguration)) {
            return false;
        }
        ContextEnrichmentConfiguration other = (ContextEnrichmentConfiguration) obj;
        return Objects.equals(bedrockFoundationModelConfiguration(), other.bedrockFoundationModelConfiguration())
                && Objects.equals(typeAsString(), other.typeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ContextEnrichmentConfiguration")
                .add("BedrockFoundationModelConfiguration", bedrockFoundationModelConfiguration()).add("Type", typeAsString())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "bedrockFoundationModelConfiguration":
            return Optional.ofNullable(clazz.cast(bedrockFoundationModelConfiguration()));
        case "type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("bedrockFoundationModelConfiguration", BEDROCK_FOUNDATION_MODEL_CONFIGURATION_FIELD);
        map.put("type", TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ContextEnrichmentConfiguration, T> g) {
        return obj -> g.apply((ContextEnrichmentConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ContextEnrichmentConfiguration> {
        /**
         * <p>
         * The configuration of the Amazon Bedrock foundation model used for context enrichment.
         * </p>
         * 
         * @param bedrockFoundationModelConfiguration
         *        The configuration of the Amazon Bedrock foundation model used for context enrichment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bedrockFoundationModelConfiguration(
                BedrockFoundationModelContextEnrichmentConfiguration bedrockFoundationModelConfiguration);

        /**
         * <p>
         * The configuration of the Amazon Bedrock foundation model used for context enrichment.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link BedrockFoundationModelContextEnrichmentConfiguration.Builder} avoiding the need to create one manually
         * via {@link BedrockFoundationModelContextEnrichmentConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link BedrockFoundationModelContextEnrichmentConfiguration.Builder#build()} is called immediately and its
         * result is passed to
         * {@link #bedrockFoundationModelConfiguration(BedrockFoundationModelContextEnrichmentConfiguration)}.
         * 
         * @param bedrockFoundationModelConfiguration
         *        a consumer that will call methods on
         *        {@link BedrockFoundationModelContextEnrichmentConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #bedrockFoundationModelConfiguration(BedrockFoundationModelContextEnrichmentConfiguration)
         */
        default Builder bedrockFoundationModelConfiguration(
                Consumer<BedrockFoundationModelContextEnrichmentConfiguration.Builder> bedrockFoundationModelConfiguration) {
            return bedrockFoundationModelConfiguration(BedrockFoundationModelContextEnrichmentConfiguration.builder()
                    .applyMutation(bedrockFoundationModelConfiguration).build());
        }

        /**
         * <p>
         * The method used for context enrichment. It must be Amazon Bedrock foundation models.
         * </p>
         * 
         * @param type
         *        The method used for context enrichment. It must be Amazon Bedrock foundation models.
         * @see ContextEnrichmentType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ContextEnrichmentType
         */
        Builder type(String type);

        /**
         * <p>
         * The method used for context enrichment. It must be Amazon Bedrock foundation models.
         * </p>
         * 
         * @param type
         *        The method used for context enrichment. It must be Amazon Bedrock foundation models.
         * @see ContextEnrichmentType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ContextEnrichmentType
         */
        Builder type(ContextEnrichmentType type);
    }

    static final class BuilderImpl implements Builder {
        private BedrockFoundationModelContextEnrichmentConfiguration bedrockFoundationModelConfiguration;

        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(ContextEnrichmentConfiguration model) {
            bedrockFoundationModelConfiguration(model.bedrockFoundationModelConfiguration);
            type(model.type);
        }

        public final BedrockFoundationModelContextEnrichmentConfiguration.Builder getBedrockFoundationModelConfiguration() {
            return bedrockFoundationModelConfiguration != null ? bedrockFoundationModelConfiguration.toBuilder() : null;
        }

        public final void setBedrockFoundationModelConfiguration(
                BedrockFoundationModelContextEnrichmentConfiguration.BuilderImpl bedrockFoundationModelConfiguration) {
            this.bedrockFoundationModelConfiguration = bedrockFoundationModelConfiguration != null ? bedrockFoundationModelConfiguration
                    .build() : null;
        }

        @Override
        public final Builder bedrockFoundationModelConfiguration(
                BedrockFoundationModelContextEnrichmentConfiguration bedrockFoundationModelConfiguration) {
            this.bedrockFoundationModelConfiguration = bedrockFoundationModelConfiguration;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(ContextEnrichmentType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        @Override
        public ContextEnrichmentConfiguration build() {
            return new ContextEnrichmentConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
