/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagent.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Context enrichment configuration is used to provide additional context to the RAG application using Amazon Bedrock
 * foundation models.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BedrockFoundationModelContextEnrichmentConfiguration
        implements
        SdkPojo,
        Serializable,
        ToCopyableBuilder<BedrockFoundationModelContextEnrichmentConfiguration.Builder, BedrockFoundationModelContextEnrichmentConfiguration> {
    private static final SdkField<EnrichmentStrategyConfiguration> ENRICHMENT_STRATEGY_CONFIGURATION_FIELD = SdkField
            .<EnrichmentStrategyConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("enrichmentStrategyConfiguration")
            .getter(getter(BedrockFoundationModelContextEnrichmentConfiguration::enrichmentStrategyConfiguration))
            .setter(setter(Builder::enrichmentStrategyConfiguration))
            .constructor(EnrichmentStrategyConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enrichmentStrategyConfiguration")
                    .build()).build();

    private static final SdkField<String> MODEL_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("modelArn").getter(getter(BedrockFoundationModelContextEnrichmentConfiguration::modelArn))
            .setter(setter(Builder::modelArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modelArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            ENRICHMENT_STRATEGY_CONFIGURATION_FIELD, MODEL_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final EnrichmentStrategyConfiguration enrichmentStrategyConfiguration;

    private final String modelArn;

    private BedrockFoundationModelContextEnrichmentConfiguration(BuilderImpl builder) {
        this.enrichmentStrategyConfiguration = builder.enrichmentStrategyConfiguration;
        this.modelArn = builder.modelArn;
    }

    /**
     * <p>
     * The enrichment stategy used to provide additional context. For example, Neptune GraphRAG uses Amazon Bedrock
     * foundation models to perform chunk entity extraction.
     * </p>
     * 
     * @return The enrichment stategy used to provide additional context. For example, Neptune GraphRAG uses Amazon
     *         Bedrock foundation models to perform chunk entity extraction.
     */
    public final EnrichmentStrategyConfiguration enrichmentStrategyConfiguration() {
        return enrichmentStrategyConfiguration;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the model used to create vector embeddings for the knowledge base.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the model used to create vector embeddings for the knowledge base.
     */
    public final String modelArn() {
        return modelArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(enrichmentStrategyConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(modelArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BedrockFoundationModelContextEnrichmentConfiguration)) {
            return false;
        }
        BedrockFoundationModelContextEnrichmentConfiguration other = (BedrockFoundationModelContextEnrichmentConfiguration) obj;
        return Objects.equals(enrichmentStrategyConfiguration(), other.enrichmentStrategyConfiguration())
                && Objects.equals(modelArn(), other.modelArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BedrockFoundationModelContextEnrichmentConfiguration")
                .add("EnrichmentStrategyConfiguration", enrichmentStrategyConfiguration()).add("ModelArn", modelArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "enrichmentStrategyConfiguration":
            return Optional.ofNullable(clazz.cast(enrichmentStrategyConfiguration()));
        case "modelArn":
            return Optional.ofNullable(clazz.cast(modelArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("enrichmentStrategyConfiguration", ENRICHMENT_STRATEGY_CONFIGURATION_FIELD);
        map.put("modelArn", MODEL_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BedrockFoundationModelContextEnrichmentConfiguration, T> g) {
        return obj -> g.apply((BedrockFoundationModelContextEnrichmentConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BedrockFoundationModelContextEnrichmentConfiguration> {
        /**
         * <p>
         * The enrichment stategy used to provide additional context. For example, Neptune GraphRAG uses Amazon Bedrock
         * foundation models to perform chunk entity extraction.
         * </p>
         * 
         * @param enrichmentStrategyConfiguration
         *        The enrichment stategy used to provide additional context. For example, Neptune GraphRAG uses Amazon
         *        Bedrock foundation models to perform chunk entity extraction.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enrichmentStrategyConfiguration(EnrichmentStrategyConfiguration enrichmentStrategyConfiguration);

        /**
         * <p>
         * The enrichment stategy used to provide additional context. For example, Neptune GraphRAG uses Amazon Bedrock
         * foundation models to perform chunk entity extraction.
         * </p>
         * This is a convenience method that creates an instance of the {@link EnrichmentStrategyConfiguration.Builder}
         * avoiding the need to create one manually via {@link EnrichmentStrategyConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EnrichmentStrategyConfiguration.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #enrichmentStrategyConfiguration(EnrichmentStrategyConfiguration)}.
         * 
         * @param enrichmentStrategyConfiguration
         *        a consumer that will call methods on {@link EnrichmentStrategyConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #enrichmentStrategyConfiguration(EnrichmentStrategyConfiguration)
         */
        default Builder enrichmentStrategyConfiguration(
                Consumer<EnrichmentStrategyConfiguration.Builder> enrichmentStrategyConfiguration) {
            return enrichmentStrategyConfiguration(EnrichmentStrategyConfiguration.builder()
                    .applyMutation(enrichmentStrategyConfiguration).build());
        }

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the model used to create vector embeddings for the knowledge base.
         * </p>
         * 
         * @param modelArn
         *        The Amazon Resource Name (ARN) of the model used to create vector embeddings for the knowledge base.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelArn(String modelArn);
    }

    static final class BuilderImpl implements Builder {
        private EnrichmentStrategyConfiguration enrichmentStrategyConfiguration;

        private String modelArn;

        private BuilderImpl() {
        }

        private BuilderImpl(BedrockFoundationModelContextEnrichmentConfiguration model) {
            enrichmentStrategyConfiguration(model.enrichmentStrategyConfiguration);
            modelArn(model.modelArn);
        }

        public final EnrichmentStrategyConfiguration.Builder getEnrichmentStrategyConfiguration() {
            return enrichmentStrategyConfiguration != null ? enrichmentStrategyConfiguration.toBuilder() : null;
        }

        public final void setEnrichmentStrategyConfiguration(
                EnrichmentStrategyConfiguration.BuilderImpl enrichmentStrategyConfiguration) {
            this.enrichmentStrategyConfiguration = enrichmentStrategyConfiguration != null ? enrichmentStrategyConfiguration
                    .build() : null;
        }

        @Override
        public final Builder enrichmentStrategyConfiguration(EnrichmentStrategyConfiguration enrichmentStrategyConfiguration) {
            this.enrichmentStrategyConfiguration = enrichmentStrategyConfiguration;
            return this;
        }

        public final String getModelArn() {
            return modelArn;
        }

        public final void setModelArn(String modelArn) {
            this.modelArn = modelArn;
        }

        @Override
        public final Builder modelArn(String modelArn) {
            this.modelArn = modelArn;
            return this;
        }

        @Override
        public BedrockFoundationModelContextEnrichmentConfiguration build() {
            return new BedrockFoundationModelContextEnrichmentConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
