/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagent.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An agent collaborator.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AgentCollaborator implements SdkPojo, Serializable,
        ToCopyableBuilder<AgentCollaborator.Builder, AgentCollaborator> {
    private static final SdkField<AgentDescriptor> AGENT_DESCRIPTOR_FIELD = SdkField
            .<AgentDescriptor> builder(MarshallingType.SDK_POJO).memberName("agentDescriptor")
            .getter(getter(AgentCollaborator::agentDescriptor)).setter(setter(Builder::agentDescriptor))
            .constructor(AgentDescriptor::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("agentDescriptor").build()).build();

    private static final SdkField<String> AGENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("agentId").getter(getter(AgentCollaborator::agentId)).setter(setter(Builder::agentId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("agentId").build()).build();

    private static final SdkField<String> AGENT_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("agentVersion").getter(getter(AgentCollaborator::agentVersion)).setter(setter(Builder::agentVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("agentVersion").build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("clientToken").getter(getter(AgentCollaborator::clientToken)).setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build()).build();

    private static final SdkField<String> COLLABORATION_INSTRUCTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("collaborationInstruction").getter(getter(AgentCollaborator::collaborationInstruction))
            .setter(setter(Builder::collaborationInstruction))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("collaborationInstruction").build())
            .build();

    private static final SdkField<String> COLLABORATOR_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("collaboratorId").getter(getter(AgentCollaborator::collaboratorId))
            .setter(setter(Builder::collaboratorId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("collaboratorId").build()).build();

    private static final SdkField<String> COLLABORATOR_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("collaboratorName").getter(getter(AgentCollaborator::collaboratorName))
            .setter(setter(Builder::collaboratorName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("collaboratorName").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAt")
            .getter(getter(AgentCollaborator::createdAt))
            .setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Instant> LAST_UPDATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("lastUpdatedAt")
            .getter(getter(AgentCollaborator::lastUpdatedAt))
            .setter(setter(Builder::lastUpdatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> RELAY_CONVERSATION_HISTORY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("relayConversationHistory").getter(getter(AgentCollaborator::relayConversationHistoryAsString))
            .setter(setter(Builder::relayConversationHistory))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("relayConversationHistory").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AGENT_DESCRIPTOR_FIELD,
            AGENT_ID_FIELD, AGENT_VERSION_FIELD, CLIENT_TOKEN_FIELD, COLLABORATION_INSTRUCTION_FIELD, COLLABORATOR_ID_FIELD,
            COLLABORATOR_NAME_FIELD, CREATED_AT_FIELD, LAST_UPDATED_AT_FIELD, RELAY_CONVERSATION_HISTORY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final AgentDescriptor agentDescriptor;

    private final String agentId;

    private final String agentVersion;

    private final String clientToken;

    private final String collaborationInstruction;

    private final String collaboratorId;

    private final String collaboratorName;

    private final Instant createdAt;

    private final Instant lastUpdatedAt;

    private final String relayConversationHistory;

    private AgentCollaborator(BuilderImpl builder) {
        this.agentDescriptor = builder.agentDescriptor;
        this.agentId = builder.agentId;
        this.agentVersion = builder.agentVersion;
        this.clientToken = builder.clientToken;
        this.collaborationInstruction = builder.collaborationInstruction;
        this.collaboratorId = builder.collaboratorId;
        this.collaboratorName = builder.collaboratorName;
        this.createdAt = builder.createdAt;
        this.lastUpdatedAt = builder.lastUpdatedAt;
        this.relayConversationHistory = builder.relayConversationHistory;
    }

    /**
     * <p>
     * The collaborator's agent descriptor.
     * </p>
     * 
     * @return The collaborator's agent descriptor.
     */
    public final AgentDescriptor agentDescriptor() {
        return agentDescriptor;
    }

    /**
     * <p>
     * The collaborator's agent ID.
     * </p>
     * 
     * @return The collaborator's agent ID.
     */
    public final String agentId() {
        return agentId;
    }

    /**
     * <p>
     * The collaborator's agent version.
     * </p>
     * 
     * @return The collaborator's agent version.
     */
    public final String agentVersion() {
        return agentVersion;
    }

    /**
     * <p>
     * The collaborator's client token.
     * </p>
     * 
     * @return The collaborator's client token.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * The collaborator's instructions.
     * </p>
     * 
     * @return The collaborator's instructions.
     */
    public final String collaborationInstruction() {
        return collaborationInstruction;
    }

    /**
     * <p>
     * The collaborator's collaborator ID.
     * </p>
     * 
     * @return The collaborator's collaborator ID.
     */
    public final String collaboratorId() {
        return collaboratorId;
    }

    /**
     * <p>
     * The collaborator's collaborator name.
     * </p>
     * 
     * @return The collaborator's collaborator name.
     */
    public final String collaboratorName() {
        return collaboratorName;
    }

    /**
     * <p>
     * When the collaborator was created.
     * </p>
     * 
     * @return When the collaborator was created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * When the collaborator was updated.
     * </p>
     * 
     * @return When the collaborator was updated.
     */
    public final Instant lastUpdatedAt() {
        return lastUpdatedAt;
    }

    /**
     * <p>
     * The collaborator's relay conversation history.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #relayConversationHistory} will return {@link RelayConversationHistory#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #relayConversationHistoryAsString}.
     * </p>
     * 
     * @return The collaborator's relay conversation history.
     * @see RelayConversationHistory
     */
    public final RelayConversationHistory relayConversationHistory() {
        return RelayConversationHistory.fromValue(relayConversationHistory);
    }

    /**
     * <p>
     * The collaborator's relay conversation history.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #relayConversationHistory} will return {@link RelayConversationHistory#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #relayConversationHistoryAsString}.
     * </p>
     * 
     * @return The collaborator's relay conversation history.
     * @see RelayConversationHistory
     */
    public final String relayConversationHistoryAsString() {
        return relayConversationHistory;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(agentDescriptor());
        hashCode = 31 * hashCode + Objects.hashCode(agentId());
        hashCode = 31 * hashCode + Objects.hashCode(agentVersion());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(collaborationInstruction());
        hashCode = 31 * hashCode + Objects.hashCode(collaboratorId());
        hashCode = 31 * hashCode + Objects.hashCode(collaboratorName());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(relayConversationHistoryAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AgentCollaborator)) {
            return false;
        }
        AgentCollaborator other = (AgentCollaborator) obj;
        return Objects.equals(agentDescriptor(), other.agentDescriptor()) && Objects.equals(agentId(), other.agentId())
                && Objects.equals(agentVersion(), other.agentVersion()) && Objects.equals(clientToken(), other.clientToken())
                && Objects.equals(collaborationInstruction(), other.collaborationInstruction())
                && Objects.equals(collaboratorId(), other.collaboratorId())
                && Objects.equals(collaboratorName(), other.collaboratorName()) && Objects.equals(createdAt(), other.createdAt())
                && Objects.equals(lastUpdatedAt(), other.lastUpdatedAt())
                && Objects.equals(relayConversationHistoryAsString(), other.relayConversationHistoryAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AgentCollaborator").add("AgentDescriptor", agentDescriptor()).add("AgentId", agentId())
                .add("AgentVersion", agentVersion()).add("ClientToken", clientToken())
                .add("CollaborationInstruction", collaborationInstruction() == null ? null : "*** Sensitive Data Redacted ***")
                .add("CollaboratorId", collaboratorId()).add("CollaboratorName", collaboratorName())
                .add("CreatedAt", createdAt()).add("LastUpdatedAt", lastUpdatedAt())
                .add("RelayConversationHistory", relayConversationHistoryAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "agentDescriptor":
            return Optional.ofNullable(clazz.cast(agentDescriptor()));
        case "agentId":
            return Optional.ofNullable(clazz.cast(agentId()));
        case "agentVersion":
            return Optional.ofNullable(clazz.cast(agentVersion()));
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "collaborationInstruction":
            return Optional.ofNullable(clazz.cast(collaborationInstruction()));
        case "collaboratorId":
            return Optional.ofNullable(clazz.cast(collaboratorId()));
        case "collaboratorName":
            return Optional.ofNullable(clazz.cast(collaboratorName()));
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "lastUpdatedAt":
            return Optional.ofNullable(clazz.cast(lastUpdatedAt()));
        case "relayConversationHistory":
            return Optional.ofNullable(clazz.cast(relayConversationHistoryAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("agentDescriptor", AGENT_DESCRIPTOR_FIELD);
        map.put("agentId", AGENT_ID_FIELD);
        map.put("agentVersion", AGENT_VERSION_FIELD);
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        map.put("collaborationInstruction", COLLABORATION_INSTRUCTION_FIELD);
        map.put("collaboratorId", COLLABORATOR_ID_FIELD);
        map.put("collaboratorName", COLLABORATOR_NAME_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("lastUpdatedAt", LAST_UPDATED_AT_FIELD);
        map.put("relayConversationHistory", RELAY_CONVERSATION_HISTORY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AgentCollaborator, T> g) {
        return obj -> g.apply((AgentCollaborator) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AgentCollaborator> {
        /**
         * <p>
         * The collaborator's agent descriptor.
         * </p>
         * 
         * @param agentDescriptor
         *        The collaborator's agent descriptor.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder agentDescriptor(AgentDescriptor agentDescriptor);

        /**
         * <p>
         * The collaborator's agent descriptor.
         * </p>
         * This is a convenience method that creates an instance of the {@link AgentDescriptor.Builder} avoiding the
         * need to create one manually via {@link AgentDescriptor#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AgentDescriptor.Builder#build()} is called immediately and its
         * result is passed to {@link #agentDescriptor(AgentDescriptor)}.
         * 
         * @param agentDescriptor
         *        a consumer that will call methods on {@link AgentDescriptor.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #agentDescriptor(AgentDescriptor)
         */
        default Builder agentDescriptor(Consumer<AgentDescriptor.Builder> agentDescriptor) {
            return agentDescriptor(AgentDescriptor.builder().applyMutation(agentDescriptor).build());
        }

        /**
         * <p>
         * The collaborator's agent ID.
         * </p>
         * 
         * @param agentId
         *        The collaborator's agent ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder agentId(String agentId);

        /**
         * <p>
         * The collaborator's agent version.
         * </p>
         * 
         * @param agentVersion
         *        The collaborator's agent version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder agentVersion(String agentVersion);

        /**
         * <p>
         * The collaborator's client token.
         * </p>
         * 
         * @param clientToken
         *        The collaborator's client token.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * The collaborator's instructions.
         * </p>
         * 
         * @param collaborationInstruction
         *        The collaborator's instructions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder collaborationInstruction(String collaborationInstruction);

        /**
         * <p>
         * The collaborator's collaborator ID.
         * </p>
         * 
         * @param collaboratorId
         *        The collaborator's collaborator ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder collaboratorId(String collaboratorId);

        /**
         * <p>
         * The collaborator's collaborator name.
         * </p>
         * 
         * @param collaboratorName
         *        The collaborator's collaborator name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder collaboratorName(String collaboratorName);

        /**
         * <p>
         * When the collaborator was created.
         * </p>
         * 
         * @param createdAt
         *        When the collaborator was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * When the collaborator was updated.
         * </p>
         * 
         * @param lastUpdatedAt
         *        When the collaborator was updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedAt(Instant lastUpdatedAt);

        /**
         * <p>
         * The collaborator's relay conversation history.
         * </p>
         * 
         * @param relayConversationHistory
         *        The collaborator's relay conversation history.
         * @see RelayConversationHistory
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RelayConversationHistory
         */
        Builder relayConversationHistory(String relayConversationHistory);

        /**
         * <p>
         * The collaborator's relay conversation history.
         * </p>
         * 
         * @param relayConversationHistory
         *        The collaborator's relay conversation history.
         * @see RelayConversationHistory
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RelayConversationHistory
         */
        Builder relayConversationHistory(RelayConversationHistory relayConversationHistory);
    }

    static final class BuilderImpl implements Builder {
        private AgentDescriptor agentDescriptor;

        private String agentId;

        private String agentVersion;

        private String clientToken;

        private String collaborationInstruction;

        private String collaboratorId;

        private String collaboratorName;

        private Instant createdAt;

        private Instant lastUpdatedAt;

        private String relayConversationHistory;

        private BuilderImpl() {
        }

        private BuilderImpl(AgentCollaborator model) {
            agentDescriptor(model.agentDescriptor);
            agentId(model.agentId);
            agentVersion(model.agentVersion);
            clientToken(model.clientToken);
            collaborationInstruction(model.collaborationInstruction);
            collaboratorId(model.collaboratorId);
            collaboratorName(model.collaboratorName);
            createdAt(model.createdAt);
            lastUpdatedAt(model.lastUpdatedAt);
            relayConversationHistory(model.relayConversationHistory);
        }

        public final AgentDescriptor.Builder getAgentDescriptor() {
            return agentDescriptor != null ? agentDescriptor.toBuilder() : null;
        }

        public final void setAgentDescriptor(AgentDescriptor.BuilderImpl agentDescriptor) {
            this.agentDescriptor = agentDescriptor != null ? agentDescriptor.build() : null;
        }

        @Override
        public final Builder agentDescriptor(AgentDescriptor agentDescriptor) {
            this.agentDescriptor = agentDescriptor;
            return this;
        }

        public final String getAgentId() {
            return agentId;
        }

        public final void setAgentId(String agentId) {
            this.agentId = agentId;
        }

        @Override
        public final Builder agentId(String agentId) {
            this.agentId = agentId;
            return this;
        }

        public final String getAgentVersion() {
            return agentVersion;
        }

        public final void setAgentVersion(String agentVersion) {
            this.agentVersion = agentVersion;
        }

        @Override
        public final Builder agentVersion(String agentVersion) {
            this.agentVersion = agentVersion;
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getCollaborationInstruction() {
            return collaborationInstruction;
        }

        public final void setCollaborationInstruction(String collaborationInstruction) {
            this.collaborationInstruction = collaborationInstruction;
        }

        @Override
        public final Builder collaborationInstruction(String collaborationInstruction) {
            this.collaborationInstruction = collaborationInstruction;
            return this;
        }

        public final String getCollaboratorId() {
            return collaboratorId;
        }

        public final void setCollaboratorId(String collaboratorId) {
            this.collaboratorId = collaboratorId;
        }

        @Override
        public final Builder collaboratorId(String collaboratorId) {
            this.collaboratorId = collaboratorId;
            return this;
        }

        public final String getCollaboratorName() {
            return collaboratorName;
        }

        public final void setCollaboratorName(String collaboratorName) {
            this.collaboratorName = collaboratorName;
        }

        @Override
        public final Builder collaboratorName(String collaboratorName) {
            this.collaboratorName = collaboratorName;
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getLastUpdatedAt() {
            return lastUpdatedAt;
        }

        public final void setLastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
        }

        @Override
        public final Builder lastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
            return this;
        }

        public final String getRelayConversationHistory() {
            return relayConversationHistory;
        }

        public final void setRelayConversationHistory(String relayConversationHistory) {
            this.relayConversationHistory = relayConversationHistory;
        }

        @Override
        public final Builder relayConversationHistory(String relayConversationHistory) {
            this.relayConversationHistory = relayConversationHistory;
            return this;
        }

        @Override
        public final Builder relayConversationHistory(RelayConversationHistory relayConversationHistory) {
            this.relayConversationHistory(relayConversationHistory == null ? null : relayConversationHistory.toString());
            return this;
        }

        @Override
        public AgentCollaborator build() {
            return new AgentCollaborator(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
