/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagent.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.bedrockagent.model.CustomDocumentIdentifier;
import software.amazon.awssdk.services.bedrockagent.model.CustomS3Location;
import software.amazon.awssdk.services.bedrockagent.model.CustomSourceType;
import software.amazon.awssdk.services.bedrockagent.model.InlineContent;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CustomContent
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CustomContent> {
    private static final SdkField<CustomDocumentIdentifier> CUSTOM_DOCUMENT_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("customDocumentIdentifier").getter(CustomContent.getter(CustomContent::customDocumentIdentifier)).setter(CustomContent.setter(Builder::customDocumentIdentifier)).constructor(CustomDocumentIdentifier::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customDocumentIdentifier").build()}).build();
    private static final SdkField<InlineContent> INLINE_CONTENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("inlineContent").getter(CustomContent.getter(CustomContent::inlineContent)).setter(CustomContent.setter(Builder::inlineContent)).constructor(InlineContent::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inlineContent").build()}).build();
    private static final SdkField<CustomS3Location> S3_LOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("s3Location").getter(CustomContent.getter(CustomContent::s3Location)).setter(CustomContent.setter(Builder::s3Location)).constructor(CustomS3Location::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3Location").build()}).build();
    private static final SdkField<String> SOURCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sourceType").getter(CustomContent.getter(CustomContent::sourceTypeAsString)).setter(CustomContent.setter(Builder::sourceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CUSTOM_DOCUMENT_IDENTIFIER_FIELD, INLINE_CONTENT_FIELD, S3_LOCATION_FIELD, SOURCE_TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CustomContent.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final CustomDocumentIdentifier customDocumentIdentifier;
    private final InlineContent inlineContent;
    private final CustomS3Location s3Location;
    private final String sourceType;

    private CustomContent(BuilderImpl builder) {
        this.customDocumentIdentifier = builder.customDocumentIdentifier;
        this.inlineContent = builder.inlineContent;
        this.s3Location = builder.s3Location;
        this.sourceType = builder.sourceType;
    }

    public final CustomDocumentIdentifier customDocumentIdentifier() {
        return this.customDocumentIdentifier;
    }

    public final InlineContent inlineContent() {
        return this.inlineContent;
    }

    public final CustomS3Location s3Location() {
        return this.s3Location;
    }

    public final CustomSourceType sourceType() {
        return CustomSourceType.fromValue(this.sourceType);
    }

    public final String sourceTypeAsString() {
        return this.sourceType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.customDocumentIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.inlineContent());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3Location());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceTypeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CustomContent)) {
            return false;
        }
        CustomContent other = (CustomContent)obj;
        return Objects.equals(this.customDocumentIdentifier(), other.customDocumentIdentifier()) && Objects.equals(this.inlineContent(), other.inlineContent()) && Objects.equals(this.s3Location(), other.s3Location()) && Objects.equals(this.sourceTypeAsString(), other.sourceTypeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"CustomContent").add("CustomDocumentIdentifier", (Object)this.customDocumentIdentifier()).add("InlineContent", (Object)this.inlineContent()).add("S3Location", (Object)this.s3Location()).add("SourceType", (Object)this.sourceTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "customDocumentIdentifier": {
                return Optional.ofNullable(clazz.cast(this.customDocumentIdentifier()));
            }
            case "inlineContent": {
                return Optional.ofNullable(clazz.cast(this.inlineContent()));
            }
            case "s3Location": {
                return Optional.ofNullable(clazz.cast(this.s3Location()));
            }
            case "sourceType": {
                return Optional.ofNullable(clazz.cast(this.sourceTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("customDocumentIdentifier", CUSTOM_DOCUMENT_IDENTIFIER_FIELD);
        map.put("inlineContent", INLINE_CONTENT_FIELD);
        map.put("s3Location", S3_LOCATION_FIELD);
        map.put("sourceType", SOURCE_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CustomContent, T> g) {
        return obj -> g.apply((CustomContent)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private CustomDocumentIdentifier customDocumentIdentifier;
        private InlineContent inlineContent;
        private CustomS3Location s3Location;
        private String sourceType;

        private BuilderImpl() {
        }

        private BuilderImpl(CustomContent model) {
            this.customDocumentIdentifier(model.customDocumentIdentifier);
            this.inlineContent(model.inlineContent);
            this.s3Location(model.s3Location);
            this.sourceType(model.sourceType);
        }

        public final CustomDocumentIdentifier.Builder getCustomDocumentIdentifier() {
            return this.customDocumentIdentifier != null ? this.customDocumentIdentifier.toBuilder() : null;
        }

        public final void setCustomDocumentIdentifier(CustomDocumentIdentifier.BuilderImpl customDocumentIdentifier) {
            this.customDocumentIdentifier = customDocumentIdentifier != null ? customDocumentIdentifier.build() : null;
        }

        @Override
        public final Builder customDocumentIdentifier(CustomDocumentIdentifier customDocumentIdentifier) {
            this.customDocumentIdentifier = customDocumentIdentifier;
            return this;
        }

        public final InlineContent.Builder getInlineContent() {
            return this.inlineContent != null ? this.inlineContent.toBuilder() : null;
        }

        public final void setInlineContent(InlineContent.BuilderImpl inlineContent) {
            this.inlineContent = inlineContent != null ? inlineContent.build() : null;
        }

        @Override
        public final Builder inlineContent(InlineContent inlineContent) {
            this.inlineContent = inlineContent;
            return this;
        }

        public final CustomS3Location.Builder getS3Location() {
            return this.s3Location != null ? this.s3Location.toBuilder() : null;
        }

        public final void setS3Location(CustomS3Location.BuilderImpl s3Location) {
            this.s3Location = s3Location != null ? s3Location.build() : null;
        }

        @Override
        public final Builder s3Location(CustomS3Location s3Location) {
            this.s3Location = s3Location;
            return this;
        }

        public final String getSourceType() {
            return this.sourceType;
        }

        public final void setSourceType(String sourceType) {
            this.sourceType = sourceType;
        }

        @Override
        public final Builder sourceType(String sourceType) {
            this.sourceType = sourceType;
            return this;
        }

        @Override
        public final Builder sourceType(CustomSourceType sourceType) {
            this.sourceType(sourceType == null ? null : sourceType.toString());
            return this;
        }

        public CustomContent build() {
            return new CustomContent(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CustomContent> {
        public Builder customDocumentIdentifier(CustomDocumentIdentifier var1);

        default public Builder customDocumentIdentifier(Consumer<CustomDocumentIdentifier.Builder> customDocumentIdentifier) {
            return this.customDocumentIdentifier((CustomDocumentIdentifier)((CustomDocumentIdentifier.Builder)CustomDocumentIdentifier.builder().applyMutation(customDocumentIdentifier)).build());
        }

        public Builder inlineContent(InlineContent var1);

        default public Builder inlineContent(Consumer<InlineContent.Builder> inlineContent) {
            return this.inlineContent((InlineContent)((InlineContent.Builder)InlineContent.builder().applyMutation(inlineContent)).build());
        }

        public Builder s3Location(CustomS3Location var1);

        default public Builder s3Location(Consumer<CustomS3Location.Builder> s3Location) {
            return this.s3Location((CustomS3Location)((CustomS3Location.Builder)CustomS3Location.builder().applyMutation(s3Location)).build());
        }

        public Builder sourceType(String var1);

        public Builder sourceType(CustomSourceType var1);
    }
}

