/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagent.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.bedrockagent.model.BedrockAgentRequest;
import software.amazon.awssdk.services.bedrockagent.model.FlowAliasConcurrencyConfiguration;
import software.amazon.awssdk.services.bedrockagent.model.FlowAliasRoutingConfigurationCopier;
import software.amazon.awssdk.services.bedrockagent.model.FlowAliasRoutingConfigurationListItem;
import software.amazon.awssdk.services.bedrockagent.model.TagsMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateFlowAliasRequest
extends BedrockAgentRequest
implements ToCopyableBuilder<Builder, CreateFlowAliasRequest> {
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientToken").getter(CreateFlowAliasRequest.getter(CreateFlowAliasRequest::clientToken)).setter(CreateFlowAliasRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<FlowAliasConcurrencyConfiguration> CONCURRENCY_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("concurrencyConfiguration").getter(CreateFlowAliasRequest.getter(CreateFlowAliasRequest::concurrencyConfiguration)).setter(CreateFlowAliasRequest.setter(Builder::concurrencyConfiguration)).constructor(FlowAliasConcurrencyConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("concurrencyConfiguration").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(CreateFlowAliasRequest.getter(CreateFlowAliasRequest::description)).setter(CreateFlowAliasRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> FLOW_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("flowIdentifier").getter(CreateFlowAliasRequest.getter(CreateFlowAliasRequest::flowIdentifier)).setter(CreateFlowAliasRequest.setter(Builder::flowIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("flowIdentifier").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(CreateFlowAliasRequest.getter(CreateFlowAliasRequest::name)).setter(CreateFlowAliasRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<List<FlowAliasRoutingConfigurationListItem>> ROUTING_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("routingConfiguration").getter(CreateFlowAliasRequest.getter(CreateFlowAliasRequest::routingConfiguration)).setter(CreateFlowAliasRequest.setter(Builder::routingConfiguration)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("routingConfiguration").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(FlowAliasRoutingConfigurationListItem::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(CreateFlowAliasRequest.getter(CreateFlowAliasRequest::tags)).setter(CreateFlowAliasRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_TOKEN_FIELD, CONCURRENCY_CONFIGURATION_FIELD, DESCRIPTION_FIELD, FLOW_IDENTIFIER_FIELD, NAME_FIELD, ROUTING_CONFIGURATION_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateFlowAliasRequest.memberNameToFieldInitializer();
    private final String clientToken;
    private final FlowAliasConcurrencyConfiguration concurrencyConfiguration;
    private final String description;
    private final String flowIdentifier;
    private final String name;
    private final List<FlowAliasRoutingConfigurationListItem> routingConfiguration;
    private final Map<String, String> tags;

    private CreateFlowAliasRequest(BuilderImpl builder) {
        super(builder);
        this.clientToken = builder.clientToken;
        this.concurrencyConfiguration = builder.concurrencyConfiguration;
        this.description = builder.description;
        this.flowIdentifier = builder.flowIdentifier;
        this.name = builder.name;
        this.routingConfiguration = builder.routingConfiguration;
        this.tags = builder.tags;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final FlowAliasConcurrencyConfiguration concurrencyConfiguration() {
        return this.concurrencyConfiguration;
    }

    public final String description() {
        return this.description;
    }

    public final String flowIdentifier() {
        return this.flowIdentifier;
    }

    public final String name() {
        return this.name;
    }

    public final boolean hasRoutingConfiguration() {
        return this.routingConfiguration != null && !(this.routingConfiguration instanceof SdkAutoConstructList);
    }

    public final List<FlowAliasRoutingConfigurationListItem> routingConfiguration() {
        return this.routingConfiguration;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.concurrencyConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.flowIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRoutingConfiguration() ? this.routingConfiguration() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateFlowAliasRequest)) {
            return false;
        }
        CreateFlowAliasRequest other = (CreateFlowAliasRequest)((Object)obj);
        return Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.concurrencyConfiguration(), other.concurrencyConfiguration()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.flowIdentifier(), other.flowIdentifier()) && Objects.equals(this.name(), other.name()) && this.hasRoutingConfiguration() == other.hasRoutingConfiguration() && Objects.equals(this.routingConfiguration(), other.routingConfiguration()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"CreateFlowAliasRequest").add("ClientToken", (Object)this.clientToken()).add("ConcurrencyConfiguration", (Object)this.concurrencyConfiguration()).add("Description", (Object)this.description()).add("FlowIdentifier", (Object)this.flowIdentifier()).add("Name", (Object)this.name()).add("RoutingConfiguration", this.hasRoutingConfiguration() ? this.routingConfiguration() : null).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "concurrencyConfiguration": {
                return Optional.ofNullable(clazz.cast(this.concurrencyConfiguration()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "flowIdentifier": {
                return Optional.ofNullable(clazz.cast(this.flowIdentifier()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "routingConfiguration": {
                return Optional.ofNullable(clazz.cast(this.routingConfiguration()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        map.put("concurrencyConfiguration", CONCURRENCY_CONFIGURATION_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("flowIdentifier", FLOW_IDENTIFIER_FIELD);
        map.put("name", NAME_FIELD);
        map.put("routingConfiguration", ROUTING_CONFIGURATION_FIELD);
        map.put("tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateFlowAliasRequest, T> g) {
        return obj -> g.apply((CreateFlowAliasRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BedrockAgentRequest.BuilderImpl
    implements Builder {
        private String clientToken;
        private FlowAliasConcurrencyConfiguration concurrencyConfiguration;
        private String description;
        private String flowIdentifier;
        private String name;
        private List<FlowAliasRoutingConfigurationListItem> routingConfiguration = DefaultSdkAutoConstructList.getInstance();
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateFlowAliasRequest model) {
            super(model);
            this.clientToken(model.clientToken);
            this.concurrencyConfiguration(model.concurrencyConfiguration);
            this.description(model.description);
            this.flowIdentifier(model.flowIdentifier);
            this.name(model.name);
            this.routingConfiguration(model.routingConfiguration);
            this.tags(model.tags);
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final FlowAliasConcurrencyConfiguration.Builder getConcurrencyConfiguration() {
            return this.concurrencyConfiguration != null ? this.concurrencyConfiguration.toBuilder() : null;
        }

        public final void setConcurrencyConfiguration(FlowAliasConcurrencyConfiguration.BuilderImpl concurrencyConfiguration) {
            this.concurrencyConfiguration = concurrencyConfiguration != null ? concurrencyConfiguration.build() : null;
        }

        @Override
        public final Builder concurrencyConfiguration(FlowAliasConcurrencyConfiguration concurrencyConfiguration) {
            this.concurrencyConfiguration = concurrencyConfiguration;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getFlowIdentifier() {
            return this.flowIdentifier;
        }

        public final void setFlowIdentifier(String flowIdentifier) {
            this.flowIdentifier = flowIdentifier;
        }

        @Override
        public final Builder flowIdentifier(String flowIdentifier) {
            this.flowIdentifier = flowIdentifier;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final List<FlowAliasRoutingConfigurationListItem.Builder> getRoutingConfiguration() {
            List<FlowAliasRoutingConfigurationListItem.Builder> result = FlowAliasRoutingConfigurationCopier.copyToBuilder(this.routingConfiguration);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRoutingConfiguration(Collection<FlowAliasRoutingConfigurationListItem.BuilderImpl> routingConfiguration) {
            this.routingConfiguration = FlowAliasRoutingConfigurationCopier.copyFromBuilder(routingConfiguration);
        }

        @Override
        public final Builder routingConfiguration(Collection<FlowAliasRoutingConfigurationListItem> routingConfiguration) {
            this.routingConfiguration = FlowAliasRoutingConfigurationCopier.copy(routingConfiguration);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder routingConfiguration(FlowAliasRoutingConfigurationListItem ... routingConfiguration) {
            this.routingConfiguration(Arrays.asList(routingConfiguration));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder routingConfiguration(Consumer<FlowAliasRoutingConfigurationListItem.Builder> ... routingConfiguration) {
            this.routingConfiguration(Stream.of(routingConfiguration).map(c -> (FlowAliasRoutingConfigurationListItem)((FlowAliasRoutingConfigurationListItem.Builder)FlowAliasRoutingConfigurationListItem.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsMapCopier.copy(tags);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateFlowAliasRequest build() {
            return new CreateFlowAliasRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends BedrockAgentRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateFlowAliasRequest> {
        public Builder clientToken(String var1);

        public Builder concurrencyConfiguration(FlowAliasConcurrencyConfiguration var1);

        default public Builder concurrencyConfiguration(Consumer<FlowAliasConcurrencyConfiguration.Builder> concurrencyConfiguration) {
            return this.concurrencyConfiguration((FlowAliasConcurrencyConfiguration)((FlowAliasConcurrencyConfiguration.Builder)FlowAliasConcurrencyConfiguration.builder().applyMutation(concurrencyConfiguration)).build());
        }

        public Builder description(String var1);

        public Builder flowIdentifier(String var1);

        public Builder name(String var1);

        public Builder routingConfiguration(Collection<FlowAliasRoutingConfigurationListItem> var1);

        public Builder routingConfiguration(FlowAliasRoutingConfigurationListItem ... var1);

        public Builder routingConfiguration(Consumer<FlowAliasRoutingConfigurationListItem.Builder> ... var1);

        public Builder tags(Map<String, String> var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

