/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagent.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.bedrockagent.model.GuardrailConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class KnowledgeBaseFlowNodeConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, KnowledgeBaseFlowNodeConfiguration> {
    private static final SdkField<GuardrailConfiguration> GUARDRAIL_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("guardrailConfiguration").getter(KnowledgeBaseFlowNodeConfiguration.getter(KnowledgeBaseFlowNodeConfiguration::guardrailConfiguration)).setter(KnowledgeBaseFlowNodeConfiguration.setter(Builder::guardrailConfiguration)).constructor(GuardrailConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("guardrailConfiguration").build()}).build();
    private static final SdkField<String> KNOWLEDGE_BASE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("knowledgeBaseId").getter(KnowledgeBaseFlowNodeConfiguration.getter(KnowledgeBaseFlowNodeConfiguration::knowledgeBaseId)).setter(KnowledgeBaseFlowNodeConfiguration.setter(Builder::knowledgeBaseId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("knowledgeBaseId").build()}).build();
    private static final SdkField<String> MODEL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("modelId").getter(KnowledgeBaseFlowNodeConfiguration.getter(KnowledgeBaseFlowNodeConfiguration::modelId)).setter(KnowledgeBaseFlowNodeConfiguration.setter(Builder::modelId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modelId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GUARDRAIL_CONFIGURATION_FIELD, KNOWLEDGE_BASE_ID_FIELD, MODEL_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = KnowledgeBaseFlowNodeConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final GuardrailConfiguration guardrailConfiguration;
    private final String knowledgeBaseId;
    private final String modelId;

    private KnowledgeBaseFlowNodeConfiguration(BuilderImpl builder) {
        this.guardrailConfiguration = builder.guardrailConfiguration;
        this.knowledgeBaseId = builder.knowledgeBaseId;
        this.modelId = builder.modelId;
    }

    public final GuardrailConfiguration guardrailConfiguration() {
        return this.guardrailConfiguration;
    }

    public final String knowledgeBaseId() {
        return this.knowledgeBaseId;
    }

    public final String modelId() {
        return this.modelId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.guardrailConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.knowledgeBaseId());
        hashCode = 31 * hashCode + Objects.hashCode(this.modelId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof KnowledgeBaseFlowNodeConfiguration)) {
            return false;
        }
        KnowledgeBaseFlowNodeConfiguration other = (KnowledgeBaseFlowNodeConfiguration)obj;
        return Objects.equals(this.guardrailConfiguration(), other.guardrailConfiguration()) && Objects.equals(this.knowledgeBaseId(), other.knowledgeBaseId()) && Objects.equals(this.modelId(), other.modelId());
    }

    public final String toString() {
        return ToString.builder((String)"KnowledgeBaseFlowNodeConfiguration").add("GuardrailConfiguration", (Object)this.guardrailConfiguration()).add("KnowledgeBaseId", (Object)this.knowledgeBaseId()).add("ModelId", (Object)this.modelId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "guardrailConfiguration": {
                return Optional.ofNullable(clazz.cast(this.guardrailConfiguration()));
            }
            case "knowledgeBaseId": {
                return Optional.ofNullable(clazz.cast(this.knowledgeBaseId()));
            }
            case "modelId": {
                return Optional.ofNullable(clazz.cast(this.modelId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("guardrailConfiguration", GUARDRAIL_CONFIGURATION_FIELD);
        map.put("knowledgeBaseId", KNOWLEDGE_BASE_ID_FIELD);
        map.put("modelId", MODEL_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<KnowledgeBaseFlowNodeConfiguration, T> g) {
        return obj -> g.apply((KnowledgeBaseFlowNodeConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private GuardrailConfiguration guardrailConfiguration;
        private String knowledgeBaseId;
        private String modelId;

        private BuilderImpl() {
        }

        private BuilderImpl(KnowledgeBaseFlowNodeConfiguration model) {
            this.guardrailConfiguration(model.guardrailConfiguration);
            this.knowledgeBaseId(model.knowledgeBaseId);
            this.modelId(model.modelId);
        }

        public final GuardrailConfiguration.Builder getGuardrailConfiguration() {
            return this.guardrailConfiguration != null ? this.guardrailConfiguration.toBuilder() : null;
        }

        public final void setGuardrailConfiguration(GuardrailConfiguration.BuilderImpl guardrailConfiguration) {
            this.guardrailConfiguration = guardrailConfiguration != null ? guardrailConfiguration.build() : null;
        }

        @Override
        public final Builder guardrailConfiguration(GuardrailConfiguration guardrailConfiguration) {
            this.guardrailConfiguration = guardrailConfiguration;
            return this;
        }

        public final String getKnowledgeBaseId() {
            return this.knowledgeBaseId;
        }

        public final void setKnowledgeBaseId(String knowledgeBaseId) {
            this.knowledgeBaseId = knowledgeBaseId;
        }

        @Override
        public final Builder knowledgeBaseId(String knowledgeBaseId) {
            this.knowledgeBaseId = knowledgeBaseId;
            return this;
        }

        public final String getModelId() {
            return this.modelId;
        }

        public final void setModelId(String modelId) {
            this.modelId = modelId;
        }

        @Override
        public final Builder modelId(String modelId) {
            this.modelId = modelId;
            return this;
        }

        public KnowledgeBaseFlowNodeConfiguration build() {
            return new KnowledgeBaseFlowNodeConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, KnowledgeBaseFlowNodeConfiguration> {
        public Builder guardrailConfiguration(GuardrailConfiguration var1);

        default public Builder guardrailConfiguration(Consumer<GuardrailConfiguration.Builder> guardrailConfiguration) {
            return this.guardrailConfiguration((GuardrailConfiguration)((GuardrailConfiguration.Builder)GuardrailConfiguration.builder().applyMutation(guardrailConfiguration)).build());
        }

        public Builder knowledgeBaseId(String var1);

        public Builder modelId(String var1);
    }
}

