/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagent.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.bedrockagent.model.BedrockAgentRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeleteAgentRequest
extends BedrockAgentRequest
implements ToCopyableBuilder<Builder, DeleteAgentRequest> {
    private static final SdkField<String> AGENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("agentId").getter(DeleteAgentRequest.getter(DeleteAgentRequest::agentId)).setter(DeleteAgentRequest.setter(Builder::agentId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("agentId").build()}).build();
    private static final SdkField<Boolean> SKIP_RESOURCE_IN_USE_CHECK_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("skipResourceInUseCheck").getter(DeleteAgentRequest.getter(DeleteAgentRequest::skipResourceInUseCheck)).setter(DeleteAgentRequest.setter(Builder::skipResourceInUseCheck)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("skipResourceInUseCheck").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AGENT_ID_FIELD, SKIP_RESOURCE_IN_USE_CHECK_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DeleteAgentRequest.memberNameToFieldInitializer();
    private final String agentId;
    private final Boolean skipResourceInUseCheck;

    private DeleteAgentRequest(BuilderImpl builder) {
        super(builder);
        this.agentId = builder.agentId;
        this.skipResourceInUseCheck = builder.skipResourceInUseCheck;
    }

    public final String agentId() {
        return this.agentId;
    }

    public final Boolean skipResourceInUseCheck() {
        return this.skipResourceInUseCheck;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.agentId());
        hashCode = 31 * hashCode + Objects.hashCode(this.skipResourceInUseCheck());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteAgentRequest)) {
            return false;
        }
        DeleteAgentRequest other = (DeleteAgentRequest)((Object)obj);
        return Objects.equals(this.agentId(), other.agentId()) && Objects.equals(this.skipResourceInUseCheck(), other.skipResourceInUseCheck());
    }

    public final String toString() {
        return ToString.builder((String)"DeleteAgentRequest").add("AgentId", (Object)this.agentId()).add("SkipResourceInUseCheck", (Object)this.skipResourceInUseCheck()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "agentId": {
                return Optional.ofNullable(clazz.cast(this.agentId()));
            }
            case "skipResourceInUseCheck": {
                return Optional.ofNullable(clazz.cast(this.skipResourceInUseCheck()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("agentId", AGENT_ID_FIELD);
        map.put("skipResourceInUseCheck", SKIP_RESOURCE_IN_USE_CHECK_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeleteAgentRequest, T> g) {
        return obj -> g.apply((DeleteAgentRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BedrockAgentRequest.BuilderImpl
    implements Builder {
        private String agentId;
        private Boolean skipResourceInUseCheck;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteAgentRequest model) {
            super(model);
            this.agentId(model.agentId);
            this.skipResourceInUseCheck(model.skipResourceInUseCheck);
        }

        public final String getAgentId() {
            return this.agentId;
        }

        public final void setAgentId(String agentId) {
            this.agentId = agentId;
        }

        @Override
        public final Builder agentId(String agentId) {
            this.agentId = agentId;
            return this;
        }

        public final Boolean getSkipResourceInUseCheck() {
            return this.skipResourceInUseCheck;
        }

        public final void setSkipResourceInUseCheck(Boolean skipResourceInUseCheck) {
            this.skipResourceInUseCheck = skipResourceInUseCheck;
        }

        @Override
        public final Builder skipResourceInUseCheck(Boolean skipResourceInUseCheck) {
            this.skipResourceInUseCheck = skipResourceInUseCheck;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteAgentRequest build() {
            return new DeleteAgentRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends BedrockAgentRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DeleteAgentRequest> {
        public Builder agentId(String var1);

        public Builder skipResourceInUseCheck(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

