/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagent.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.bedrockagent.BedrockAgentClient;
import software.amazon.awssdk.services.bedrockagent.internal.UserAgentUtils;
import software.amazon.awssdk.services.bedrockagent.model.IngestionJobSummary;
import software.amazon.awssdk.services.bedrockagent.model.ListIngestionJobsRequest;
import software.amazon.awssdk.services.bedrockagent.model.ListIngestionJobsResponse;

public class ListIngestionJobsIterable
implements SdkIterable<ListIngestionJobsResponse> {
    private final BedrockAgentClient client;
    private final ListIngestionJobsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListIngestionJobsIterable(BedrockAgentClient client, ListIngestionJobsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListIngestionJobsResponseFetcher();
    }

    public Iterator<ListIngestionJobsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<IngestionJobSummary> ingestionJobSummaries() {
        Function<ListIngestionJobsResponse, Iterator> getIterator = response -> {
            if (response != null && response.ingestionJobSummaries() != null) {
                return response.ingestionJobSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListIngestionJobsResponseFetcher
    implements SyncPageFetcher<ListIngestionJobsResponse> {
        private ListIngestionJobsResponseFetcher() {
        }

        public boolean hasNextPage(ListIngestionJobsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListIngestionJobsResponse nextPage(ListIngestionJobsResponse previousPage) {
            if (previousPage == null) {
                return ListIngestionJobsIterable.this.client.listIngestionJobs(ListIngestionJobsIterable.this.firstRequest);
            }
            return ListIngestionJobsIterable.this.client.listIngestionJobs((ListIngestionJobsRequest)((Object)ListIngestionJobsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

