/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagent.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.bedrockagent.BedrockAgentClient;
import software.amazon.awssdk.services.bedrockagent.internal.UserAgentUtils;
import software.amazon.awssdk.services.bedrockagent.model.ListPromptsRequest;
import software.amazon.awssdk.services.bedrockagent.model.ListPromptsResponse;
import software.amazon.awssdk.services.bedrockagent.model.PromptSummary;

public class ListPromptsIterable
implements SdkIterable<ListPromptsResponse> {
    private final BedrockAgentClient client;
    private final ListPromptsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListPromptsIterable(BedrockAgentClient client, ListPromptsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListPromptsResponseFetcher();
    }

    public Iterator<ListPromptsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<PromptSummary> promptSummaries() {
        Function<ListPromptsResponse, Iterator> getIterator = response -> {
            if (response != null && response.promptSummaries() != null) {
                return response.promptSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListPromptsResponseFetcher
    implements SyncPageFetcher<ListPromptsResponse> {
        private ListPromptsResponseFetcher() {
        }

        public boolean hasNextPage(ListPromptsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListPromptsResponse nextPage(ListPromptsResponse previousPage) {
            if (previousPage == null) {
                return ListPromptsIterable.this.client.listPrompts(ListPromptsIterable.this.firstRequest);
            }
            return ListPromptsIterable.this.client.listPrompts((ListPromptsRequest)((Object)ListPromptsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

