/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagent.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.bedrockagent.model.EnrichmentStrategyMethod;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EnrichmentStrategyConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EnrichmentStrategyConfiguration> {
    private static final SdkField<String> METHOD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("method").getter(EnrichmentStrategyConfiguration.getter(EnrichmentStrategyConfiguration::methodAsString)).setter(EnrichmentStrategyConfiguration.setter(Builder::method)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("method").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(METHOD_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = EnrichmentStrategyConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String method;

    private EnrichmentStrategyConfiguration(BuilderImpl builder) {
        this.method = builder.method;
    }

    public final EnrichmentStrategyMethod method() {
        return EnrichmentStrategyMethod.fromValue(this.method);
    }

    public final String methodAsString() {
        return this.method;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.methodAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EnrichmentStrategyConfiguration)) {
            return false;
        }
        EnrichmentStrategyConfiguration other = (EnrichmentStrategyConfiguration)obj;
        return Objects.equals(this.methodAsString(), other.methodAsString());
    }

    public final String toString() {
        return ToString.builder((String)"EnrichmentStrategyConfiguration").add("Method", (Object)this.methodAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "method": {
                return Optional.ofNullable(clazz.cast(this.methodAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("method", METHOD_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EnrichmentStrategyConfiguration, T> g) {
        return obj -> g.apply((EnrichmentStrategyConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String method;

        private BuilderImpl() {
        }

        private BuilderImpl(EnrichmentStrategyConfiguration model) {
            this.method(model.method);
        }

        public final String getMethod() {
            return this.method;
        }

        public final void setMethod(String method) {
            this.method = method;
        }

        @Override
        public final Builder method(String method) {
            this.method = method;
            return this;
        }

        @Override
        public final Builder method(EnrichmentStrategyMethod method) {
            this.method(method == null ? null : method.toString());
            return this;
        }

        public EnrichmentStrategyConfiguration build() {
            return new EnrichmentStrategyConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EnrichmentStrategyConfiguration> {
        public Builder method(String var1);

        public Builder method(EnrichmentStrategyMethod var1);
    }
}

