/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagent.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum MetadataValueType {
    BOOLEAN("BOOLEAN"),
    NUMBER("NUMBER"),
    STRING("STRING"),
    STRING_LIST("STRING_LIST"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, MetadataValueType> VALUE_MAP;
    private final String value;

    private MetadataValueType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static MetadataValueType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<MetadataValueType> knownValues() {
        EnumSet<MetadataValueType> knownValues = EnumSet.allOf(MetadataValueType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(MetadataValueType.class, MetadataValueType::toString);
    }
}

