/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagent.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.bedrockagent.model.EnrichmentStrategyConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BedrockFoundationModelContextEnrichmentConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, BedrockFoundationModelContextEnrichmentConfiguration> {
    private static final SdkField<EnrichmentStrategyConfiguration> ENRICHMENT_STRATEGY_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("enrichmentStrategyConfiguration").getter(BedrockFoundationModelContextEnrichmentConfiguration.getter(BedrockFoundationModelContextEnrichmentConfiguration::enrichmentStrategyConfiguration)).setter(BedrockFoundationModelContextEnrichmentConfiguration.setter(Builder::enrichmentStrategyConfiguration)).constructor(EnrichmentStrategyConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enrichmentStrategyConfiguration").build()}).build();
    private static final SdkField<String> MODEL_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("modelArn").getter(BedrockFoundationModelContextEnrichmentConfiguration.getter(BedrockFoundationModelContextEnrichmentConfiguration::modelArn)).setter(BedrockFoundationModelContextEnrichmentConfiguration.setter(Builder::modelArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modelArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENRICHMENT_STRATEGY_CONFIGURATION_FIELD, MODEL_ARN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = BedrockFoundationModelContextEnrichmentConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final EnrichmentStrategyConfiguration enrichmentStrategyConfiguration;
    private final String modelArn;

    private BedrockFoundationModelContextEnrichmentConfiguration(BuilderImpl builder) {
        this.enrichmentStrategyConfiguration = builder.enrichmentStrategyConfiguration;
        this.modelArn = builder.modelArn;
    }

    public final EnrichmentStrategyConfiguration enrichmentStrategyConfiguration() {
        return this.enrichmentStrategyConfiguration;
    }

    public final String modelArn() {
        return this.modelArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.enrichmentStrategyConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.modelArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BedrockFoundationModelContextEnrichmentConfiguration)) {
            return false;
        }
        BedrockFoundationModelContextEnrichmentConfiguration other = (BedrockFoundationModelContextEnrichmentConfiguration)obj;
        return Objects.equals(this.enrichmentStrategyConfiguration(), other.enrichmentStrategyConfiguration()) && Objects.equals(this.modelArn(), other.modelArn());
    }

    public final String toString() {
        return ToString.builder((String)"BedrockFoundationModelContextEnrichmentConfiguration").add("EnrichmentStrategyConfiguration", (Object)this.enrichmentStrategyConfiguration()).add("ModelArn", (Object)this.modelArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "enrichmentStrategyConfiguration": {
                return Optional.ofNullable(clazz.cast(this.enrichmentStrategyConfiguration()));
            }
            case "modelArn": {
                return Optional.ofNullable(clazz.cast(this.modelArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("enrichmentStrategyConfiguration", ENRICHMENT_STRATEGY_CONFIGURATION_FIELD);
        map.put("modelArn", MODEL_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BedrockFoundationModelContextEnrichmentConfiguration, T> g) {
        return obj -> g.apply((BedrockFoundationModelContextEnrichmentConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private EnrichmentStrategyConfiguration enrichmentStrategyConfiguration;
        private String modelArn;

        private BuilderImpl() {
        }

        private BuilderImpl(BedrockFoundationModelContextEnrichmentConfiguration model) {
            this.enrichmentStrategyConfiguration(model.enrichmentStrategyConfiguration);
            this.modelArn(model.modelArn);
        }

        public final EnrichmentStrategyConfiguration.Builder getEnrichmentStrategyConfiguration() {
            return this.enrichmentStrategyConfiguration != null ? this.enrichmentStrategyConfiguration.toBuilder() : null;
        }

        public final void setEnrichmentStrategyConfiguration(EnrichmentStrategyConfiguration.BuilderImpl enrichmentStrategyConfiguration) {
            this.enrichmentStrategyConfiguration = enrichmentStrategyConfiguration != null ? enrichmentStrategyConfiguration.build() : null;
        }

        @Override
        public final Builder enrichmentStrategyConfiguration(EnrichmentStrategyConfiguration enrichmentStrategyConfiguration) {
            this.enrichmentStrategyConfiguration = enrichmentStrategyConfiguration;
            return this;
        }

        public final String getModelArn() {
            return this.modelArn;
        }

        public final void setModelArn(String modelArn) {
            this.modelArn = modelArn;
        }

        @Override
        public final Builder modelArn(String modelArn) {
            this.modelArn = modelArn;
            return this;
        }

        public BedrockFoundationModelContextEnrichmentConfiguration build() {
            return new BedrockFoundationModelContextEnrichmentConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, BedrockFoundationModelContextEnrichmentConfiguration> {
        public Builder enrichmentStrategyConfiguration(EnrichmentStrategyConfiguration var1);

        default public Builder enrichmentStrategyConfiguration(Consumer<EnrichmentStrategyConfiguration.Builder> enrichmentStrategyConfiguration) {
            return this.enrichmentStrategyConfiguration((EnrichmentStrategyConfiguration)((EnrichmentStrategyConfiguration.Builder)EnrichmentStrategyConfiguration.builder().applyMutation(enrichmentStrategyConfiguration)).build());
        }

        public Builder modelArn(String var1);
    }
}

