/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagent.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.bedrockagent.model.AgentVersionSummariesCopier;
import software.amazon.awssdk.services.bedrockagent.model.AgentVersionSummary;
import software.amazon.awssdk.services.bedrockagent.model.BedrockAgentResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListAgentVersionsResponse
extends BedrockAgentResponse
implements ToCopyableBuilder<Builder, ListAgentVersionsResponse> {
    private static final SdkField<List<AgentVersionSummary>> AGENT_VERSION_SUMMARIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("agentVersionSummaries").getter(ListAgentVersionsResponse.getter(ListAgentVersionsResponse::agentVersionSummaries)).setter(ListAgentVersionsResponse.setter(Builder::agentVersionSummaries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("agentVersionSummaries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AgentVersionSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListAgentVersionsResponse.getter(ListAgentVersionsResponse::nextToken)).setter(ListAgentVersionsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AGENT_VERSION_SUMMARIES_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListAgentVersionsResponse.memberNameToFieldInitializer();
    private final List<AgentVersionSummary> agentVersionSummaries;
    private final String nextToken;

    private ListAgentVersionsResponse(BuilderImpl builder) {
        super(builder);
        this.agentVersionSummaries = builder.agentVersionSummaries;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasAgentVersionSummaries() {
        return this.agentVersionSummaries != null && !(this.agentVersionSummaries instanceof SdkAutoConstructList);
    }

    public final List<AgentVersionSummary> agentVersionSummaries() {
        return this.agentVersionSummaries;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAgentVersionSummaries() ? this.agentVersionSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAgentVersionsResponse)) {
            return false;
        }
        ListAgentVersionsResponse other = (ListAgentVersionsResponse)((Object)obj);
        return this.hasAgentVersionSummaries() == other.hasAgentVersionSummaries() && Objects.equals(this.agentVersionSummaries(), other.agentVersionSummaries()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListAgentVersionsResponse").add("AgentVersionSummaries", this.hasAgentVersionSummaries() ? this.agentVersionSummaries() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "agentVersionSummaries": {
                return Optional.ofNullable(clazz.cast(this.agentVersionSummaries()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("agentVersionSummaries", AGENT_VERSION_SUMMARIES_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListAgentVersionsResponse, T> g) {
        return obj -> g.apply((ListAgentVersionsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BedrockAgentResponse.BuilderImpl
    implements Builder {
        private List<AgentVersionSummary> agentVersionSummaries = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAgentVersionsResponse model) {
            super(model);
            this.agentVersionSummaries(model.agentVersionSummaries);
            this.nextToken(model.nextToken);
        }

        public final List<AgentVersionSummary.Builder> getAgentVersionSummaries() {
            List<AgentVersionSummary.Builder> result = AgentVersionSummariesCopier.copyToBuilder(this.agentVersionSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAgentVersionSummaries(Collection<AgentVersionSummary.BuilderImpl> agentVersionSummaries) {
            this.agentVersionSummaries = AgentVersionSummariesCopier.copyFromBuilder(agentVersionSummaries);
        }

        @Override
        public final Builder agentVersionSummaries(Collection<AgentVersionSummary> agentVersionSummaries) {
            this.agentVersionSummaries = AgentVersionSummariesCopier.copy(agentVersionSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder agentVersionSummaries(AgentVersionSummary ... agentVersionSummaries) {
            this.agentVersionSummaries(Arrays.asList(agentVersionSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder agentVersionSummaries(Consumer<AgentVersionSummary.Builder> ... agentVersionSummaries) {
            this.agentVersionSummaries(Stream.of(agentVersionSummaries).map(c -> (AgentVersionSummary)((AgentVersionSummary.Builder)AgentVersionSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListAgentVersionsResponse build() {
            return new ListAgentVersionsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends BedrockAgentResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListAgentVersionsResponse> {
        public Builder agentVersionSummaries(Collection<AgentVersionSummary> var1);

        public Builder agentVersionSummaries(AgentVersionSummary ... var1);

        public Builder agentVersionSummaries(Consumer<AgentVersionSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

