/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagent.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.bedrockagent.BedrockAgentClient;
import software.amazon.awssdk.services.bedrockagent.internal.UserAgentUtils;
import software.amazon.awssdk.services.bedrockagent.model.KnowledgeBaseDocumentDetail;
import software.amazon.awssdk.services.bedrockagent.model.ListKnowledgeBaseDocumentsRequest;
import software.amazon.awssdk.services.bedrockagent.model.ListKnowledgeBaseDocumentsResponse;

public class ListKnowledgeBaseDocumentsIterable
implements SdkIterable<ListKnowledgeBaseDocumentsResponse> {
    private final BedrockAgentClient client;
    private final ListKnowledgeBaseDocumentsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListKnowledgeBaseDocumentsIterable(BedrockAgentClient client, ListKnowledgeBaseDocumentsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListKnowledgeBaseDocumentsResponseFetcher();
    }

    public Iterator<ListKnowledgeBaseDocumentsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<KnowledgeBaseDocumentDetail> documentDetails() {
        Function<ListKnowledgeBaseDocumentsResponse, Iterator> getIterator = response -> {
            if (response != null && response.documentDetails() != null) {
                return response.documentDetails().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListKnowledgeBaseDocumentsResponseFetcher
    implements SyncPageFetcher<ListKnowledgeBaseDocumentsResponse> {
        private ListKnowledgeBaseDocumentsResponseFetcher() {
        }

        public boolean hasNextPage(ListKnowledgeBaseDocumentsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListKnowledgeBaseDocumentsResponse nextPage(ListKnowledgeBaseDocumentsResponse previousPage) {
            if (previousPage == null) {
                return ListKnowledgeBaseDocumentsIterable.this.client.listKnowledgeBaseDocuments(ListKnowledgeBaseDocumentsIterable.this.firstRequest);
            }
            return ListKnowledgeBaseDocumentsIterable.this.client.listKnowledgeBaseDocuments((ListKnowledgeBaseDocumentsRequest)((Object)ListKnowledgeBaseDocumentsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

