/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagent.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.bedrockagent.model.BedrockAgentResponse;
import software.amazon.awssdk.services.bedrockagent.model.PromptVariant;
import software.amazon.awssdk.services.bedrockagent.model.PromptVariantListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdatePromptResponse
extends BedrockAgentResponse
implements ToCopyableBuilder<Builder, UpdatePromptResponse> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("arn").getter(UpdatePromptResponse.getter(UpdatePromptResponse::arn)).setter(UpdatePromptResponse.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdAt").getter(UpdatePromptResponse.getter(UpdatePromptResponse::createdAt)).setter(UpdatePromptResponse.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> CUSTOMER_ENCRYPTION_KEY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("customerEncryptionKeyArn").getter(UpdatePromptResponse.getter(UpdatePromptResponse::customerEncryptionKeyArn)).setter(UpdatePromptResponse.setter(Builder::customerEncryptionKeyArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customerEncryptionKeyArn").build()}).build();
    private static final SdkField<String> DEFAULT_VARIANT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("defaultVariant").getter(UpdatePromptResponse.getter(UpdatePromptResponse::defaultVariant)).setter(UpdatePromptResponse.setter(Builder::defaultVariant)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("defaultVariant").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(UpdatePromptResponse.getter(UpdatePromptResponse::description)).setter(UpdatePromptResponse.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("id").getter(UpdatePromptResponse.getter(UpdatePromptResponse::id)).setter(UpdatePromptResponse.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(UpdatePromptResponse.getter(UpdatePromptResponse::name)).setter(UpdatePromptResponse.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("updatedAt").getter(UpdatePromptResponse.getter(UpdatePromptResponse::updatedAt)).setter(UpdatePromptResponse.setter(Builder::updatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<List<PromptVariant>> VARIANTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("variants").getter(UpdatePromptResponse.getter(UpdatePromptResponse::variants)).setter(UpdatePromptResponse.setter(Builder::variants)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("variants").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PromptVariant::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("version").getter(UpdatePromptResponse.getter(UpdatePromptResponse::version)).setter(UpdatePromptResponse.setter(Builder::version)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("version").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, CREATED_AT_FIELD, CUSTOMER_ENCRYPTION_KEY_ARN_FIELD, DEFAULT_VARIANT_FIELD, DESCRIPTION_FIELD, ID_FIELD, NAME_FIELD, UPDATED_AT_FIELD, VARIANTS_FIELD, VERSION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdatePromptResponse.memberNameToFieldInitializer();
    private final String arn;
    private final Instant createdAt;
    private final String customerEncryptionKeyArn;
    private final String defaultVariant;
    private final String description;
    private final String id;
    private final String name;
    private final Instant updatedAt;
    private final List<PromptVariant> variants;
    private final String version;

    private UpdatePromptResponse(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.createdAt = builder.createdAt;
        this.customerEncryptionKeyArn = builder.customerEncryptionKeyArn;
        this.defaultVariant = builder.defaultVariant;
        this.description = builder.description;
        this.id = builder.id;
        this.name = builder.name;
        this.updatedAt = builder.updatedAt;
        this.variants = builder.variants;
        this.version = builder.version;
    }

    public final String arn() {
        return this.arn;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final String customerEncryptionKeyArn() {
        return this.customerEncryptionKeyArn;
    }

    public final String defaultVariant() {
        return this.defaultVariant;
    }

    public final String description() {
        return this.description;
    }

    public final String id() {
        return this.id;
    }

    public final String name() {
        return this.name;
    }

    public final Instant updatedAt() {
        return this.updatedAt;
    }

    public final boolean hasVariants() {
        return this.variants != null && !(this.variants instanceof SdkAutoConstructList);
    }

    public final List<PromptVariant> variants() {
        return this.variants;
    }

    public final String version() {
        return this.version;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.customerEncryptionKeyArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultVariant());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.updatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasVariants() ? this.variants() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.version());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdatePromptResponse)) {
            return false;
        }
        UpdatePromptResponse other = (UpdatePromptResponse)((Object)obj);
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.customerEncryptionKeyArn(), other.customerEncryptionKeyArn()) && Objects.equals(this.defaultVariant(), other.defaultVariant()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.updatedAt(), other.updatedAt()) && this.hasVariants() == other.hasVariants() && Objects.equals(this.variants(), other.variants()) && Objects.equals(this.version(), other.version());
    }

    public final String toString() {
        return ToString.builder((String)"UpdatePromptResponse").add("Arn", (Object)this.arn()).add("CreatedAt", (Object)this.createdAt()).add("CustomerEncryptionKeyArn", (Object)this.customerEncryptionKeyArn()).add("DefaultVariant", (Object)this.defaultVariant()).add("Description", (Object)this.description()).add("Id", (Object)this.id()).add("Name", (Object)this.name()).add("UpdatedAt", (Object)this.updatedAt()).add("Variants", (Object)(this.variants() == null ? null : "*** Sensitive Data Redacted ***")).add("Version", (Object)this.version()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "customerEncryptionKeyArn": {
                return Optional.ofNullable(clazz.cast(this.customerEncryptionKeyArn()));
            }
            case "defaultVariant": {
                return Optional.ofNullable(clazz.cast(this.defaultVariant()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "updatedAt": {
                return Optional.ofNullable(clazz.cast(this.updatedAt()));
            }
            case "variants": {
                return Optional.ofNullable(clazz.cast(this.variants()));
            }
            case "version": {
                return Optional.ofNullable(clazz.cast(this.version()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("arn", ARN_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("customerEncryptionKeyArn", CUSTOMER_ENCRYPTION_KEY_ARN_FIELD);
        map.put("defaultVariant", DEFAULT_VARIANT_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("id", ID_FIELD);
        map.put("name", NAME_FIELD);
        map.put("updatedAt", UPDATED_AT_FIELD);
        map.put("variants", VARIANTS_FIELD);
        map.put("version", VERSION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdatePromptResponse, T> g) {
        return obj -> g.apply((UpdatePromptResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BedrockAgentResponse.BuilderImpl
    implements Builder {
        private String arn;
        private Instant createdAt;
        private String customerEncryptionKeyArn;
        private String defaultVariant;
        private String description;
        private String id;
        private String name;
        private Instant updatedAt;
        private List<PromptVariant> variants = DefaultSdkAutoConstructList.getInstance();
        private String version;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdatePromptResponse model) {
            super(model);
            this.arn(model.arn);
            this.createdAt(model.createdAt);
            this.customerEncryptionKeyArn(model.customerEncryptionKeyArn);
            this.defaultVariant(model.defaultVariant);
            this.description(model.description);
            this.id(model.id);
            this.name(model.name);
            this.updatedAt(model.updatedAt);
            this.variants(model.variants);
            this.version(model.version);
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getCustomerEncryptionKeyArn() {
            return this.customerEncryptionKeyArn;
        }

        public final void setCustomerEncryptionKeyArn(String customerEncryptionKeyArn) {
            this.customerEncryptionKeyArn = customerEncryptionKeyArn;
        }

        @Override
        public final Builder customerEncryptionKeyArn(String customerEncryptionKeyArn) {
            this.customerEncryptionKeyArn = customerEncryptionKeyArn;
            return this;
        }

        public final String getDefaultVariant() {
            return this.defaultVariant;
        }

        public final void setDefaultVariant(String defaultVariant) {
            this.defaultVariant = defaultVariant;
        }

        @Override
        public final Builder defaultVariant(String defaultVariant) {
            this.defaultVariant = defaultVariant;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Instant getUpdatedAt() {
            return this.updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public final List<PromptVariant.Builder> getVariants() {
            List<PromptVariant.Builder> result = PromptVariantListCopier.copyToBuilder(this.variants);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setVariants(Collection<PromptVariant.BuilderImpl> variants) {
            this.variants = PromptVariantListCopier.copyFromBuilder(variants);
        }

        @Override
        public final Builder variants(Collection<PromptVariant> variants) {
            this.variants = PromptVariantListCopier.copy(variants);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder variants(PromptVariant ... variants) {
            this.variants(Arrays.asList(variants));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder variants(Consumer<PromptVariant.Builder> ... variants) {
            this.variants(Stream.of(variants).map(c -> (PromptVariant)((PromptVariant.Builder)PromptVariant.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getVersion() {
            return this.version;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        @Override
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        @Override
        public UpdatePromptResponse build() {
            return new UpdatePromptResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends BedrockAgentResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdatePromptResponse> {
        public Builder arn(String var1);

        public Builder createdAt(Instant var1);

        public Builder customerEncryptionKeyArn(String var1);

        public Builder defaultVariant(String var1);

        public Builder description(String var1);

        public Builder id(String var1);

        public Builder name(String var1);

        public Builder updatedAt(Instant var1);

        public Builder variants(Collection<PromptVariant> var1);

        public Builder variants(PromptVariant ... var1);

        public Builder variants(Consumer<PromptVariant.Builder> ... var1);

        public Builder version(String var1);
    }
}

