/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagent.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.bedrockagent.model.FilterListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PatternObjectFilter
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PatternObjectFilter> {
    private static final SdkField<List<String>> EXCLUSION_FILTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("exclusionFilters").getter(PatternObjectFilter.getter(PatternObjectFilter::exclusionFilters)).setter(PatternObjectFilter.setter(Builder::exclusionFilters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("exclusionFilters").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> INCLUSION_FILTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("inclusionFilters").getter(PatternObjectFilter.getter(PatternObjectFilter::inclusionFilters)).setter(PatternObjectFilter.setter(Builder::inclusionFilters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inclusionFilters").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> OBJECT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("objectType").getter(PatternObjectFilter.getter(PatternObjectFilter::objectType)).setter(PatternObjectFilter.setter(Builder::objectType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("objectType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXCLUSION_FILTERS_FIELD, INCLUSION_FILTERS_FIELD, OBJECT_TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = PatternObjectFilter.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<String> exclusionFilters;
    private final List<String> inclusionFilters;
    private final String objectType;

    private PatternObjectFilter(BuilderImpl builder) {
        this.exclusionFilters = builder.exclusionFilters;
        this.inclusionFilters = builder.inclusionFilters;
        this.objectType = builder.objectType;
    }

    public final boolean hasExclusionFilters() {
        return this.exclusionFilters != null && !(this.exclusionFilters instanceof SdkAutoConstructList);
    }

    public final List<String> exclusionFilters() {
        return this.exclusionFilters;
    }

    public final boolean hasInclusionFilters() {
        return this.inclusionFilters != null && !(this.inclusionFilters instanceof SdkAutoConstructList);
    }

    public final List<String> inclusionFilters() {
        return this.inclusionFilters;
    }

    public final String objectType() {
        return this.objectType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasExclusionFilters() ? this.exclusionFilters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInclusionFilters() ? this.inclusionFilters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.objectType());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PatternObjectFilter)) {
            return false;
        }
        PatternObjectFilter other = (PatternObjectFilter)obj;
        return this.hasExclusionFilters() == other.hasExclusionFilters() && Objects.equals(this.exclusionFilters(), other.exclusionFilters()) && this.hasInclusionFilters() == other.hasInclusionFilters() && Objects.equals(this.inclusionFilters(), other.inclusionFilters()) && Objects.equals(this.objectType(), other.objectType());
    }

    public final String toString() {
        return ToString.builder((String)"PatternObjectFilter").add("ExclusionFilters", (Object)(this.exclusionFilters() == null ? null : "*** Sensitive Data Redacted ***")).add("InclusionFilters", (Object)(this.inclusionFilters() == null ? null : "*** Sensitive Data Redacted ***")).add("ObjectType", (Object)(this.objectType() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "exclusionFilters": {
                return Optional.ofNullable(clazz.cast(this.exclusionFilters()));
            }
            case "inclusionFilters": {
                return Optional.ofNullable(clazz.cast(this.inclusionFilters()));
            }
            case "objectType": {
                return Optional.ofNullable(clazz.cast(this.objectType()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("exclusionFilters", EXCLUSION_FILTERS_FIELD);
        map.put("inclusionFilters", INCLUSION_FILTERS_FIELD);
        map.put("objectType", OBJECT_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PatternObjectFilter, T> g) {
        return obj -> g.apply((PatternObjectFilter)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> exclusionFilters = DefaultSdkAutoConstructList.getInstance();
        private List<String> inclusionFilters = DefaultSdkAutoConstructList.getInstance();
        private String objectType;

        private BuilderImpl() {
        }

        private BuilderImpl(PatternObjectFilter model) {
            this.exclusionFilters(model.exclusionFilters);
            this.inclusionFilters(model.inclusionFilters);
            this.objectType(model.objectType);
        }

        public final Collection<String> getExclusionFilters() {
            if (this.exclusionFilters instanceof SdkAutoConstructList) {
                return null;
            }
            return this.exclusionFilters;
        }

        public final void setExclusionFilters(Collection<String> exclusionFilters) {
            this.exclusionFilters = FilterListCopier.copy(exclusionFilters);
        }

        @Override
        public final Builder exclusionFilters(Collection<String> exclusionFilters) {
            this.exclusionFilters = FilterListCopier.copy(exclusionFilters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder exclusionFilters(String ... exclusionFilters) {
            this.exclusionFilters(Arrays.asList(exclusionFilters));
            return this;
        }

        public final Collection<String> getInclusionFilters() {
            if (this.inclusionFilters instanceof SdkAutoConstructList) {
                return null;
            }
            return this.inclusionFilters;
        }

        public final void setInclusionFilters(Collection<String> inclusionFilters) {
            this.inclusionFilters = FilterListCopier.copy(inclusionFilters);
        }

        @Override
        public final Builder inclusionFilters(Collection<String> inclusionFilters) {
            this.inclusionFilters = FilterListCopier.copy(inclusionFilters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inclusionFilters(String ... inclusionFilters) {
            this.inclusionFilters(Arrays.asList(inclusionFilters));
            return this;
        }

        public final String getObjectType() {
            return this.objectType;
        }

        public final void setObjectType(String objectType) {
            this.objectType = objectType;
        }

        @Override
        public final Builder objectType(String objectType) {
            this.objectType = objectType;
            return this;
        }

        public PatternObjectFilter build() {
            return new PatternObjectFilter(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PatternObjectFilter> {
        public Builder exclusionFilters(Collection<String> var1);

        public Builder exclusionFilters(String ... var1);

        public Builder inclusionFilters(Collection<String> var1);

        public Builder inclusionFilters(String ... var1);

        public Builder objectType(String var1);
    }
}

