/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagent.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ContentDataSourceType {
    CUSTOM("CUSTOM"),
    S3("S3"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ContentDataSourceType> VALUE_MAP;
    private final String value;

    private ContentDataSourceType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ContentDataSourceType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ContentDataSourceType> knownValues() {
        EnumSet<ContentDataSourceType> knownValues = EnumSet.allOf(ContentDataSourceType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ContentDataSourceType.class, ContentDataSourceType::toString);
    }
}

