/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagent.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.bedrockagent.model.PromptInputVariable;
import software.amazon.awssdk.services.bedrockagent.model.PromptInputVariablesListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TextPromptTemplateConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TextPromptTemplateConfiguration> {
    private static final SdkField<List<PromptInputVariable>> INPUT_VARIABLES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("inputVariables").getter(TextPromptTemplateConfiguration.getter(TextPromptTemplateConfiguration::inputVariables)).setter(TextPromptTemplateConfiguration.setter(Builder::inputVariables)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputVariables").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PromptInputVariable::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> TEXT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("text").getter(TextPromptTemplateConfiguration.getter(TextPromptTemplateConfiguration::text)).setter(TextPromptTemplateConfiguration.setter(Builder::text)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("text").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INPUT_VARIABLES_FIELD, TEXT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = TextPromptTemplateConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<PromptInputVariable> inputVariables;
    private final String text;

    private TextPromptTemplateConfiguration(BuilderImpl builder) {
        this.inputVariables = builder.inputVariables;
        this.text = builder.text;
    }

    public final boolean hasInputVariables() {
        return this.inputVariables != null && !(this.inputVariables instanceof SdkAutoConstructList);
    }

    public final List<PromptInputVariable> inputVariables() {
        return this.inputVariables;
    }

    public final String text() {
        return this.text;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInputVariables() ? this.inputVariables() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.text());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TextPromptTemplateConfiguration)) {
            return false;
        }
        TextPromptTemplateConfiguration other = (TextPromptTemplateConfiguration)obj;
        return this.hasInputVariables() == other.hasInputVariables() && Objects.equals(this.inputVariables(), other.inputVariables()) && Objects.equals(this.text(), other.text());
    }

    public final String toString() {
        return ToString.builder((String)"TextPromptTemplateConfiguration").add("InputVariables", (Object)(this.inputVariables() == null ? null : "*** Sensitive Data Redacted ***")).add("Text", (Object)(this.text() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "inputVariables": {
                return Optional.ofNullable(clazz.cast(this.inputVariables()));
            }
            case "text": {
                return Optional.ofNullable(clazz.cast(this.text()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("inputVariables", INPUT_VARIABLES_FIELD);
        map.put("text", TEXT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TextPromptTemplateConfiguration, T> g) {
        return obj -> g.apply((TextPromptTemplateConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<PromptInputVariable> inputVariables = DefaultSdkAutoConstructList.getInstance();
        private String text;

        private BuilderImpl() {
        }

        private BuilderImpl(TextPromptTemplateConfiguration model) {
            this.inputVariables(model.inputVariables);
            this.text(model.text);
        }

        public final List<PromptInputVariable.Builder> getInputVariables() {
            List<PromptInputVariable.Builder> result = PromptInputVariablesListCopier.copyToBuilder(this.inputVariables);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setInputVariables(Collection<PromptInputVariable.BuilderImpl> inputVariables) {
            this.inputVariables = PromptInputVariablesListCopier.copyFromBuilder(inputVariables);
        }

        @Override
        public final Builder inputVariables(Collection<PromptInputVariable> inputVariables) {
            this.inputVariables = PromptInputVariablesListCopier.copy(inputVariables);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputVariables(PromptInputVariable ... inputVariables) {
            this.inputVariables(Arrays.asList(inputVariables));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputVariables(Consumer<PromptInputVariable.Builder> ... inputVariables) {
            this.inputVariables(Stream.of(inputVariables).map(c -> (PromptInputVariable)((PromptInputVariable.Builder)PromptInputVariable.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getText() {
            return this.text;
        }

        public final void setText(String text) {
            this.text = text;
        }

        @Override
        public final Builder text(String text) {
            this.text = text;
            return this;
        }

        public TextPromptTemplateConfiguration build() {
            return new TextPromptTemplateConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TextPromptTemplateConfiguration> {
        public Builder inputVariables(Collection<PromptInputVariable> var1);

        public Builder inputVariables(PromptInputVariable ... var1);

        public Builder inputVariables(Consumer<PromptInputVariable.Builder> ... var1);

        public Builder text(String var1);
    }
}

