/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagent.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.bedrockagent.model.BedrockAgentRequest;
import software.amazon.awssdk.services.bedrockagent.model.PromptVariant;
import software.amazon.awssdk.services.bedrockagent.model.PromptVariantListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdatePromptRequest
extends BedrockAgentRequest
implements ToCopyableBuilder<Builder, UpdatePromptRequest> {
    private static final SdkField<String> CUSTOMER_ENCRYPTION_KEY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("customerEncryptionKeyArn").getter(UpdatePromptRequest.getter(UpdatePromptRequest::customerEncryptionKeyArn)).setter(UpdatePromptRequest.setter(Builder::customerEncryptionKeyArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customerEncryptionKeyArn").build()}).build();
    private static final SdkField<String> DEFAULT_VARIANT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("defaultVariant").getter(UpdatePromptRequest.getter(UpdatePromptRequest::defaultVariant)).setter(UpdatePromptRequest.setter(Builder::defaultVariant)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("defaultVariant").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(UpdatePromptRequest.getter(UpdatePromptRequest::description)).setter(UpdatePromptRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(UpdatePromptRequest.getter(UpdatePromptRequest::name)).setter(UpdatePromptRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> PROMPT_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("promptIdentifier").getter(UpdatePromptRequest.getter(UpdatePromptRequest::promptIdentifier)).setter(UpdatePromptRequest.setter(Builder::promptIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("promptIdentifier").build()}).build();
    private static final SdkField<List<PromptVariant>> VARIANTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("variants").getter(UpdatePromptRequest.getter(UpdatePromptRequest::variants)).setter(UpdatePromptRequest.setter(Builder::variants)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("variants").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PromptVariant::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CUSTOMER_ENCRYPTION_KEY_ARN_FIELD, DEFAULT_VARIANT_FIELD, DESCRIPTION_FIELD, NAME_FIELD, PROMPT_IDENTIFIER_FIELD, VARIANTS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("customerEncryptionKeyArn", CUSTOMER_ENCRYPTION_KEY_ARN_FIELD);
            this.put("defaultVariant", DEFAULT_VARIANT_FIELD);
            this.put("description", DESCRIPTION_FIELD);
            this.put("name", NAME_FIELD);
            this.put("promptIdentifier", PROMPT_IDENTIFIER_FIELD);
            this.put("variants", VARIANTS_FIELD);
        }
    });
    private final String customerEncryptionKeyArn;
    private final String defaultVariant;
    private final String description;
    private final String name;
    private final String promptIdentifier;
    private final List<PromptVariant> variants;

    private UpdatePromptRequest(BuilderImpl builder) {
        super(builder);
        this.customerEncryptionKeyArn = builder.customerEncryptionKeyArn;
        this.defaultVariant = builder.defaultVariant;
        this.description = builder.description;
        this.name = builder.name;
        this.promptIdentifier = builder.promptIdentifier;
        this.variants = builder.variants;
    }

    public final String customerEncryptionKeyArn() {
        return this.customerEncryptionKeyArn;
    }

    public final String defaultVariant() {
        return this.defaultVariant;
    }

    public final String description() {
        return this.description;
    }

    public final String name() {
        return this.name;
    }

    public final String promptIdentifier() {
        return this.promptIdentifier;
    }

    public final boolean hasVariants() {
        return this.variants != null && !(this.variants instanceof SdkAutoConstructList);
    }

    public final List<PromptVariant> variants() {
        return this.variants;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.customerEncryptionKeyArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultVariant());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.promptIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasVariants() ? this.variants() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdatePromptRequest)) {
            return false;
        }
        UpdatePromptRequest other = (UpdatePromptRequest)((Object)obj);
        return Objects.equals(this.customerEncryptionKeyArn(), other.customerEncryptionKeyArn()) && Objects.equals(this.defaultVariant(), other.defaultVariant()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.promptIdentifier(), other.promptIdentifier()) && this.hasVariants() == other.hasVariants() && Objects.equals(this.variants(), other.variants());
    }

    public final String toString() {
        return ToString.builder((String)"UpdatePromptRequest").add("CustomerEncryptionKeyArn", (Object)this.customerEncryptionKeyArn()).add("DefaultVariant", (Object)this.defaultVariant()).add("Description", (Object)this.description()).add("Name", (Object)this.name()).add("PromptIdentifier", (Object)this.promptIdentifier()).add("Variants", (Object)(this.variants() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "customerEncryptionKeyArn": {
                return Optional.ofNullable(clazz.cast(this.customerEncryptionKeyArn()));
            }
            case "defaultVariant": {
                return Optional.ofNullable(clazz.cast(this.defaultVariant()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "promptIdentifier": {
                return Optional.ofNullable(clazz.cast(this.promptIdentifier()));
            }
            case "variants": {
                return Optional.ofNullable(clazz.cast(this.variants()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<UpdatePromptRequest, T> g) {
        return obj -> g.apply((UpdatePromptRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BedrockAgentRequest.BuilderImpl
    implements Builder {
        private String customerEncryptionKeyArn;
        private String defaultVariant;
        private String description;
        private String name;
        private String promptIdentifier;
        private List<PromptVariant> variants = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdatePromptRequest model) {
            super(model);
            this.customerEncryptionKeyArn(model.customerEncryptionKeyArn);
            this.defaultVariant(model.defaultVariant);
            this.description(model.description);
            this.name(model.name);
            this.promptIdentifier(model.promptIdentifier);
            this.variants(model.variants);
        }

        public final String getCustomerEncryptionKeyArn() {
            return this.customerEncryptionKeyArn;
        }

        public final void setCustomerEncryptionKeyArn(String customerEncryptionKeyArn) {
            this.customerEncryptionKeyArn = customerEncryptionKeyArn;
        }

        @Override
        public final Builder customerEncryptionKeyArn(String customerEncryptionKeyArn) {
            this.customerEncryptionKeyArn = customerEncryptionKeyArn;
            return this;
        }

        public final String getDefaultVariant() {
            return this.defaultVariant;
        }

        public final void setDefaultVariant(String defaultVariant) {
            this.defaultVariant = defaultVariant;
        }

        @Override
        public final Builder defaultVariant(String defaultVariant) {
            this.defaultVariant = defaultVariant;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getPromptIdentifier() {
            return this.promptIdentifier;
        }

        public final void setPromptIdentifier(String promptIdentifier) {
            this.promptIdentifier = promptIdentifier;
        }

        @Override
        public final Builder promptIdentifier(String promptIdentifier) {
            this.promptIdentifier = promptIdentifier;
            return this;
        }

        public final List<PromptVariant.Builder> getVariants() {
            List<PromptVariant.Builder> result = PromptVariantListCopier.copyToBuilder(this.variants);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setVariants(Collection<PromptVariant.BuilderImpl> variants) {
            this.variants = PromptVariantListCopier.copyFromBuilder(variants);
        }

        @Override
        public final Builder variants(Collection<PromptVariant> variants) {
            this.variants = PromptVariantListCopier.copy(variants);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder variants(PromptVariant ... variants) {
            this.variants(Arrays.asList(variants));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder variants(Consumer<PromptVariant.Builder> ... variants) {
            this.variants(Stream.of(variants).map(c -> (PromptVariant)((PromptVariant.Builder)PromptVariant.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdatePromptRequest build() {
            return new UpdatePromptRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends BedrockAgentRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdatePromptRequest> {
        public Builder customerEncryptionKeyArn(String var1);

        public Builder defaultVariant(String var1);

        public Builder description(String var1);

        public Builder name(String var1);

        public Builder promptIdentifier(String var1);

        public Builder variants(Collection<PromptVariant> var1);

        public Builder variants(PromptVariant ... var1);

        public Builder variants(Consumer<PromptVariant.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

