/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagent.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.bedrockagent.model.IncludeExclude;
import software.amazon.awssdk.services.bedrockagent.model.QueryGenerationColumn;
import software.amazon.awssdk.services.bedrockagent.model.QueryGenerationColumnsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class QueryGenerationTable
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, QueryGenerationTable> {
    private static final SdkField<List<QueryGenerationColumn>> COLUMNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("columns").getter(QueryGenerationTable.getter(QueryGenerationTable::columns)).setter(QueryGenerationTable.setter(Builder::columns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("columns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(QueryGenerationColumn::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(QueryGenerationTable.getter(QueryGenerationTable::description)).setter(QueryGenerationTable.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> INCLUSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("inclusion").getter(QueryGenerationTable.getter(QueryGenerationTable::inclusionAsString)).setter(QueryGenerationTable.setter(Builder::inclusion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inclusion").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(QueryGenerationTable.getter(QueryGenerationTable::name)).setter(QueryGenerationTable.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COLUMNS_FIELD, DESCRIPTION_FIELD, INCLUSION_FIELD, NAME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("columns", COLUMNS_FIELD);
            this.put("description", DESCRIPTION_FIELD);
            this.put("inclusion", INCLUSION_FIELD);
            this.put("name", NAME_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final List<QueryGenerationColumn> columns;
    private final String description;
    private final String inclusion;
    private final String name;

    private QueryGenerationTable(BuilderImpl builder) {
        this.columns = builder.columns;
        this.description = builder.description;
        this.inclusion = builder.inclusion;
        this.name = builder.name;
    }

    public final boolean hasColumns() {
        return this.columns != null && !(this.columns instanceof SdkAutoConstructList);
    }

    public final List<QueryGenerationColumn> columns() {
        return this.columns;
    }

    public final String description() {
        return this.description;
    }

    public final IncludeExclude inclusion() {
        return IncludeExclude.fromValue(this.inclusion);
    }

    public final String inclusionAsString() {
        return this.inclusion;
    }

    public final String name() {
        return this.name;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasColumns() ? this.columns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.inclusionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof QueryGenerationTable)) {
            return false;
        }
        QueryGenerationTable other = (QueryGenerationTable)obj;
        return this.hasColumns() == other.hasColumns() && Objects.equals(this.columns(), other.columns()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.inclusionAsString(), other.inclusionAsString()) && Objects.equals(this.name(), other.name());
    }

    public final String toString() {
        return ToString.builder((String)"QueryGenerationTable").add("Columns", this.hasColumns() ? this.columns() : null).add("Description", (Object)this.description()).add("Inclusion", (Object)this.inclusionAsString()).add("Name", (Object)this.name()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "columns": {
                return Optional.ofNullable(clazz.cast(this.columns()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "inclusion": {
                return Optional.ofNullable(clazz.cast(this.inclusionAsString()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<QueryGenerationTable, T> g) {
        return obj -> g.apply((QueryGenerationTable)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<QueryGenerationColumn> columns = DefaultSdkAutoConstructList.getInstance();
        private String description;
        private String inclusion;
        private String name;

        private BuilderImpl() {
        }

        private BuilderImpl(QueryGenerationTable model) {
            this.columns(model.columns);
            this.description(model.description);
            this.inclusion(model.inclusion);
            this.name(model.name);
        }

        public final List<QueryGenerationColumn.Builder> getColumns() {
            List<QueryGenerationColumn.Builder> result = QueryGenerationColumnsCopier.copyToBuilder(this.columns);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setColumns(Collection<QueryGenerationColumn.BuilderImpl> columns) {
            this.columns = QueryGenerationColumnsCopier.copyFromBuilder(columns);
        }

        @Override
        public final Builder columns(Collection<QueryGenerationColumn> columns) {
            this.columns = QueryGenerationColumnsCopier.copy(columns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder columns(QueryGenerationColumn ... columns) {
            this.columns(Arrays.asList(columns));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder columns(Consumer<QueryGenerationColumn.Builder> ... columns) {
            this.columns(Stream.of(columns).map(c -> (QueryGenerationColumn)((QueryGenerationColumn.Builder)QueryGenerationColumn.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getInclusion() {
            return this.inclusion;
        }

        public final void setInclusion(String inclusion) {
            this.inclusion = inclusion;
        }

        @Override
        public final Builder inclusion(String inclusion) {
            this.inclusion = inclusion;
            return this;
        }

        @Override
        public final Builder inclusion(IncludeExclude inclusion) {
            this.inclusion(inclusion == null ? null : inclusion.toString());
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public QueryGenerationTable build() {
            return new QueryGenerationTable(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, QueryGenerationTable> {
        public Builder columns(Collection<QueryGenerationColumn> var1);

        public Builder columns(QueryGenerationColumn ... var1);

        public Builder columns(Consumer<QueryGenerationColumn.Builder> ... var1);

        public Builder description(String var1);

        public Builder inclusion(String var1);

        public Builder inclusion(IncludeExclude var1);

        public Builder name(String var1);
    }
}

