/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagent.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.bedrockagent.model.EmbeddingModelConfiguration;
import software.amazon.awssdk.services.bedrockagent.model.SupplementalDataStorageConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class VectorKnowledgeBaseConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, VectorKnowledgeBaseConfiguration> {
    private static final SdkField<String> EMBEDDING_MODEL_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("embeddingModelArn").getter(VectorKnowledgeBaseConfiguration.getter(VectorKnowledgeBaseConfiguration::embeddingModelArn)).setter(VectorKnowledgeBaseConfiguration.setter(Builder::embeddingModelArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("embeddingModelArn").build()}).build();
    private static final SdkField<EmbeddingModelConfiguration> EMBEDDING_MODEL_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("embeddingModelConfiguration").getter(VectorKnowledgeBaseConfiguration.getter(VectorKnowledgeBaseConfiguration::embeddingModelConfiguration)).setter(VectorKnowledgeBaseConfiguration.setter(Builder::embeddingModelConfiguration)).constructor(EmbeddingModelConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("embeddingModelConfiguration").build()}).build();
    private static final SdkField<SupplementalDataStorageConfiguration> SUPPLEMENTAL_DATA_STORAGE_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("supplementalDataStorageConfiguration").getter(VectorKnowledgeBaseConfiguration.getter(VectorKnowledgeBaseConfiguration::supplementalDataStorageConfiguration)).setter(VectorKnowledgeBaseConfiguration.setter(Builder::supplementalDataStorageConfiguration)).constructor(SupplementalDataStorageConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("supplementalDataStorageConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EMBEDDING_MODEL_ARN_FIELD, EMBEDDING_MODEL_CONFIGURATION_FIELD, SUPPLEMENTAL_DATA_STORAGE_CONFIGURATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("embeddingModelArn", EMBEDDING_MODEL_ARN_FIELD);
            this.put("embeddingModelConfiguration", EMBEDDING_MODEL_CONFIGURATION_FIELD);
            this.put("supplementalDataStorageConfiguration", SUPPLEMENTAL_DATA_STORAGE_CONFIGURATION_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String embeddingModelArn;
    private final EmbeddingModelConfiguration embeddingModelConfiguration;
    private final SupplementalDataStorageConfiguration supplementalDataStorageConfiguration;

    private VectorKnowledgeBaseConfiguration(BuilderImpl builder) {
        this.embeddingModelArn = builder.embeddingModelArn;
        this.embeddingModelConfiguration = builder.embeddingModelConfiguration;
        this.supplementalDataStorageConfiguration = builder.supplementalDataStorageConfiguration;
    }

    public final String embeddingModelArn() {
        return this.embeddingModelArn;
    }

    public final EmbeddingModelConfiguration embeddingModelConfiguration() {
        return this.embeddingModelConfiguration;
    }

    public final SupplementalDataStorageConfiguration supplementalDataStorageConfiguration() {
        return this.supplementalDataStorageConfiguration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.embeddingModelArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.embeddingModelConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.supplementalDataStorageConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VectorKnowledgeBaseConfiguration)) {
            return false;
        }
        VectorKnowledgeBaseConfiguration other = (VectorKnowledgeBaseConfiguration)obj;
        return Objects.equals(this.embeddingModelArn(), other.embeddingModelArn()) && Objects.equals(this.embeddingModelConfiguration(), other.embeddingModelConfiguration()) && Objects.equals(this.supplementalDataStorageConfiguration(), other.supplementalDataStorageConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"VectorKnowledgeBaseConfiguration").add("EmbeddingModelArn", (Object)this.embeddingModelArn()).add("EmbeddingModelConfiguration", (Object)this.embeddingModelConfiguration()).add("SupplementalDataStorageConfiguration", (Object)this.supplementalDataStorageConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "embeddingModelArn": {
                return Optional.ofNullable(clazz.cast(this.embeddingModelArn()));
            }
            case "embeddingModelConfiguration": {
                return Optional.ofNullable(clazz.cast(this.embeddingModelConfiguration()));
            }
            case "supplementalDataStorageConfiguration": {
                return Optional.ofNullable(clazz.cast(this.supplementalDataStorageConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<VectorKnowledgeBaseConfiguration, T> g) {
        return obj -> g.apply((VectorKnowledgeBaseConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String embeddingModelArn;
        private EmbeddingModelConfiguration embeddingModelConfiguration;
        private SupplementalDataStorageConfiguration supplementalDataStorageConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(VectorKnowledgeBaseConfiguration model) {
            this.embeddingModelArn(model.embeddingModelArn);
            this.embeddingModelConfiguration(model.embeddingModelConfiguration);
            this.supplementalDataStorageConfiguration(model.supplementalDataStorageConfiguration);
        }

        public final String getEmbeddingModelArn() {
            return this.embeddingModelArn;
        }

        public final void setEmbeddingModelArn(String embeddingModelArn) {
            this.embeddingModelArn = embeddingModelArn;
        }

        @Override
        public final Builder embeddingModelArn(String embeddingModelArn) {
            this.embeddingModelArn = embeddingModelArn;
            return this;
        }

        public final EmbeddingModelConfiguration.Builder getEmbeddingModelConfiguration() {
            return this.embeddingModelConfiguration != null ? this.embeddingModelConfiguration.toBuilder() : null;
        }

        public final void setEmbeddingModelConfiguration(EmbeddingModelConfiguration.BuilderImpl embeddingModelConfiguration) {
            this.embeddingModelConfiguration = embeddingModelConfiguration != null ? embeddingModelConfiguration.build() : null;
        }

        @Override
        public final Builder embeddingModelConfiguration(EmbeddingModelConfiguration embeddingModelConfiguration) {
            this.embeddingModelConfiguration = embeddingModelConfiguration;
            return this;
        }

        public final SupplementalDataStorageConfiguration.Builder getSupplementalDataStorageConfiguration() {
            return this.supplementalDataStorageConfiguration != null ? this.supplementalDataStorageConfiguration.toBuilder() : null;
        }

        public final void setSupplementalDataStorageConfiguration(SupplementalDataStorageConfiguration.BuilderImpl supplementalDataStorageConfiguration) {
            this.supplementalDataStorageConfiguration = supplementalDataStorageConfiguration != null ? supplementalDataStorageConfiguration.build() : null;
        }

        @Override
        public final Builder supplementalDataStorageConfiguration(SupplementalDataStorageConfiguration supplementalDataStorageConfiguration) {
            this.supplementalDataStorageConfiguration = supplementalDataStorageConfiguration;
            return this;
        }

        public VectorKnowledgeBaseConfiguration build() {
            return new VectorKnowledgeBaseConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, VectorKnowledgeBaseConfiguration> {
        public Builder embeddingModelArn(String var1);

        public Builder embeddingModelConfiguration(EmbeddingModelConfiguration var1);

        default public Builder embeddingModelConfiguration(Consumer<EmbeddingModelConfiguration.Builder> embeddingModelConfiguration) {
            return this.embeddingModelConfiguration((EmbeddingModelConfiguration)((EmbeddingModelConfiguration.Builder)EmbeddingModelConfiguration.builder().applyMutation(embeddingModelConfiguration)).build());
        }

        public Builder supplementalDataStorageConfiguration(SupplementalDataStorageConfiguration var1);

        default public Builder supplementalDataStorageConfiguration(Consumer<SupplementalDataStorageConfiguration.Builder> supplementalDataStorageConfiguration) {
            return this.supplementalDataStorageConfiguration((SupplementalDataStorageConfiguration)((SupplementalDataStorageConfiguration.Builder)SupplementalDataStorageConfiguration.builder().applyMutation(supplementalDataStorageConfiguration)).build());
        }
    }
}

