/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagent.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.bedrockagent.model.ActionGroupSummariesCopier;
import software.amazon.awssdk.services.bedrockagent.model.ActionGroupSummary;
import software.amazon.awssdk.services.bedrockagent.model.BedrockAgentResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListAgentActionGroupsResponse
extends BedrockAgentResponse
implements ToCopyableBuilder<Builder, ListAgentActionGroupsResponse> {
    private static final SdkField<List<ActionGroupSummary>> ACTION_GROUP_SUMMARIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("actionGroupSummaries").getter(ListAgentActionGroupsResponse.getter(ListAgentActionGroupsResponse::actionGroupSummaries)).setter(ListAgentActionGroupsResponse.setter(Builder::actionGroupSummaries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actionGroupSummaries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ActionGroupSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListAgentActionGroupsResponse.getter(ListAgentActionGroupsResponse::nextToken)).setter(ListAgentActionGroupsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTION_GROUP_SUMMARIES_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("actionGroupSummaries", ACTION_GROUP_SUMMARIES_FIELD);
            this.put("nextToken", NEXT_TOKEN_FIELD);
        }
    });
    private final List<ActionGroupSummary> actionGroupSummaries;
    private final String nextToken;

    private ListAgentActionGroupsResponse(BuilderImpl builder) {
        super(builder);
        this.actionGroupSummaries = builder.actionGroupSummaries;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasActionGroupSummaries() {
        return this.actionGroupSummaries != null && !(this.actionGroupSummaries instanceof SdkAutoConstructList);
    }

    public final List<ActionGroupSummary> actionGroupSummaries() {
        return this.actionGroupSummaries;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasActionGroupSummaries() ? this.actionGroupSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAgentActionGroupsResponse)) {
            return false;
        }
        ListAgentActionGroupsResponse other = (ListAgentActionGroupsResponse)((Object)obj);
        return this.hasActionGroupSummaries() == other.hasActionGroupSummaries() && Objects.equals(this.actionGroupSummaries(), other.actionGroupSummaries()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListAgentActionGroupsResponse").add("ActionGroupSummaries", this.hasActionGroupSummaries() ? this.actionGroupSummaries() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "actionGroupSummaries": {
                return Optional.ofNullable(clazz.cast(this.actionGroupSummaries()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListAgentActionGroupsResponse, T> g) {
        return obj -> g.apply((ListAgentActionGroupsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BedrockAgentResponse.BuilderImpl
    implements Builder {
        private List<ActionGroupSummary> actionGroupSummaries = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAgentActionGroupsResponse model) {
            super(model);
            this.actionGroupSummaries(model.actionGroupSummaries);
            this.nextToken(model.nextToken);
        }

        public final List<ActionGroupSummary.Builder> getActionGroupSummaries() {
            List<ActionGroupSummary.Builder> result = ActionGroupSummariesCopier.copyToBuilder(this.actionGroupSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setActionGroupSummaries(Collection<ActionGroupSummary.BuilderImpl> actionGroupSummaries) {
            this.actionGroupSummaries = ActionGroupSummariesCopier.copyFromBuilder(actionGroupSummaries);
        }

        @Override
        public final Builder actionGroupSummaries(Collection<ActionGroupSummary> actionGroupSummaries) {
            this.actionGroupSummaries = ActionGroupSummariesCopier.copy(actionGroupSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actionGroupSummaries(ActionGroupSummary ... actionGroupSummaries) {
            this.actionGroupSummaries(Arrays.asList(actionGroupSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actionGroupSummaries(Consumer<ActionGroupSummary.Builder> ... actionGroupSummaries) {
            this.actionGroupSummaries(Stream.of(actionGroupSummaries).map(c -> (ActionGroupSummary)((ActionGroupSummary.Builder)ActionGroupSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListAgentActionGroupsResponse build() {
            return new ListAgentActionGroupsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends BedrockAgentResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListAgentActionGroupsResponse> {
        public Builder actionGroupSummaries(Collection<ActionGroupSummary> var1);

        public Builder actionGroupSummaries(ActionGroupSummary ... var1);

        public Builder actionGroupSummaries(Consumer<ActionGroupSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

