/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagent.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.bedrockagent.model.MetadataAttributeValueStringListValueListCopier;
import software.amazon.awssdk.services.bedrockagent.model.MetadataValueType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MetadataAttributeValue
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MetadataAttributeValue> {
    private static final SdkField<Boolean> BOOLEAN_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("booleanValue").getter(MetadataAttributeValue.getter(MetadataAttributeValue::booleanValue)).setter(MetadataAttributeValue.setter(Builder::booleanValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("booleanValue").build()}).build();
    private static final SdkField<Double> NUMBER_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("numberValue").getter(MetadataAttributeValue.getter(MetadataAttributeValue::numberValue)).setter(MetadataAttributeValue.setter(Builder::numberValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("numberValue").build()}).build();
    private static final SdkField<List<String>> STRING_LIST_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("stringListValue").getter(MetadataAttributeValue.getter(MetadataAttributeValue::stringListValue)).setter(MetadataAttributeValue.setter(Builder::stringListValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stringListValue").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> STRING_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("stringValue").getter(MetadataAttributeValue.getter(MetadataAttributeValue::stringValue)).setter(MetadataAttributeValue.setter(Builder::stringValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stringValue").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("type").getter(MetadataAttributeValue.getter(MetadataAttributeValue::typeAsString)).setter(MetadataAttributeValue.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BOOLEAN_VALUE_FIELD, NUMBER_VALUE_FIELD, STRING_LIST_VALUE_FIELD, STRING_VALUE_FIELD, TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("booleanValue", BOOLEAN_VALUE_FIELD);
            this.put("numberValue", NUMBER_VALUE_FIELD);
            this.put("stringListValue", STRING_LIST_VALUE_FIELD);
            this.put("stringValue", STRING_VALUE_FIELD);
            this.put("type", TYPE_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final Boolean booleanValue;
    private final Double numberValue;
    private final List<String> stringListValue;
    private final String stringValue;
    private final String type;

    private MetadataAttributeValue(BuilderImpl builder) {
        this.booleanValue = builder.booleanValue;
        this.numberValue = builder.numberValue;
        this.stringListValue = builder.stringListValue;
        this.stringValue = builder.stringValue;
        this.type = builder.type;
    }

    public final Boolean booleanValue() {
        return this.booleanValue;
    }

    public final Double numberValue() {
        return this.numberValue;
    }

    public final boolean hasStringListValue() {
        return this.stringListValue != null && !(this.stringListValue instanceof SdkAutoConstructList);
    }

    public final List<String> stringListValue() {
        return this.stringListValue;
    }

    public final String stringValue() {
        return this.stringValue;
    }

    public final MetadataValueType type() {
        return MetadataValueType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.booleanValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.numberValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasStringListValue() ? this.stringListValue() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.stringValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MetadataAttributeValue)) {
            return false;
        }
        MetadataAttributeValue other = (MetadataAttributeValue)obj;
        return Objects.equals(this.booleanValue(), other.booleanValue()) && Objects.equals(this.numberValue(), other.numberValue()) && this.hasStringListValue() == other.hasStringListValue() && Objects.equals(this.stringListValue(), other.stringListValue()) && Objects.equals(this.stringValue(), other.stringValue()) && Objects.equals(this.typeAsString(), other.typeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"MetadataAttributeValue").add("BooleanValue", (Object)this.booleanValue()).add("NumberValue", (Object)(this.numberValue() == null ? null : "*** Sensitive Data Redacted ***")).add("StringListValue", (Object)(this.stringListValue() == null ? null : "*** Sensitive Data Redacted ***")).add("StringValue", (Object)(this.stringValue() == null ? null : "*** Sensitive Data Redacted ***")).add("Type", (Object)this.typeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "booleanValue": {
                return Optional.ofNullable(clazz.cast(this.booleanValue()));
            }
            case "numberValue": {
                return Optional.ofNullable(clazz.cast(this.numberValue()));
            }
            case "stringListValue": {
                return Optional.ofNullable(clazz.cast(this.stringListValue()));
            }
            case "stringValue": {
                return Optional.ofNullable(clazz.cast(this.stringValue()));
            }
            case "type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<MetadataAttributeValue, T> g) {
        return obj -> g.apply((MetadataAttributeValue)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Boolean booleanValue;
        private Double numberValue;
        private List<String> stringListValue = DefaultSdkAutoConstructList.getInstance();
        private String stringValue;
        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(MetadataAttributeValue model) {
            this.booleanValue(model.booleanValue);
            this.numberValue(model.numberValue);
            this.stringListValue(model.stringListValue);
            this.stringValue(model.stringValue);
            this.type(model.type);
        }

        public final Boolean getBooleanValue() {
            return this.booleanValue;
        }

        public final void setBooleanValue(Boolean booleanValue) {
            this.booleanValue = booleanValue;
        }

        @Override
        public final Builder booleanValue(Boolean booleanValue) {
            this.booleanValue = booleanValue;
            return this;
        }

        public final Double getNumberValue() {
            return this.numberValue;
        }

        public final void setNumberValue(Double numberValue) {
            this.numberValue = numberValue;
        }

        @Override
        public final Builder numberValue(Double numberValue) {
            this.numberValue = numberValue;
            return this;
        }

        public final Collection<String> getStringListValue() {
            if (this.stringListValue instanceof SdkAutoConstructList) {
                return null;
            }
            return this.stringListValue;
        }

        public final void setStringListValue(Collection<String> stringListValue) {
            this.stringListValue = MetadataAttributeValueStringListValueListCopier.copy(stringListValue);
        }

        @Override
        public final Builder stringListValue(Collection<String> stringListValue) {
            this.stringListValue = MetadataAttributeValueStringListValueListCopier.copy(stringListValue);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stringListValue(String ... stringListValue) {
            this.stringListValue(Arrays.asList(stringListValue));
            return this;
        }

        public final String getStringValue() {
            return this.stringValue;
        }

        public final void setStringValue(String stringValue) {
            this.stringValue = stringValue;
        }

        @Override
        public final Builder stringValue(String stringValue) {
            this.stringValue = stringValue;
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(MetadataValueType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public MetadataAttributeValue build() {
            return new MetadataAttributeValue(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MetadataAttributeValue> {
        public Builder booleanValue(Boolean var1);

        public Builder numberValue(Double var1);

        public Builder stringListValue(Collection<String> var1);

        public Builder stringListValue(String ... var1);

        public Builder stringValue(String var1);

        public Builder type(String var1);

        public Builder type(MetadataValueType var1);
    }
}

