/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagent.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class IngestionJobStatistics
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, IngestionJobStatistics> {
    private static final SdkField<Long> NUMBER_OF_DOCUMENTS_DELETED_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("numberOfDocumentsDeleted").getter(IngestionJobStatistics.getter(IngestionJobStatistics::numberOfDocumentsDeleted)).setter(IngestionJobStatistics.setter(Builder::numberOfDocumentsDeleted)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("numberOfDocumentsDeleted").build()}).build();
    private static final SdkField<Long> NUMBER_OF_DOCUMENTS_FAILED_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("numberOfDocumentsFailed").getter(IngestionJobStatistics.getter(IngestionJobStatistics::numberOfDocumentsFailed)).setter(IngestionJobStatistics.setter(Builder::numberOfDocumentsFailed)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("numberOfDocumentsFailed").build()}).build();
    private static final SdkField<Long> NUMBER_OF_DOCUMENTS_SCANNED_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("numberOfDocumentsScanned").getter(IngestionJobStatistics.getter(IngestionJobStatistics::numberOfDocumentsScanned)).setter(IngestionJobStatistics.setter(Builder::numberOfDocumentsScanned)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("numberOfDocumentsScanned").build()}).build();
    private static final SdkField<Long> NUMBER_OF_METADATA_DOCUMENTS_MODIFIED_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("numberOfMetadataDocumentsModified").getter(IngestionJobStatistics.getter(IngestionJobStatistics::numberOfMetadataDocumentsModified)).setter(IngestionJobStatistics.setter(Builder::numberOfMetadataDocumentsModified)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("numberOfMetadataDocumentsModified").build()}).build();
    private static final SdkField<Long> NUMBER_OF_METADATA_DOCUMENTS_SCANNED_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("numberOfMetadataDocumentsScanned").getter(IngestionJobStatistics.getter(IngestionJobStatistics::numberOfMetadataDocumentsScanned)).setter(IngestionJobStatistics.setter(Builder::numberOfMetadataDocumentsScanned)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("numberOfMetadataDocumentsScanned").build()}).build();
    private static final SdkField<Long> NUMBER_OF_MODIFIED_DOCUMENTS_INDEXED_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("numberOfModifiedDocumentsIndexed").getter(IngestionJobStatistics.getter(IngestionJobStatistics::numberOfModifiedDocumentsIndexed)).setter(IngestionJobStatistics.setter(Builder::numberOfModifiedDocumentsIndexed)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("numberOfModifiedDocumentsIndexed").build()}).build();
    private static final SdkField<Long> NUMBER_OF_NEW_DOCUMENTS_INDEXED_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("numberOfNewDocumentsIndexed").getter(IngestionJobStatistics.getter(IngestionJobStatistics::numberOfNewDocumentsIndexed)).setter(IngestionJobStatistics.setter(Builder::numberOfNewDocumentsIndexed)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("numberOfNewDocumentsIndexed").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NUMBER_OF_DOCUMENTS_DELETED_FIELD, NUMBER_OF_DOCUMENTS_FAILED_FIELD, NUMBER_OF_DOCUMENTS_SCANNED_FIELD, NUMBER_OF_METADATA_DOCUMENTS_MODIFIED_FIELD, NUMBER_OF_METADATA_DOCUMENTS_SCANNED_FIELD, NUMBER_OF_MODIFIED_DOCUMENTS_INDEXED_FIELD, NUMBER_OF_NEW_DOCUMENTS_INDEXED_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("numberOfDocumentsDeleted", NUMBER_OF_DOCUMENTS_DELETED_FIELD);
            this.put("numberOfDocumentsFailed", NUMBER_OF_DOCUMENTS_FAILED_FIELD);
            this.put("numberOfDocumentsScanned", NUMBER_OF_DOCUMENTS_SCANNED_FIELD);
            this.put("numberOfMetadataDocumentsModified", NUMBER_OF_METADATA_DOCUMENTS_MODIFIED_FIELD);
            this.put("numberOfMetadataDocumentsScanned", NUMBER_OF_METADATA_DOCUMENTS_SCANNED_FIELD);
            this.put("numberOfModifiedDocumentsIndexed", NUMBER_OF_MODIFIED_DOCUMENTS_INDEXED_FIELD);
            this.put("numberOfNewDocumentsIndexed", NUMBER_OF_NEW_DOCUMENTS_INDEXED_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final Long numberOfDocumentsDeleted;
    private final Long numberOfDocumentsFailed;
    private final Long numberOfDocumentsScanned;
    private final Long numberOfMetadataDocumentsModified;
    private final Long numberOfMetadataDocumentsScanned;
    private final Long numberOfModifiedDocumentsIndexed;
    private final Long numberOfNewDocumentsIndexed;

    private IngestionJobStatistics(BuilderImpl builder) {
        this.numberOfDocumentsDeleted = builder.numberOfDocumentsDeleted;
        this.numberOfDocumentsFailed = builder.numberOfDocumentsFailed;
        this.numberOfDocumentsScanned = builder.numberOfDocumentsScanned;
        this.numberOfMetadataDocumentsModified = builder.numberOfMetadataDocumentsModified;
        this.numberOfMetadataDocumentsScanned = builder.numberOfMetadataDocumentsScanned;
        this.numberOfModifiedDocumentsIndexed = builder.numberOfModifiedDocumentsIndexed;
        this.numberOfNewDocumentsIndexed = builder.numberOfNewDocumentsIndexed;
    }

    public final Long numberOfDocumentsDeleted() {
        return this.numberOfDocumentsDeleted;
    }

    public final Long numberOfDocumentsFailed() {
        return this.numberOfDocumentsFailed;
    }

    public final Long numberOfDocumentsScanned() {
        return this.numberOfDocumentsScanned;
    }

    public final Long numberOfMetadataDocumentsModified() {
        return this.numberOfMetadataDocumentsModified;
    }

    public final Long numberOfMetadataDocumentsScanned() {
        return this.numberOfMetadataDocumentsScanned;
    }

    public final Long numberOfModifiedDocumentsIndexed() {
        return this.numberOfModifiedDocumentsIndexed;
    }

    public final Long numberOfNewDocumentsIndexed() {
        return this.numberOfNewDocumentsIndexed;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.numberOfDocumentsDeleted());
        hashCode = 31 * hashCode + Objects.hashCode(this.numberOfDocumentsFailed());
        hashCode = 31 * hashCode + Objects.hashCode(this.numberOfDocumentsScanned());
        hashCode = 31 * hashCode + Objects.hashCode(this.numberOfMetadataDocumentsModified());
        hashCode = 31 * hashCode + Objects.hashCode(this.numberOfMetadataDocumentsScanned());
        hashCode = 31 * hashCode + Objects.hashCode(this.numberOfModifiedDocumentsIndexed());
        hashCode = 31 * hashCode + Objects.hashCode(this.numberOfNewDocumentsIndexed());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IngestionJobStatistics)) {
            return false;
        }
        IngestionJobStatistics other = (IngestionJobStatistics)obj;
        return Objects.equals(this.numberOfDocumentsDeleted(), other.numberOfDocumentsDeleted()) && Objects.equals(this.numberOfDocumentsFailed(), other.numberOfDocumentsFailed()) && Objects.equals(this.numberOfDocumentsScanned(), other.numberOfDocumentsScanned()) && Objects.equals(this.numberOfMetadataDocumentsModified(), other.numberOfMetadataDocumentsModified()) && Objects.equals(this.numberOfMetadataDocumentsScanned(), other.numberOfMetadataDocumentsScanned()) && Objects.equals(this.numberOfModifiedDocumentsIndexed(), other.numberOfModifiedDocumentsIndexed()) && Objects.equals(this.numberOfNewDocumentsIndexed(), other.numberOfNewDocumentsIndexed());
    }

    public final String toString() {
        return ToString.builder((String)"IngestionJobStatistics").add("NumberOfDocumentsDeleted", (Object)this.numberOfDocumentsDeleted()).add("NumberOfDocumentsFailed", (Object)this.numberOfDocumentsFailed()).add("NumberOfDocumentsScanned", (Object)this.numberOfDocumentsScanned()).add("NumberOfMetadataDocumentsModified", (Object)this.numberOfMetadataDocumentsModified()).add("NumberOfMetadataDocumentsScanned", (Object)this.numberOfMetadataDocumentsScanned()).add("NumberOfModifiedDocumentsIndexed", (Object)this.numberOfModifiedDocumentsIndexed()).add("NumberOfNewDocumentsIndexed", (Object)this.numberOfNewDocumentsIndexed()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "numberOfDocumentsDeleted": {
                return Optional.ofNullable(clazz.cast(this.numberOfDocumentsDeleted()));
            }
            case "numberOfDocumentsFailed": {
                return Optional.ofNullable(clazz.cast(this.numberOfDocumentsFailed()));
            }
            case "numberOfDocumentsScanned": {
                return Optional.ofNullable(clazz.cast(this.numberOfDocumentsScanned()));
            }
            case "numberOfMetadataDocumentsModified": {
                return Optional.ofNullable(clazz.cast(this.numberOfMetadataDocumentsModified()));
            }
            case "numberOfMetadataDocumentsScanned": {
                return Optional.ofNullable(clazz.cast(this.numberOfMetadataDocumentsScanned()));
            }
            case "numberOfModifiedDocumentsIndexed": {
                return Optional.ofNullable(clazz.cast(this.numberOfModifiedDocumentsIndexed()));
            }
            case "numberOfNewDocumentsIndexed": {
                return Optional.ofNullable(clazz.cast(this.numberOfNewDocumentsIndexed()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<IngestionJobStatistics, T> g) {
        return obj -> g.apply((IngestionJobStatistics)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Long numberOfDocumentsDeleted;
        private Long numberOfDocumentsFailed;
        private Long numberOfDocumentsScanned;
        private Long numberOfMetadataDocumentsModified;
        private Long numberOfMetadataDocumentsScanned;
        private Long numberOfModifiedDocumentsIndexed;
        private Long numberOfNewDocumentsIndexed;

        private BuilderImpl() {
        }

        private BuilderImpl(IngestionJobStatistics model) {
            this.numberOfDocumentsDeleted(model.numberOfDocumentsDeleted);
            this.numberOfDocumentsFailed(model.numberOfDocumentsFailed);
            this.numberOfDocumentsScanned(model.numberOfDocumentsScanned);
            this.numberOfMetadataDocumentsModified(model.numberOfMetadataDocumentsModified);
            this.numberOfMetadataDocumentsScanned(model.numberOfMetadataDocumentsScanned);
            this.numberOfModifiedDocumentsIndexed(model.numberOfModifiedDocumentsIndexed);
            this.numberOfNewDocumentsIndexed(model.numberOfNewDocumentsIndexed);
        }

        public final Long getNumberOfDocumentsDeleted() {
            return this.numberOfDocumentsDeleted;
        }

        public final void setNumberOfDocumentsDeleted(Long numberOfDocumentsDeleted) {
            this.numberOfDocumentsDeleted = numberOfDocumentsDeleted;
        }

        @Override
        public final Builder numberOfDocumentsDeleted(Long numberOfDocumentsDeleted) {
            this.numberOfDocumentsDeleted = numberOfDocumentsDeleted;
            return this;
        }

        public final Long getNumberOfDocumentsFailed() {
            return this.numberOfDocumentsFailed;
        }

        public final void setNumberOfDocumentsFailed(Long numberOfDocumentsFailed) {
            this.numberOfDocumentsFailed = numberOfDocumentsFailed;
        }

        @Override
        public final Builder numberOfDocumentsFailed(Long numberOfDocumentsFailed) {
            this.numberOfDocumentsFailed = numberOfDocumentsFailed;
            return this;
        }

        public final Long getNumberOfDocumentsScanned() {
            return this.numberOfDocumentsScanned;
        }

        public final void setNumberOfDocumentsScanned(Long numberOfDocumentsScanned) {
            this.numberOfDocumentsScanned = numberOfDocumentsScanned;
        }

        @Override
        public final Builder numberOfDocumentsScanned(Long numberOfDocumentsScanned) {
            this.numberOfDocumentsScanned = numberOfDocumentsScanned;
            return this;
        }

        public final Long getNumberOfMetadataDocumentsModified() {
            return this.numberOfMetadataDocumentsModified;
        }

        public final void setNumberOfMetadataDocumentsModified(Long numberOfMetadataDocumentsModified) {
            this.numberOfMetadataDocumentsModified = numberOfMetadataDocumentsModified;
        }

        @Override
        public final Builder numberOfMetadataDocumentsModified(Long numberOfMetadataDocumentsModified) {
            this.numberOfMetadataDocumentsModified = numberOfMetadataDocumentsModified;
            return this;
        }

        public final Long getNumberOfMetadataDocumentsScanned() {
            return this.numberOfMetadataDocumentsScanned;
        }

        public final void setNumberOfMetadataDocumentsScanned(Long numberOfMetadataDocumentsScanned) {
            this.numberOfMetadataDocumentsScanned = numberOfMetadataDocumentsScanned;
        }

        @Override
        public final Builder numberOfMetadataDocumentsScanned(Long numberOfMetadataDocumentsScanned) {
            this.numberOfMetadataDocumentsScanned = numberOfMetadataDocumentsScanned;
            return this;
        }

        public final Long getNumberOfModifiedDocumentsIndexed() {
            return this.numberOfModifiedDocumentsIndexed;
        }

        public final void setNumberOfModifiedDocumentsIndexed(Long numberOfModifiedDocumentsIndexed) {
            this.numberOfModifiedDocumentsIndexed = numberOfModifiedDocumentsIndexed;
        }

        @Override
        public final Builder numberOfModifiedDocumentsIndexed(Long numberOfModifiedDocumentsIndexed) {
            this.numberOfModifiedDocumentsIndexed = numberOfModifiedDocumentsIndexed;
            return this;
        }

        public final Long getNumberOfNewDocumentsIndexed() {
            return this.numberOfNewDocumentsIndexed;
        }

        public final void setNumberOfNewDocumentsIndexed(Long numberOfNewDocumentsIndexed) {
            this.numberOfNewDocumentsIndexed = numberOfNewDocumentsIndexed;
        }

        @Override
        public final Builder numberOfNewDocumentsIndexed(Long numberOfNewDocumentsIndexed) {
            this.numberOfNewDocumentsIndexed = numberOfNewDocumentsIndexed;
            return this;
        }

        public IngestionJobStatistics build() {
            return new IngestionJobStatistics(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, IngestionJobStatistics> {
        public Builder numberOfDocumentsDeleted(Long var1);

        public Builder numberOfDocumentsFailed(Long var1);

        public Builder numberOfDocumentsScanned(Long var1);

        public Builder numberOfMetadataDocumentsModified(Long var1);

        public Builder numberOfMetadataDocumentsScanned(Long var1);

        public Builder numberOfModifiedDocumentsIndexed(Long var1);

        public Builder numberOfNewDocumentsIndexed(Long var1);
    }
}

