/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagent.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.bedrockagent.model.BedrockAgentRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StopIngestionJobRequest
extends BedrockAgentRequest
implements ToCopyableBuilder<Builder, StopIngestionJobRequest> {
    private static final SdkField<String> DATA_SOURCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("dataSourceId").getter(StopIngestionJobRequest.getter(StopIngestionJobRequest::dataSourceId)).setter(StopIngestionJobRequest.setter(Builder::dataSourceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("dataSourceId").build()}).build();
    private static final SdkField<String> INGESTION_JOB_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ingestionJobId").getter(StopIngestionJobRequest.getter(StopIngestionJobRequest::ingestionJobId)).setter(StopIngestionJobRequest.setter(Builder::ingestionJobId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("ingestionJobId").build()}).build();
    private static final SdkField<String> KNOWLEDGE_BASE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("knowledgeBaseId").getter(StopIngestionJobRequest.getter(StopIngestionJobRequest::knowledgeBaseId)).setter(StopIngestionJobRequest.setter(Builder::knowledgeBaseId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("knowledgeBaseId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATA_SOURCE_ID_FIELD, INGESTION_JOB_ID_FIELD, KNOWLEDGE_BASE_ID_FIELD));
    private final String dataSourceId;
    private final String ingestionJobId;
    private final String knowledgeBaseId;

    private StopIngestionJobRequest(BuilderImpl builder) {
        super(builder);
        this.dataSourceId = builder.dataSourceId;
        this.ingestionJobId = builder.ingestionJobId;
        this.knowledgeBaseId = builder.knowledgeBaseId;
    }

    public final String dataSourceId() {
        return this.dataSourceId;
    }

    public final String ingestionJobId() {
        return this.ingestionJobId;
    }

    public final String knowledgeBaseId() {
        return this.knowledgeBaseId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.dataSourceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.ingestionJobId());
        hashCode = 31 * hashCode + Objects.hashCode(this.knowledgeBaseId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StopIngestionJobRequest)) {
            return false;
        }
        StopIngestionJobRequest other = (StopIngestionJobRequest)((Object)obj);
        return Objects.equals(this.dataSourceId(), other.dataSourceId()) && Objects.equals(this.ingestionJobId(), other.ingestionJobId()) && Objects.equals(this.knowledgeBaseId(), other.knowledgeBaseId());
    }

    public final String toString() {
        return ToString.builder((String)"StopIngestionJobRequest").add("DataSourceId", (Object)this.dataSourceId()).add("IngestionJobId", (Object)this.ingestionJobId()).add("KnowledgeBaseId", (Object)this.knowledgeBaseId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "dataSourceId": {
                return Optional.ofNullable(clazz.cast(this.dataSourceId()));
            }
            case "ingestionJobId": {
                return Optional.ofNullable(clazz.cast(this.ingestionJobId()));
            }
            case "knowledgeBaseId": {
                return Optional.ofNullable(clazz.cast(this.knowledgeBaseId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StopIngestionJobRequest, T> g) {
        return obj -> g.apply((StopIngestionJobRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BedrockAgentRequest.BuilderImpl
    implements Builder {
        private String dataSourceId;
        private String ingestionJobId;
        private String knowledgeBaseId;

        private BuilderImpl() {
        }

        private BuilderImpl(StopIngestionJobRequest model) {
            super(model);
            this.dataSourceId(model.dataSourceId);
            this.ingestionJobId(model.ingestionJobId);
            this.knowledgeBaseId(model.knowledgeBaseId);
        }

        public final String getDataSourceId() {
            return this.dataSourceId;
        }

        public final void setDataSourceId(String dataSourceId) {
            this.dataSourceId = dataSourceId;
        }

        @Override
        public final Builder dataSourceId(String dataSourceId) {
            this.dataSourceId = dataSourceId;
            return this;
        }

        public final String getIngestionJobId() {
            return this.ingestionJobId;
        }

        public final void setIngestionJobId(String ingestionJobId) {
            this.ingestionJobId = ingestionJobId;
        }

        @Override
        public final Builder ingestionJobId(String ingestionJobId) {
            this.ingestionJobId = ingestionJobId;
            return this;
        }

        public final String getKnowledgeBaseId() {
            return this.knowledgeBaseId;
        }

        public final void setKnowledgeBaseId(String knowledgeBaseId) {
            this.knowledgeBaseId = knowledgeBaseId;
        }

        @Override
        public final Builder knowledgeBaseId(String knowledgeBaseId) {
            this.knowledgeBaseId = knowledgeBaseId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StopIngestionJobRequest build() {
            return new StopIngestionJobRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends BedrockAgentRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, StopIngestionJobRequest> {
        public Builder dataSourceId(String var1);

        public Builder ingestionJobId(String var1);

        public Builder knowledgeBaseId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

