/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagent.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.bedrockagent.model.FlowConnection;
import software.amazon.awssdk.services.bedrockagent.model.FlowConnectionsCopier;
import software.amazon.awssdk.services.bedrockagent.model.FlowNode;
import software.amazon.awssdk.services.bedrockagent.model.FlowNodesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class FlowDefinition
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, FlowDefinition> {
    private static final SdkField<List<FlowConnection>> CONNECTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("connections").getter(FlowDefinition.getter(FlowDefinition::connections)).setter(FlowDefinition.setter(Builder::connections)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connections").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(FlowConnection::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<FlowNode>> NODES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("nodes").getter(FlowDefinition.getter(FlowDefinition::nodes)).setter(FlowDefinition.setter(Builder::nodes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nodes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(FlowNode::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONNECTIONS_FIELD, NODES_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<FlowConnection> connections;
    private final List<FlowNode> nodes;

    private FlowDefinition(BuilderImpl builder) {
        this.connections = builder.connections;
        this.nodes = builder.nodes;
    }

    public final boolean hasConnections() {
        return this.connections != null && !(this.connections instanceof SdkAutoConstructList);
    }

    public final List<FlowConnection> connections() {
        return this.connections;
    }

    public final boolean hasNodes() {
        return this.nodes != null && !(this.nodes instanceof SdkAutoConstructList);
    }

    public final List<FlowNode> nodes() {
        return this.nodes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasConnections() ? this.connections() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasNodes() ? this.nodes() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FlowDefinition)) {
            return false;
        }
        FlowDefinition other = (FlowDefinition)obj;
        return this.hasConnections() == other.hasConnections() && Objects.equals(this.connections(), other.connections()) && this.hasNodes() == other.hasNodes() && Objects.equals(this.nodes(), other.nodes());
    }

    public final String toString() {
        return ToString.builder((String)"FlowDefinition").add("Connections", this.hasConnections() ? this.connections() : null).add("Nodes", this.hasNodes() ? this.nodes() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "connections": {
                return Optional.ofNullable(clazz.cast(this.connections()));
            }
            case "nodes": {
                return Optional.ofNullable(clazz.cast(this.nodes()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FlowDefinition, T> g) {
        return obj -> g.apply((FlowDefinition)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<FlowConnection> connections = DefaultSdkAutoConstructList.getInstance();
        private List<FlowNode> nodes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(FlowDefinition model) {
            this.connections(model.connections);
            this.nodes(model.nodes);
        }

        public final List<FlowConnection.Builder> getConnections() {
            List<FlowConnection.Builder> result = FlowConnectionsCopier.copyToBuilder(this.connections);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setConnections(Collection<FlowConnection.BuilderImpl> connections) {
            this.connections = FlowConnectionsCopier.copyFromBuilder(connections);
        }

        @Override
        public final Builder connections(Collection<FlowConnection> connections) {
            this.connections = FlowConnectionsCopier.copy(connections);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder connections(FlowConnection ... connections) {
            this.connections(Arrays.asList(connections));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder connections(Consumer<FlowConnection.Builder> ... connections) {
            this.connections(Stream.of(connections).map(c -> (FlowConnection)((FlowConnection.Builder)FlowConnection.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<FlowNode.Builder> getNodes() {
            List<FlowNode.Builder> result = FlowNodesCopier.copyToBuilder(this.nodes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setNodes(Collection<FlowNode.BuilderImpl> nodes) {
            this.nodes = FlowNodesCopier.copyFromBuilder(nodes);
        }

        @Override
        public final Builder nodes(Collection<FlowNode> nodes) {
            this.nodes = FlowNodesCopier.copy(nodes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder nodes(FlowNode ... nodes) {
            this.nodes(Arrays.asList(nodes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder nodes(Consumer<FlowNode.Builder> ... nodes) {
            this.nodes(Stream.of(nodes).map(c -> (FlowNode)((FlowNode.Builder)FlowNode.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public FlowDefinition build() {
            return new FlowDefinition(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, FlowDefinition> {
        public Builder connections(Collection<FlowConnection> var1);

        public Builder connections(FlowConnection ... var1);

        public Builder connections(Consumer<FlowConnection.Builder> ... var1);

        public Builder nodes(Collection<FlowNode> var1);

        public Builder nodes(FlowNode ... var1);

        public Builder nodes(Consumer<FlowNode.Builder> ... var1);
    }
}

