/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagent.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.bedrockagent.model.PromptFlowNodeInlineConfiguration;
import software.amazon.awssdk.services.bedrockagent.model.PromptFlowNodeResourceConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PromptFlowNodeSourceConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PromptFlowNodeSourceConfiguration> {
    private static final SdkField<PromptFlowNodeInlineConfiguration> INLINE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("inline").getter(PromptFlowNodeSourceConfiguration.getter(PromptFlowNodeSourceConfiguration::inline)).setter(PromptFlowNodeSourceConfiguration.setter(Builder::inline)).constructor(PromptFlowNodeInlineConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inline").build()}).build();
    private static final SdkField<PromptFlowNodeResourceConfiguration> RESOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("resource").getter(PromptFlowNodeSourceConfiguration.getter(PromptFlowNodeSourceConfiguration::resource)).setter(PromptFlowNodeSourceConfiguration.setter(Builder::resource)).constructor(PromptFlowNodeResourceConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resource").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INLINE_FIELD, RESOURCE_FIELD));
    private static final long serialVersionUID = 1L;
    private final PromptFlowNodeInlineConfiguration inline;
    private final PromptFlowNodeResourceConfiguration resource;
    private final Type type;

    private PromptFlowNodeSourceConfiguration(BuilderImpl builder) {
        this.inline = builder.inline;
        this.resource = builder.resource;
        this.type = builder.type;
    }

    public final PromptFlowNodeInlineConfiguration inline() {
        return this.inline;
    }

    public final PromptFlowNodeResourceConfiguration resource() {
        return this.resource;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.inline());
        hashCode = 31 * hashCode + Objects.hashCode(this.resource());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PromptFlowNodeSourceConfiguration)) {
            return false;
        }
        PromptFlowNodeSourceConfiguration other = (PromptFlowNodeSourceConfiguration)obj;
        return Objects.equals(this.inline(), other.inline()) && Objects.equals(this.resource(), other.resource());
    }

    public final String toString() {
        return ToString.builder((String)"PromptFlowNodeSourceConfiguration").add("Inline", (Object)this.inline()).add("Resource", (Object)this.resource()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "inline": {
                return Optional.ofNullable(clazz.cast(this.inline()));
            }
            case "resource": {
                return Optional.ofNullable(clazz.cast(this.resource()));
            }
        }
        return Optional.empty();
    }

    public static PromptFlowNodeSourceConfiguration fromInline(PromptFlowNodeInlineConfiguration inline) {
        return (PromptFlowNodeSourceConfiguration)PromptFlowNodeSourceConfiguration.builder().inline(inline).build();
    }

    public static PromptFlowNodeSourceConfiguration fromInline(Consumer<PromptFlowNodeInlineConfiguration.Builder> inline) {
        PromptFlowNodeInlineConfiguration.Builder builder = PromptFlowNodeInlineConfiguration.builder();
        inline.accept(builder);
        return PromptFlowNodeSourceConfiguration.fromInline((PromptFlowNodeInlineConfiguration)builder.build());
    }

    public static PromptFlowNodeSourceConfiguration fromResource(PromptFlowNodeResourceConfiguration resource) {
        return (PromptFlowNodeSourceConfiguration)PromptFlowNodeSourceConfiguration.builder().resource(resource).build();
    }

    public static PromptFlowNodeSourceConfiguration fromResource(Consumer<PromptFlowNodeResourceConfiguration.Builder> resource) {
        PromptFlowNodeResourceConfiguration.Builder builder = PromptFlowNodeResourceConfiguration.builder();
        resource.accept(builder);
        return PromptFlowNodeSourceConfiguration.fromResource((PromptFlowNodeResourceConfiguration)builder.build());
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PromptFlowNodeSourceConfiguration, T> g) {
        return obj -> g.apply((PromptFlowNodeSourceConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        INLINE,
        RESOURCE,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private PromptFlowNodeInlineConfiguration inline;
        private PromptFlowNodeResourceConfiguration resource;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(PromptFlowNodeSourceConfiguration model) {
            this.inline(model.inline);
            this.resource(model.resource);
        }

        public final PromptFlowNodeInlineConfiguration.Builder getInline() {
            return this.inline != null ? this.inline.toBuilder() : null;
        }

        public final void setInline(PromptFlowNodeInlineConfiguration.BuilderImpl inline) {
            PromptFlowNodeInlineConfiguration oldValue = this.inline;
            this.inline = inline != null ? inline.build() : null;
            this.handleUnionValueChange(Type.INLINE, oldValue, this.inline);
        }

        @Override
        public final Builder inline(PromptFlowNodeInlineConfiguration inline) {
            PromptFlowNodeInlineConfiguration oldValue = this.inline;
            this.inline = inline;
            this.handleUnionValueChange(Type.INLINE, oldValue, this.inline);
            return this;
        }

        public final PromptFlowNodeResourceConfiguration.Builder getResource() {
            return this.resource != null ? this.resource.toBuilder() : null;
        }

        public final void setResource(PromptFlowNodeResourceConfiguration.BuilderImpl resource) {
            PromptFlowNodeResourceConfiguration oldValue = this.resource;
            this.resource = resource != null ? resource.build() : null;
            this.handleUnionValueChange(Type.RESOURCE, oldValue, this.resource);
        }

        @Override
        public final Builder resource(PromptFlowNodeResourceConfiguration resource) {
            PromptFlowNodeResourceConfiguration oldValue = this.resource;
            this.resource = resource;
            this.handleUnionValueChange(Type.RESOURCE, oldValue, this.resource);
            return this;
        }

        public PromptFlowNodeSourceConfiguration build() {
            return new PromptFlowNodeSourceConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PromptFlowNodeSourceConfiguration> {
        public Builder inline(PromptFlowNodeInlineConfiguration var1);

        default public Builder inline(Consumer<PromptFlowNodeInlineConfiguration.Builder> inline) {
            return this.inline((PromptFlowNodeInlineConfiguration)((PromptFlowNodeInlineConfiguration.Builder)PromptFlowNodeInlineConfiguration.builder().applyMutation(inline)).build());
        }

        public Builder resource(PromptFlowNodeResourceConfiguration var1);

        default public Builder resource(Consumer<PromptFlowNodeResourceConfiguration.Builder> resource) {
            return this.resource((PromptFlowNodeResourceConfiguration)((PromptFlowNodeResourceConfiguration.Builder)PromptFlowNodeResourceConfiguration.builder().applyMutation(resource)).build());
        }
    }
}

