/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagent.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.bedrockagent.model.IntermediateStorage;
import software.amazon.awssdk.services.bedrockagent.model.Transformation;
import software.amazon.awssdk.services.bedrockagent.model.TransformationsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CustomTransformationConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CustomTransformationConfiguration> {
    private static final SdkField<IntermediateStorage> INTERMEDIATE_STORAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("intermediateStorage").getter(CustomTransformationConfiguration.getter(CustomTransformationConfiguration::intermediateStorage)).setter(CustomTransformationConfiguration.setter(Builder::intermediateStorage)).constructor(IntermediateStorage::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("intermediateStorage").build()}).build();
    private static final SdkField<List<Transformation>> TRANSFORMATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("transformations").getter(CustomTransformationConfiguration.getter(CustomTransformationConfiguration::transformations)).setter(CustomTransformationConfiguration.setter(Builder::transformations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("transformations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Transformation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INTERMEDIATE_STORAGE_FIELD, TRANSFORMATIONS_FIELD));
    private static final long serialVersionUID = 1L;
    private final IntermediateStorage intermediateStorage;
    private final List<Transformation> transformations;

    private CustomTransformationConfiguration(BuilderImpl builder) {
        this.intermediateStorage = builder.intermediateStorage;
        this.transformations = builder.transformations;
    }

    public final IntermediateStorage intermediateStorage() {
        return this.intermediateStorage;
    }

    public final boolean hasTransformations() {
        return this.transformations != null && !(this.transformations instanceof SdkAutoConstructList);
    }

    public final List<Transformation> transformations() {
        return this.transformations;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.intermediateStorage());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTransformations() ? this.transformations() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CustomTransformationConfiguration)) {
            return false;
        }
        CustomTransformationConfiguration other = (CustomTransformationConfiguration)obj;
        return Objects.equals(this.intermediateStorage(), other.intermediateStorage()) && this.hasTransformations() == other.hasTransformations() && Objects.equals(this.transformations(), other.transformations());
    }

    public final String toString() {
        return ToString.builder((String)"CustomTransformationConfiguration").add("IntermediateStorage", (Object)this.intermediateStorage()).add("Transformations", this.hasTransformations() ? this.transformations() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "intermediateStorage": {
                return Optional.ofNullable(clazz.cast(this.intermediateStorage()));
            }
            case "transformations": {
                return Optional.ofNullable(clazz.cast(this.transformations()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CustomTransformationConfiguration, T> g) {
        return obj -> g.apply((CustomTransformationConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private IntermediateStorage intermediateStorage;
        private List<Transformation> transformations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CustomTransformationConfiguration model) {
            this.intermediateStorage(model.intermediateStorage);
            this.transformations(model.transformations);
        }

        public final IntermediateStorage.Builder getIntermediateStorage() {
            return this.intermediateStorage != null ? this.intermediateStorage.toBuilder() : null;
        }

        public final void setIntermediateStorage(IntermediateStorage.BuilderImpl intermediateStorage) {
            this.intermediateStorage = intermediateStorage != null ? intermediateStorage.build() : null;
        }

        @Override
        public final Builder intermediateStorage(IntermediateStorage intermediateStorage) {
            this.intermediateStorage = intermediateStorage;
            return this;
        }

        public final List<Transformation.Builder> getTransformations() {
            List<Transformation.Builder> result = TransformationsCopier.copyToBuilder(this.transformations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTransformations(Collection<Transformation.BuilderImpl> transformations) {
            this.transformations = TransformationsCopier.copyFromBuilder(transformations);
        }

        @Override
        public final Builder transformations(Collection<Transformation> transformations) {
            this.transformations = TransformationsCopier.copy(transformations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder transformations(Transformation ... transformations) {
            this.transformations(Arrays.asList(transformations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder transformations(Consumer<Transformation.Builder> ... transformations) {
            this.transformations(Stream.of(transformations).map(c -> (Transformation)((Transformation.Builder)Transformation.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public CustomTransformationConfiguration build() {
            return new CustomTransformationConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CustomTransformationConfiguration> {
        public Builder intermediateStorage(IntermediateStorage var1);

        default public Builder intermediateStorage(Consumer<IntermediateStorage.Builder> intermediateStorage) {
            return this.intermediateStorage((IntermediateStorage)((IntermediateStorage.Builder)IntermediateStorage.builder().applyMutation(intermediateStorage)).build());
        }

        public Builder transformations(Collection<Transformation> var1);

        public Builder transformations(Transformation ... var1);

        public Builder transformations(Consumer<Transformation.Builder> ... var1);
    }
}

