/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagent.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.bedrockagent.model.ConfluenceCrawlerConfiguration;
import software.amazon.awssdk.services.bedrockagent.model.ConfluenceSourceConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ConfluenceDataSourceConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ConfluenceDataSourceConfiguration> {
    private static final SdkField<ConfluenceCrawlerConfiguration> CRAWLER_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("crawlerConfiguration").getter(ConfluenceDataSourceConfiguration.getter(ConfluenceDataSourceConfiguration::crawlerConfiguration)).setter(ConfluenceDataSourceConfiguration.setter(Builder::crawlerConfiguration)).constructor(ConfluenceCrawlerConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("crawlerConfiguration").build()}).build();
    private static final SdkField<ConfluenceSourceConfiguration> SOURCE_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("sourceConfiguration").getter(ConfluenceDataSourceConfiguration.getter(ConfluenceDataSourceConfiguration::sourceConfiguration)).setter(ConfluenceDataSourceConfiguration.setter(Builder::sourceConfiguration)).constructor(ConfluenceSourceConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CRAWLER_CONFIGURATION_FIELD, SOURCE_CONFIGURATION_FIELD));
    private static final long serialVersionUID = 1L;
    private final ConfluenceCrawlerConfiguration crawlerConfiguration;
    private final ConfluenceSourceConfiguration sourceConfiguration;

    private ConfluenceDataSourceConfiguration(BuilderImpl builder) {
        this.crawlerConfiguration = builder.crawlerConfiguration;
        this.sourceConfiguration = builder.sourceConfiguration;
    }

    public final ConfluenceCrawlerConfiguration crawlerConfiguration() {
        return this.crawlerConfiguration;
    }

    public final ConfluenceSourceConfiguration sourceConfiguration() {
        return this.sourceConfiguration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.crawlerConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConfluenceDataSourceConfiguration)) {
            return false;
        }
        ConfluenceDataSourceConfiguration other = (ConfluenceDataSourceConfiguration)obj;
        return Objects.equals(this.crawlerConfiguration(), other.crawlerConfiguration()) && Objects.equals(this.sourceConfiguration(), other.sourceConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"ConfluenceDataSourceConfiguration").add("CrawlerConfiguration", (Object)this.crawlerConfiguration()).add("SourceConfiguration", (Object)this.sourceConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "crawlerConfiguration": {
                return Optional.ofNullable(clazz.cast(this.crawlerConfiguration()));
            }
            case "sourceConfiguration": {
                return Optional.ofNullable(clazz.cast(this.sourceConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ConfluenceDataSourceConfiguration, T> g) {
        return obj -> g.apply((ConfluenceDataSourceConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private ConfluenceCrawlerConfiguration crawlerConfiguration;
        private ConfluenceSourceConfiguration sourceConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(ConfluenceDataSourceConfiguration model) {
            this.crawlerConfiguration(model.crawlerConfiguration);
            this.sourceConfiguration(model.sourceConfiguration);
        }

        public final ConfluenceCrawlerConfiguration.Builder getCrawlerConfiguration() {
            return this.crawlerConfiguration != null ? this.crawlerConfiguration.toBuilder() : null;
        }

        public final void setCrawlerConfiguration(ConfluenceCrawlerConfiguration.BuilderImpl crawlerConfiguration) {
            this.crawlerConfiguration = crawlerConfiguration != null ? crawlerConfiguration.build() : null;
        }

        @Override
        public final Builder crawlerConfiguration(ConfluenceCrawlerConfiguration crawlerConfiguration) {
            this.crawlerConfiguration = crawlerConfiguration;
            return this;
        }

        public final ConfluenceSourceConfiguration.Builder getSourceConfiguration() {
            return this.sourceConfiguration != null ? this.sourceConfiguration.toBuilder() : null;
        }

        public final void setSourceConfiguration(ConfluenceSourceConfiguration.BuilderImpl sourceConfiguration) {
            this.sourceConfiguration = sourceConfiguration != null ? sourceConfiguration.build() : null;
        }

        @Override
        public final Builder sourceConfiguration(ConfluenceSourceConfiguration sourceConfiguration) {
            this.sourceConfiguration = sourceConfiguration;
            return this;
        }

        public ConfluenceDataSourceConfiguration build() {
            return new ConfluenceDataSourceConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ConfluenceDataSourceConfiguration> {
        public Builder crawlerConfiguration(ConfluenceCrawlerConfiguration var1);

        default public Builder crawlerConfiguration(Consumer<ConfluenceCrawlerConfiguration.Builder> crawlerConfiguration) {
            return this.crawlerConfiguration((ConfluenceCrawlerConfiguration)((ConfluenceCrawlerConfiguration.Builder)ConfluenceCrawlerConfiguration.builder().applyMutation(crawlerConfiguration)).build());
        }

        public Builder sourceConfiguration(ConfluenceSourceConfiguration var1);

        default public Builder sourceConfiguration(Consumer<ConfluenceSourceConfiguration.Builder> sourceConfiguration) {
            return this.sourceConfiguration((ConfluenceSourceConfiguration)((ConfluenceSourceConfiguration.Builder)ConfluenceSourceConfiguration.builder().applyMutation(sourceConfiguration)).build());
        }
    }
}

